#ifndef _ELM_SYSTRAY_EO_LEGACY_H_
#define _ELM_SYSTRAY_EO_LEGACY_H_

#ifndef _ELM_SYSTRAY_EO_CLASS_TYPE
#define _ELM_SYSTRAY_EO_CLASS_TYPE

typedef Eo Elm_Systray;

#endif

#ifndef _ELM_SYSTRAY_EO_TYPES
#define _ELM_SYSTRAY_EO_TYPES


#endif

/**
 *
 * Set the id of the Status Notifier Item.
 *
 * @param[in] id No description supplied.
 */
EAPI void elm_systray_id_set(Elm_Systray *obj, const char *id);

/**
 *
 * Get the id of the Status Notifier Item.
 *
 */
EAPI const char *elm_systray_id_get(const Elm_Systray *obj);

/**
 *
 * Set the category of the Status Notifier Item.
 *
 * @param[in] cat Category
 */
EAPI void elm_systray_category_set(Elm_Systray *obj, Elm_Systray_Category cat);

/**
 *
 * Get the category of the Status Notifier Item.
 *
 */
EAPI Elm_Systray_Category elm_systray_category_get(const Elm_Systray *obj);

/**
 *
 * Set the path to the theme where the icons can be found. Set this value to "" to use the default path.
 *
 * @param[in] icon_theme_path No description supplied.
 */
EAPI void elm_systray_icon_theme_path_set(Elm_Systray *obj, const char *icon_theme_path);

/**
 *
 * Get the path to the icon's theme currently in use.
 *
 */
EAPI const char *elm_systray_icon_theme_path_get(const Elm_Systray *obj);

/**
 *
 * Set the object path of the D-Bus Menu that is to be show when the Status Notifier Item is activated by the user.
 *
 * @param[in] menu No description supplied.
 */
EAPI void elm_systray_menu_set(Elm_Systray *obj, const Eo *menu);

/**
 *
 * Get the object path of the D-Bus Menu currently in use.
 *
 */
EAPI const Eo *elm_systray_menu_get(const Elm_Systray *obj);

/**
 *
 * Set the name of the attention icon to be used by the Status Notifier Item.
 *
 * @param[in] att_icon_name No description supplied.
 */
EAPI void elm_systray_att_icon_name_set(Elm_Systray *obj, const char *att_icon_name);

/**
 *
 * Get the name of the attention icon used by the Status Notifier Item.
 *
 */
EAPI const char *elm_systray_att_icon_name_get(const Elm_Systray *obj);

/**
 *
 * Set the status of the Status Notifier Item.
 *
 * @param[in] st Status
 */
EAPI void elm_systray_status_set(Elm_Systray *obj, Elm_Systray_Status st);

/**
 *
 * Get the status of the Status Notifier Item.
 *
 */
EAPI Elm_Systray_Status elm_systray_status_get(const Elm_Systray *obj);

/**
 *
 * Set the name of the icon to be used by the Status Notifier Item.
 *
 * @param[in] icon_name No description supplied.
 */
EAPI void elm_systray_icon_name_set(Elm_Systray *obj, const char *icon_name);

/**
 *
 * Get the name of the icon used by the Status Notifier Item.
 *
 */
EAPI const char *elm_systray_icon_name_get(const Elm_Systray *obj);

/**
 *
 * Set the title of the Status Notifier Item.
 *
 * @param[in] title No description supplied.
 */
EAPI void elm_systray_title_set(Elm_Systray *obj, const char *title);

/**
 *
 * Get the title of the Status Notifier Item.
 *
 */
EAPI const char *elm_systray_title_get(const Elm_Systray *obj);

/**
 *
 * Register this Status Notifier Item in the System Tray Watcher. This function should only be called after the event #ELM_EVENT_SYSTRAY_READY is emitted.
 * 
 *
 */
EAPI Eina_Bool elm_systray_register(Elm_Systray *obj);

#endif
