/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Widget;

public class Caret
extends Widget {
    Canvas parent;
    int x;
    int y;
    int width;
    int height;
    boolean isVisible;
    boolean isShowing;
    int blinkRate;
    Image image;
    Font font;
    static final int DEFAULT_WIDTH = 1;

    public Caret(Canvas canvas, int n) {
        super(canvas, n);
        this.parent = canvas;
        this.createWidget(0);
    }

    boolean blinkCaret() {
        if (!this.isVisible) {
            return true;
        }
        if (!this.isShowing) {
            return this.showCaret();
        }
        if (this.blinkRate == 0) {
            return true;
        }
        return this.hideCaret();
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.blinkRate = this.display.getCaretBlinkTime();
        this.isVisible = true;
        if (this.parent.getCaret() == null) {
            this.parent.setCaret(this);
        }
    }

    boolean drawCaret() {
        if (this.parent == null) {
            return false;
        }
        if (this.parent.isDisposed()) {
            return false;
        }
        long l = this.parent.paintWindow();
        if (OS.USE_CAIRO) {
            long l2 = OS.gdk_cairo_create(l);
            if (l2 == 0L) {
                this.error(2);
            }
            Cairo.cairo_set_source_rgb(l2, 1.0, 1.0, 1.0);
            Cairo.cairo_set_operator(l2, 23);
            if (this.image != null && !this.image.isDisposed() && this.image.mask == 0L) {
                long l3 = Cairo.cairo_get_target(l2);
                int n = 0;
                switch (Cairo.cairo_surface_get_type(l3)) {
                    case 0: {
                        n = Cairo.cairo_image_surface_get_width(l3);
                        break;
                    }
                    case 3: {
                        n = Cairo.cairo_xlib_surface_get_width(l3);
                    }
                }
                int n2 = this.x;
                if ((this.parent.style & 0x8000000) != 0) {
                    n2 = this.parent.getClientWidth() - n - n2;
                }
                Cairo.cairo_translate(l2, n2, this.y);
                Cairo.cairo_set_source_surface(l2, this.image.surface, 0.0, 0.0);
                Cairo.cairo_paint(l2);
            } else {
                int n = this.width;
                int n3 = this.height;
                if (n <= 0) {
                    n = 1;
                }
                int n4 = this.x;
                if ((this.parent.style & 0x8000000) != 0) {
                    n4 = this.parent.getClientWidth() - n - n4;
                }
                Cairo.cairo_rectangle(l2, n4, this.y, n, n3);
            }
            Cairo.cairo_fill(l2);
            Cairo.cairo_destroy(l2);
            return true;
        }
        long l4 = OS.gdk_gc_new(l);
        GdkColor gdkColor = new GdkColor();
        gdkColor.red = (short)-1;
        gdkColor.green = (short)-1;
        gdkColor.blue = (short)-1;
        long l5 = OS.gdk_colormap_get_system();
        OS.gdk_colormap_alloc_color(l5, gdkColor, true, true);
        OS.gdk_gc_set_foreground(l4, gdkColor);
        OS.gdk_gc_set_function(l4, 2L);
        if (this.image != null && !this.image.isDisposed() && this.image.mask == 0L) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.gdk_pixmap_get_size(this.image.pixmap, nArray, nArray2);
            int n = this.x;
            if ((this.parent.style & 0x8000000) != 0) {
                n = this.parent.getClientWidth() - nArray[0] - n;
            }
            OS.gdk_draw_drawable(l, l4, this.image.pixmap, 0, 0, n, this.y, nArray[0], nArray2[0]);
        } else {
            int n = this.width;
            int n5 = this.height;
            if (n <= 0) {
                n = 1;
            }
            int n6 = this.x;
            if ((this.parent.style & 0x8000000) != 0) {
                n6 = this.parent.getClientWidth() - n - n6;
            }
            OS.gdk_draw_rectangle(l, l4, 1, n6, this.y, n, n5);
        }
        OS.g_object_unref(l4);
        OS.gdk_colormap_free_colors(l5, gdkColor, 1);
        return true;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rectangle = this.image.getBounds();
            return new Rectangle(this.x, this.y, rectangle.width, rectangle.height);
        }
        if (this.width == 0) {
            return new Rectangle(this.x, this.y, 1, this.height);
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Point getLocation() {
        this.checkWidget();
        return new Point(this.x, this.y);
    }

    public Canvas getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Point getSize() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rectangle = this.image.getBounds();
            return new Point(rectangle.width, rectangle.height);
        }
        if (this.width == 0) {
            return new Point(1, this.height);
        }
        return new Point(this.width, this.height);
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.isVisible;
    }

    boolean hideCaret() {
        if (!this.isShowing) {
            return true;
        }
        this.isShowing = false;
        return this.drawCaret();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.isVisible && this.parent.isVisible() && this.parent.hasFocus();
    }

    boolean isFocusCaret() {
        return this == this.display.currentCaret;
    }

    void killFocus() {
        if (this.display.currentCaret != this) {
            return;
        }
        this.display.setCurrentCaret(null);
        if (this.isVisible) {
            this.hideCaret();
        }
    }

    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getCaret()) {
            this.parent.setCaret(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.display.currentCaret == this) {
            this.hideCaret();
            this.display.setCurrentCaret(null);
        }
        this.parent = null;
        this.image = null;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.checkWidget();
        if (this.x == n && this.y == n2 && this.width == n3 && this.height == n4) {
            return;
        }
        boolean bl = this.isFocusCaret();
        if (bl && this.isVisible) {
            this.hideCaret();
        }
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.parent.updateCaret();
        if (bl && this.isVisible) {
            this.showCaret();
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void setFocus() {
        if (this.display.currentCaret == this) {
            return;
        }
        this.display.setCurrentCaret(this);
        if (this.isVisible) {
            this.showCaret();
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
    }

    public void setImage(Image image) {
        boolean bl;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((bl = this.isFocusCaret()) && this.isVisible) {
            this.hideCaret();
        }
        this.image = image;
        if (bl && this.isVisible) {
            this.showCaret();
        }
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.setBounds(n, n2, this.width, this.height);
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setSize(int n, int n2) {
        this.checkWidget();
        this.setBounds(this.x, this.y, n, n2);
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSize(point.x, point.y);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (bl == this.isVisible) {
            return;
        }
        this.isVisible = bl;
        if (!this.isFocusCaret()) {
            return;
        }
        if (this.isVisible) {
            this.showCaret();
        } else {
            this.hideCaret();
        }
    }

    boolean showCaret() {
        if (this.isShowing) {
            return true;
        }
        this.isShowing = true;
        return this.drawCaret();
    }
}

