/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.scripting;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.scripting.ApplyRefactoringScriptWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.scripting.ScriptingMessages;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public final class ApplyRefactoringScriptWizard
extends RefactoringHistoryWizard
implements IWorkbenchWizard {
    private static String DIALOG_SETTINGS_KEY = "ApplyRefactoringScriptWizard";
    private boolean fNewSettings;
    private RefactoringHistory fRefactoringHistory = null;
    private URI fScriptLocation = null;
    private ApplyRefactoringScriptWizardPage fWizardPage;

    public ApplyRefactoringScriptWizard() {
        super(ScriptingMessages.ApplyRefactoringScriptWizard_caption, ScriptingMessages.ApplyRefactoringScriptWizard_title, ScriptingMessages.ApplyRefactoringScriptWizard_description);
        this.setInput(new RefactoringHistoryProxy());
        this.setDefaultPageImageDescriptor(RefactoringPluginImages.DESC_WIZBAN_APPLY_SCRIPT);
        IDialogSettings settings = RefactoringUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fNewSettings = true;
        } else {
            this.fNewSettings = false;
            this.setDialogSettings(section);
        }
        this.setConfiguration(new RefactoringHistoryControlConfiguration(null, false, false){

            public String getProjectPattern() {
                return ScriptingMessages.ApplyRefactoringScriptWizard_project_pattern;
            }

            public String getWorkspaceCaption() {
                return ScriptingMessages.ApplyRefactoringScriptWizard_workspace_caption;
            }
        });
    }

    protected void addUserDefinedPages() {
        this.fWizardPage = new ApplyRefactoringScriptWizardPage(this);
        this.addPage((IWizardPage)this.fWizardPage);
    }

    public boolean canFinish() {
        return super.canFinish() && this.fRefactoringHistory != null;
    }

    public RefactoringHistory getRefactoringHistory() {
        return this.fRefactoringHistory;
    }

    public URI getRefactoringScript() {
        return this.fScriptLocation;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IFile file;
        Object element;
        if (selection != null && selection.size() == 1 && (element = selection.getFirstElement()) instanceof IFile && ScriptingMessages.CreateRefactoringScriptWizardPage_script_extension.equals((file = (IFile)element).getFileExtension())) {
            this.fScriptLocation = file.getRawLocationURI();
        }
    }

    public boolean performFinish() {
        if (this.fNewSettings) {
            IDialogSettings settings = RefactoringUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
            section = settings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(section);
        }
        this.fWizardPage.performFinish();
        return super.performFinish();
    }

    public void setRefactoringHistory(RefactoringHistory history) {
        this.fRefactoringHistory = history;
        IWizardContainer wizard = this.getContainer();
        if (wizard.getCurrentPage() != null) {
            wizard.updateButtons();
        }
    }

    public void setRefactoringScript(URI uri) {
        this.fScriptLocation = uri;
        IWizardContainer wizard = this.getContainer();
        if (wizard.getCurrentPage() != null) {
            wizard.updateButtons();
        }
    }

    private final class RefactoringHistoryProxy
    extends RefactoringHistory {
        private RefactoringHistoryProxy() {
        }

        public RefactoringDescriptorProxy[] getDescriptors() {
            if (ApplyRefactoringScriptWizard.this.fRefactoringHistory != null) {
                return ApplyRefactoringScriptWizard.this.fRefactoringHistory.getDescriptors();
            }
            return new RefactoringDescriptorProxy[0];
        }

        public boolean isEmpty() {
            RefactoringDescriptorProxy[] proxies = this.getDescriptors();
            if (proxies != null) {
                return proxies.length == 0;
            }
            return true;
        }

        public RefactoringHistory removeAll(RefactoringHistory history) {
            throw new UnsupportedOperationException();
        }
    }
}

