/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.internal.workbench.swt.CSSRenderingUtils;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;

public class ToolControlRenderer
extends SWTPartRenderer {
    @Inject
    private MApplication application;

    public Object createWidget(MUIElement element, Object parent) {
        IRendererFactory factory;
        AbstractPartRenderer renderer;
        if (!(element instanceof MToolControl) || !(parent instanceof ToolBar) && !(parent instanceof Composite)) {
            return null;
        }
        Composite parentComp = (Composite)parent;
        MToolControl toolControl = (MToolControl)element;
        if (toolControl.getParent() instanceof MToolBar && (renderer = (factory = (IRendererFactory)this.context.get(IRendererFactory.class)).getRenderer((MUIElement)toolControl.getParent(), parent)) instanceof ToolBarManagerRenderer) {
            return null;
        }
        Widget parentWidget = (Widget)parent;
        IEclipseContext parentContext = this.getContextForParent(element);
        ToolItem sep = null;
        if (parent instanceof ToolBar) {
            sep = new ToolItem((ToolBar)parentWidget, 2);
        }
        IContributionFactory contributionFactory = (IContributionFactory)parentContext.get(IContributionFactory.class);
        IEclipseContext localContext = EclipseContextFactory.create();
        localContext.set(Composite.class.getName(), (Object)parentComp);
        localContext.set(MToolControl.class.getName(), (Object)toolControl);
        Object tcImpl = contributionFactory.create(toolControl.getContributionURI(), parentContext, localContext);
        toolControl.setObject(tcImpl);
        Control[] kids = parentComp.getChildren();
        if (kids.length == 0) {
            return null;
        }
        Control newCtrl = kids[kids.length - 1];
        if (sep != null && newCtrl != null) {
            sep.setControl(newCtrl);
            newCtrl.pack();
            sep.setWidth(newCtrl.getSize().x);
        }
        this.setCSSInfo((MUIElement)toolControl, newCtrl);
        boolean vertical = false;
        MElementContainer parentElement = element.getParent();
        if (parentElement instanceof MTrimBar) {
            MTrimBar bar = (MTrimBar)parentElement;
            vertical = bar.getSide() == SideValue.LEFT || bar.getSide() == SideValue.RIGHT;
        }
        CSSRenderingUtils cssUtils = (CSSRenderingUtils)parentContext.get(CSSRenderingUtils.class);
        newCtrl = cssUtils.frameMeIfPossible(newCtrl, null, vertical, true);
        return newCtrl;
    }

    @Inject
    @Optional
    private void subscribeTopicTagsChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/tags/*") Event event) {
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MToolControl)) {
            return;
        }
        MToolControl changedElement = (MToolControl)changedObj;
        if (UIEvents.isADD((Event)event)) {
            if (UIEvents.contains((Event)event, (String)"NewValue", (Object)"HIDDEN_EXPLICITLY")) {
                changedElement.setVisible(false);
            }
        } else if (UIEvents.isREMOVE((Event)event) && UIEvents.contains((Event)event, (String)"OldValue", (Object)"HIDDEN_EXPLICITLY")) {
            changedElement.setVisible(true);
        }
    }

    @Inject
    @Optional
    private void subscribeTopicAppStartup(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/appStartupComplete") Event event) {
        List toolControls = this.modelService.findElements((MUIElement)this.application, null, MToolControl.class, null);
        for (MToolControl toolControl : toolControls) {
            if (!toolControl.getTags().contains("HIDDEN_EXPLICITLY")) continue;
            toolControl.setVisible(false);
        }
    }
}

