/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.PathVariableDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LinkedResourceEditor {
    private static int NAME_COLUMN = 0;
    private static int PATH_COLUMN = -1;
    private static int LOCATION_COLUMN = 1;
    private static final int SIZING_SELECTION_PANE_WIDTH = 400;
    private FontMetrics fontMetrics;
    boolean initialized = false;
    TreeMap fBrokenResources = new TreeMap();
    TreeMap fAbsoluteResources = new TreeMap();
    TreeMap fFixedResources = new TreeMap();
    IProject fProject;
    TreeViewer fTree;
    Button fEditResourceButton;
    Button fConvertAbsoluteButton;
    Button fRemoveButton;
    Image fixedImg = null;
    Image brokenImg = null;
    Image absoluteImg = IDEWorkbenchPlugin.getIDEImageDescriptor("tobj16/warning.png").createImage();
    String FIXED;
    String BROKEN;
    String ABSOLUTE;

    public LinkedResourceEditor() {
        this.brokenImg = IDEWorkbenchPlugin.getIDEImageDescriptor("tobj16/error_tsk.png").createImage();
        this.fixedImg = IDEWorkbenchPlugin.getIDEImageDescriptor("tobj16/folder.png").createImage();
        this.FIXED = IDEWorkbenchMessages.LinkedResourceEditor_fixed;
        this.BROKEN = IDEWorkbenchMessages.LinkedResourceEditor_broken;
        this.ABSOLUTE = IDEWorkbenchMessages.LinkedResourceEditor_absolute;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    protected void createButtons(Composite parent) {
        Font font = parent.getFont();
        Composite groupComponent = new Composite(parent, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupComponent.setLayout((Layout)groupLayout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        groupComponent.setFont(font);
        this.fEditResourceButton = this.createButton(groupComponent, IDEWorkbenchMessages.LinkedResourceEditor_editLinkedLocation);
        this.fEditResourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LinkedResourceEditor.this.editLocation();
            }
        });
        this.fConvertAbsoluteButton = this.createButton(groupComponent, IDEWorkbenchMessages.LinkedResourceEditor_convertToVariableLocation);
        this.fConvertAbsoluteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LinkedResourceEditor.this.convertLocation();
            }
        });
        this.fRemoveButton = this.createButton(groupComponent, IDEWorkbenchMessages.LinkedResourceEditor_remove);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LinkedResourceEditor.this.removeSelection();
            }
        });
        this.updateSelection();
    }

    private Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setFont(parent.getFont());
        GridData data = new GridData(256);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fontMetrics, (int)61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        return button;
    }

    public Control createContents(Composite parent) {
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageComponent.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = 400;
        pageComponent.setLayoutData((Object)data);
        pageComponent.setFont(font);
        Label variableLabel = new Label(pageComponent, 16384);
        variableLabel.setText(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_descriptionBlock, (Object)(this.fProject != null ? this.fProject.getName() : new String())));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        variableLabel.setLayoutData((Object)data);
        variableLabel.setFont(font);
        Composite treeComposite = new Composite(pageComponent, 0);
        data = new GridData(4, 4, true, true);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        treeComposite.setLayoutData((Object)data);
        this.fTree = new TreeViewer(treeComposite, 67586);
        this.fTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LinkedResourceEditor.this.updateSelection();
            }
        });
        data = new GridData(1808);
        data.heightHint = this.fTree.getTree().getItemHeight() * 10;
        data.horizontalSpan = 1;
        this.fTree.getTree().setLayoutData((Object)data);
        this.fTree.getTree().setLinesVisible(true);
        this.fTree.setContentProvider((IContentProvider)new ContentProvider());
        this.fTree.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fTree.setInput((Object)this);
        TreeColumn nameColumn = new TreeColumn(this.fTree.getTree(), 16384, NAME_COLUMN);
        nameColumn.setText(IDEWorkbenchMessages.LinkedResourceEditor_resourceName);
        nameColumn.setResizable(true);
        nameColumn.setMoveable(false);
        TreeColumn locationColumn = new TreeColumn(this.fTree.getTree(), 16384, LOCATION_COLUMN);
        locationColumn.setText(IDEWorkbenchMessages.LinkedResourceEditor_location);
        locationColumn.setResizable(true);
        locationColumn.setMoveable(false);
        TreeColumnLayout tableLayout = new TreeColumnLayout();
        treeComposite.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(170));
        tableLayout.setColumnData((Widget)locationColumn, (ColumnLayoutData)new ColumnWeightData(260));
        this.fTree.getTree().setFont(font);
        this.fTree.getTree().setHeaderVisible(true);
        this.createButtons(pageComponent);
        this.fTree.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (LinkedResourceEditor.this.getSelectedResource().length == 1) {
                    LinkedResourceEditor.this.editLocation();
                }
            }
        });
        this.fTree.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    e.doit = false;
                    if (LinkedResourceEditor.this.getSelectedResource().length > 0) {
                        LinkedResourceEditor.this.removeSelection();
                    }
                }
            }
        });
        return pageComponent;
    }

    private void initializeDialogUnits(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    public void dispose() {
        this.fixedImg.dispose();
        this.brokenImg.dispose();
        this.absoluteImg.dispose();
    }

    void refreshContent() {
        IResource[] projectFiles;
        if (!this.initialized) {
            final LinkedList resources = new LinkedList();
            try {
                this.fProject.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource.isLinked() && !resource.isVirtual()) {
                            resources.add(resource);
                        }
                        return true;
                    }
                });
            }
            catch (CoreException coreException) {}
            projectFiles = resources.toArray(new IResource[0]);
            this.initialized = true;
        } else {
            ArrayList list = new ArrayList();
            list.addAll(this.fBrokenResources.values());
            list.addAll(this.fFixedResources.values());
            list.addAll(this.fAbsoluteResources.values());
            projectFiles = list.toArray(new IResource[0]);
        }
        this.fBrokenResources = new TreeMap();
        this.fFixedResources = new TreeMap();
        this.fAbsoluteResources = new TreeMap();
        int i = 0;
        while (i < projectFiles.length) {
            IResource resource = projectFiles[i];
            String fullPath = resource.getFullPath().toPortableString();
            try {
                if (this.exists(resource)) {
                    if (this.isAbsolute(resource)) {
                        this.fAbsoluteResources.put(fullPath, resource);
                    } else {
                        this.fFixedResources.put(fullPath, resource);
                    }
                } else {
                    this.fBrokenResources.put(fullPath, resource);
                }
            }
            catch (CoreException coreException) {
                this.fBrokenResources.put(fullPath, resource);
            }
            ++i;
        }
    }

    boolean isAbsolute(IResource res) {
        IPath path = res.getRawLocation();
        return path != null && path.isAbsolute();
    }

    boolean areAbsolute(IResource[] res) {
        int i = 0;
        while (i < res.length) {
            if (!this.isAbsolute(res[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean exists(IResource res) throws CoreException {
        URI uri = res.getLocationURI();
        if (uri != null) {
            IFileStore fileStore = EFS.getStore((URI)uri);
            return fileStore != null && fileStore.fetchInfo().exists();
        }
        return false;
    }

    void updateSelection() {
        this.fEditResourceButton.setEnabled(this.getSelectedResource().length == 1);
        this.fConvertAbsoluteButton.setEnabled(this.getSelectedResource().length > 0 && (this.areAbsolute(this.getSelectedResource()) || this.areFixed(this.getSelectedResource())));
        this.fRemoveButton.setEnabled(this.getSelectedResource().length > 0);
    }

    boolean areFixed(IResource[] res) {
        int i = 0;
        while (i < res.length) {
            String fullPath = res[i].getFullPath().toPortableString();
            if (!this.fFixedResources.containsKey(fullPath)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    IResource[] getSelectedResource() {
        IStructuredSelection selection = (IStructuredSelection)this.fTree.getSelection();
        Object[] array = selection.toArray();
        if (array.length > 0) {
            int i = 0;
            while (i < array.length) {
                if (!(array[i] instanceof IResource)) {
                    return new IResource[0];
                }
                ++i;
            }
            IResource[] result = new IResource[array.length];
            System.arraycopy(array, 0, result, 0, array.length);
            return result;
        }
        return new IResource[0];
    }

    private void convertLocation() {
        if (MessageDialog.openConfirm((Shell)this.fConvertAbsoluteButton.getShell(), (String)IDEWorkbenchMessages.LinkedResourceEditor_convertTitle, (String)IDEWorkbenchMessages.LinkedResourceEditor_convertMessage)) {
            ArrayList<IResource> resources = new ArrayList<IResource>();
            IResource[] selectedResources = this.getSelectedResource();
            resources.addAll(Arrays.asList(selectedResources));
            if (this.areFixed(selectedResources)) {
                this.convertToAbsolute(resources, selectedResources);
            } else {
                this.convertToRelative(resources, selectedResources);
            }
        }
    }

    private void removeSelection() {
        if (MessageDialog.openConfirm((Shell)this.fRemoveButton.getShell(), (String)IDEWorkbenchMessages.LinkedResourceEditor_removeTitle, (String)IDEWorkbenchMessages.LinkedResourceEditor_removeMessage)) {
            final IResource[] selectedResources = this.getSelectedResource();
            final ArrayList removedResources = new ArrayList();
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(IDEWorkbenchMessages.LinkedResourceEditor_removingMessage, selectedResources.length);
                        int i = 0;
                        while (i < selectedResources.length) {
                            if (monitor.isCanceled()) {
                                break;
                            }
                            String fullPath = selectedResources[i].getFullPath().toPortableString();
                            try {
                                selectedResources[i].delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                removedResources.add(selectedResources[i]);
                                LinkedResourceEditor.this.fBrokenResources.remove(fullPath);
                                LinkedResourceEditor.this.fFixedResources.remove(fullPath);
                                LinkedResourceEditor.this.fAbsoluteResources.remove(fullPath);
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                            ++i;
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                new ProgressMonitorDialog(this.fRemoveButton.getShell()).run(true, true, op);
            }
            catch (InvocationTargetException e) {
                IDEWorkbenchPlugin.log(null, e);
            }
            catch (InterruptedException e) {
                IDEWorkbenchPlugin.log(null, e);
            }
            this.fTree.refresh();
        }
    }

    private void convertToAbsolute(ArrayList resources, IResource[] selectedResources) {
        ArrayList<String> report = new ArrayList<String>();
        for (IResource res : resources) {
            IPath location = res.getLocation();
            try {
                this.setLinkLocation(res, location);
                report.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_changedTo, (Object[])new Object[]{res.getProjectRelativePath().toPortableString(), res.getRawLocation().toOSString(), location.toOSString()}));
            }
            catch (CoreException coreException) {
                report.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_unableToSetLinkLocationForResource, (Object)res.getProjectRelativePath().toPortableString()));
            }
        }
        this.reportResult(selectedResources, report, IDEWorkbenchMessages.LinkedResourceEditor_convertRelativePathLocations);
    }

    private void setLinkLocation(IResource res, IPath location) throws CoreException {
        if (res.getType() == 1) {
            ((IFile)res).createLink(location, 256, (IProgressMonitor)new NullProgressMonitor());
        }
        if (res.getType() == 2) {
            ((IFolder)res).createLink(location, 256, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void reportResult(IResource[] selectedResources, ArrayList report, String title) {
        StringBuffer message = new StringBuffer();
        Iterator stringIt = report.iterator();
        while (stringIt.hasNext()) {
            message.append(stringIt.next());
            if (!stringIt.hasNext()) continue;
            message.append("\n");
        }
        final String resultMessage = message.toString();
        MessageDialog dialog = new MessageDialog(this.fConvertAbsoluteButton.getShell(), title, null, IDEWorkbenchMessages.LinkedResourceEditor_convertionResults, 2, new String[]{IDEWorkbenchMessages.linkedResourceEditor_OK}, 0){

            protected boolean isResizable() {
                return true;
            }

            protected Control createCustomArea(Composite comp) {
                this.setShellStyle(this.getShellStyle() | 0x10);
                Composite parent = new Composite(comp, 0);
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                layout.marginLeft = 2;
                layout.numColumns = 1;
                layout.verticalSpacing = 9;
                parent.setLayout((Layout)layout);
                parent.setLayoutData((Object)new GridData(1808));
                Text text = new Text(parent, 2818);
                text.setText(resultMessage.toString());
                GridData data = new GridData(640, 300);
                text.setLayoutData((Object)data);
                return parent;
            }
        };
        dialog.open();
        this.reparent(selectedResources);
    }

    private IPath convertToProperCase(IPath path) {
        if (Platform.getOS().equals("win32")) {
            return Path.fromPortableString((String)path.toPortableString().toLowerCase());
        }
        return path;
    }

    private void convertToRelative(ArrayList resources, IResource[] selectedResources) {
        IResource res;
        ArrayList<String> report = new ArrayList<String>();
        ArrayList<IResource> remaining = new ArrayList<IResource>();
        for (IResource res2 : resources) {
            IPath location = res2.getLocation();
            try {
                IPath newLocation = URIUtil.toPath((URI)res2.getPathVariableManager().convertToRelative(URIUtil.toURI((IPath)location), true, null));
                if (newLocation == null || newLocation.equals((Object)location)) {
                    remaining.add(res2);
                    continue;
                }
                this.setLinkLocation(res2, newLocation);
                report.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_changedTo, (Object[])new Object[]{res2.getProjectRelativePath().toPortableString(), location.toOSString(), newLocation.toOSString()}));
            }
            catch (CoreException coreException) {
                remaining.add(res2);
            }
        }
        resources = remaining;
        remaining = new ArrayList();
        String[] variables = this.fProject.getPathVariableManager().getPathVariableNames();
        Iterator it = resources.iterator();
        int amountLeft = 0;
        while (it.hasNext()) {
            res = (IResource)it.next();
            IPath location = res.getLocation();
            int maxCount = 0;
            int variable = -1;
            int i = 0;
            while (i < variables.length) {
                int count;
                IPath resolvePath = URIUtil.toPath((URI)res.getPathVariableManager().resolveURI(URIUtil.toURI((IPath)Path.fromOSString((String)variables[i]))));
                if (resolvePath.isPrefixOf(this.convertToProperCase(location)) && (count = location.matchingFirstSegments(resolvePath)) > maxCount) {
                    maxCount = count;
                    variable = i;
                }
                ++i;
            }
            if (variable != -1) {
                IPath newLocation = Path.fromOSString((String)variables[variable]).append(location.removeFirstSegments(maxCount));
                try {
                    this.setLinkLocation(res, newLocation);
                    report.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_changedTo, (Object[])new Object[]{res.getProjectRelativePath().toPortableString(), location.toOSString(), newLocation.toOSString()}));
                }
                catch (CoreException coreException) {
                    variable = -1;
                }
            }
            if (variable != -1) continue;
            ++amountLeft;
            remaining.add(res);
        }
        resources = remaining;
        if (amountLeft > 1) {
            it = resources.iterator();
            IPath commonPath = null;
            while (it.hasNext()) {
                IResource res3 = (IResource)it.next();
                IPath location = res3.getLocation();
                if (commonPath == null) {
                    commonPath = location;
                } else {
                    int count = commonPath.matchingFirstSegments(location);
                    if (count < commonPath.segmentCount()) {
                        commonPath = commonPath.removeLastSegments(commonPath.segmentCount() - count);
                    }
                }
                if (commonPath.segmentCount() == 0) break;
            }
            if (commonPath.segmentCount() > 1) {
                String variableName = this.getSuitablePathVariable(commonPath);
                try {
                    this.fProject.getPathVariableManager().setURIValue(variableName, URIUtil.toURI((IPath)commonPath));
                }
                catch (CoreException coreException) {
                    report.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_unableToCreateVariable, (Object)variableName, (Object)commonPath.toOSString()));
                }
                for (IResource res4 : resources) {
                    IPath location = res4.getLocation();
                    int commonCount = location.matchingFirstSegments(commonPath);
                    IPath newLocation = Path.fromOSString((String)variableName).append(location.removeFirstSegments(commonCount));
                    try {
                        this.setLinkLocation(res4, newLocation);
                        report.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_changedTo, (Object[])new Object[]{res4.getProjectRelativePath().toPortableString(), location.toOSString(), newLocation.toOSString()}));
                    }
                    catch (CoreException coreException) {
                        report.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_unableToSetLinkLocationForResource, (Object)res4.getProjectRelativePath().toPortableString()));
                    }
                }
            } else {
                report.add(IDEWorkbenchMessages.LinkedResourceEditor_unableToFindCommonPathSegments);
                for (IResource res3 : resources) {
                    report.add(res3.getProjectRelativePath().toPortableString());
                }
            }
        } else if (!resources.isEmpty()) {
            res = (IResource)resources.get(0);
            IPath resLocation = res.getLocation();
            IPath commonPath = resLocation.removeLastSegments(1);
            String variableName = this.getSuitablePathVariable(commonPath);
            try {
                this.fProject.getPathVariableManager().setURIValue(variableName, URIUtil.toURI((IPath)commonPath));
            }
            catch (CoreException coreException) {
                report.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_unableToCreateVariable, (Object)variableName, (Object)commonPath.toPortableString()));
            }
            IPath location = res.getLocation();
            int commonCount = location.matchingFirstSegments(commonPath);
            IPath newLocation = Path.fromOSString((String)variableName).append(location.removeFirstSegments(commonCount));
            try {
                this.setLinkLocation(res, newLocation);
                report.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_changedTo, (Object[])new Object[]{res.getProjectRelativePath().toPortableString(), location.toOSString(), newLocation.toOSString()}));
            }
            catch (CoreException coreException) {
                report.add(NLS.bind((String)IDEWorkbenchMessages.LinkedResourceEditor_unableToSetLinkLocationForResource, (Object)res.getProjectRelativePath().toPortableString()));
            }
        }
        this.reportResult(selectedResources, report, IDEWorkbenchMessages.LinkedResourceEditor_convertAbsolutePathLocations);
    }

    private String getSuitablePathVariable(IPath commonPath) {
        String variableName = commonPath.lastSegment();
        if (variableName == null) {
            variableName = commonPath.getDevice();
            variableName = variableName == null ? "ROOT" : variableName.substring(0, variableName.length() - 1);
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < variableName.length()) {
            char c = variableName.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') {
                buf.append(c);
            } else {
                buf.append('_');
            }
            ++i;
        }
        variableName = buf.toString();
        int index = 1;
        while (this.fProject.getPathVariableManager().isDefined(variableName)) {
            variableName = String.valueOf(variableName) + index;
            ++index;
        }
        return variableName;
    }

    void editLocation() {
        IResource resource = this.getSelectedResource()[0];
        IPath location = resource.getRawLocation();
        PathVariableDialog dialog = new PathVariableDialog(this.fConvertAbsoluteButton.getShell(), 3, resource.getType(), resource.getPathVariableManager(), null);
        if (location != null) {
            dialog.setLinkLocation(location);
        }
        dialog.setResource(resource);
        if (dialog.open() == 1) {
            return;
        }
        location = Path.fromOSString((String)dialog.getVariableValue());
        try {
            this.setLinkLocation(resource, location);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.reparent(new IResource[]{resource});
    }

    void reparent(IResource[] resources) {
        boolean changed = false;
        int i = 0;
        while (i < resources.length) {
            boolean isBroken;
            IResource resource = resources[i];
            try {
                isBroken = !this.exists(resource);
            }
            catch (CoreException coreException) {
                isBroken = true;
            }
            TreeMap container = null;
            container = isBroken ? this.fBrokenResources : (this.isAbsolute(resource) ? this.fAbsoluteResources : this.fFixedResources);
            String fullPath = resource.getFullPath().toPortableString();
            if (!container.containsKey(fullPath)) {
                this.fBrokenResources.remove(fullPath);
                this.fAbsoluteResources.remove(fullPath);
                this.fFixedResources.remove(fullPath);
                container.put(fullPath, resource);
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.fTree.refresh();
        }
    }

    public boolean performOk() {
        return true;
    }

    public void setEnabled(boolean enableLinking) {
    }

    public void reloadContent() {
        this.refreshContent();
        this.fTree.refresh();
        this.updateSelection();
        this.fTree.expandAll();
    }

    class ContentProvider
    implements IContentProvider,
    ITreeContentProvider {
        ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof LinkedResourceEditor) {
                ArrayList<Object> list = new ArrayList<Object>();
                Object[] objs = new Object[]{LinkedResourceEditor.this.BROKEN, LinkedResourceEditor.this.ABSOLUTE, LinkedResourceEditor.this.FIXED};
                int i = 0;
                while (i < objs.length) {
                    Object[] children = this.getChildren(objs[i]);
                    if (children != null && children.length > 0) {
                        list.add(objs[i]);
                    }
                    ++i;
                }
                return list.toArray(new Object[0]);
            }
            if (parentElement instanceof String) {
                if (((String)parentElement).equals(LinkedResourceEditor.this.BROKEN)) {
                    return LinkedResourceEditor.this.fBrokenResources.values().toArray();
                }
                if (((String)parentElement).equals(LinkedResourceEditor.this.ABSOLUTE)) {
                    return LinkedResourceEditor.this.fAbsoluteResources.values().toArray();
                }
                return LinkedResourceEditor.this.fFixedResources.values().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof IResource) {
                String fullPath = ((IResource)element).getFullPath().toPortableString();
                if (LinkedResourceEditor.this.fBrokenResources.containsKey(fullPath)) {
                    return LinkedResourceEditor.this.BROKEN;
                }
                if (LinkedResourceEditor.this.fAbsoluteResources.containsKey(fullPath)) {
                    return LinkedResourceEditor.this.ABSOLUTE;
                }
                return LinkedResourceEditor.this.FIXED;
            }
            if (element instanceof String) {
                return this;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof LinkedResourceEditor) {
                return true;
            }
            if (element instanceof String) {
                if (((String)element).equals(LinkedResourceEditor.this.BROKEN)) {
                    return !LinkedResourceEditor.this.fBrokenResources.isEmpty();
                }
                if (((String)element).equals(LinkedResourceEditor.this.ABSOLUTE)) {
                    return !LinkedResourceEditor.this.fAbsoluteResources.isEmpty();
                }
                return !LinkedResourceEditor.this.fFixedResources.isEmpty();
            }
            return false;
        }

        public Object[] getElements(Object parentElement) {
            return this.getChildren(parentElement);
        }
    }

    class LabelProvider
    implements ILabelProvider,
    ITableLabelProvider {
        WorkbenchLabelProvider stockProvider = new WorkbenchLabelProvider();

        public String getColumnText(Object obj, int index) {
            if (obj instanceof IResource) {
                IResource resource = (IResource)obj;
                if (index == NAME_COLUMN) {
                    return resource.getName();
                }
                if (index == PATH_COLUMN) {
                    return resource.getParent().getProjectRelativePath().toPortableString();
                }
                IPath rawLocation = resource.getRawLocation();
                if (rawLocation != null) {
                    return resource.getPathVariableManager().convertToUserEditableFormat(rawLocation.toOSString(), true);
                }
            } else if (obj instanceof String && index == 0) {
                return (String)obj;
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == NAME_COLUMN) {
                if (obj instanceof String) {
                    if (obj.equals(LinkedResourceEditor.this.BROKEN)) {
                        return LinkedResourceEditor.this.brokenImg;
                    }
                    if (obj.equals(LinkedResourceEditor.this.ABSOLUTE)) {
                        return LinkedResourceEditor.this.absoluteImg;
                    }
                    return LinkedResourceEditor.this.fixedImg;
                }
                return this.stockProvider.getImage(obj);
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            this.stockProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.stockProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }
}

