/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.explorer;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.sdblib.IDevice;

public class ConnectionExplorerOperation {
    private final Logger logger = LoggerFactory.getLogger(ConnectionExplorerOperation.class);

    public void openShell(IDevice device) {
        this.logger.info("open the shell");
        String termPath = ConnectionPlugin.getDefault().getPreferenceStore().getString("terminal_path");
        String sdbPath = InstallPathConfig.getSDBPath();
        String serial = device.getSerialNumber();
        try {
            ProcessBuilder procSdb = new ProcessBuilder(new String[0]);
            ArrayList<String> cmdList = new ArrayList<String>();
            File sdbFile = new File(sdbPath);
            if (OSChecker.isMAC()) {
                device.getPlatformInfo();
                cmdList.add(termPath);
                cmdList.add(sdbPath);
                cmdList.add(serial);
            } else {
                cmdList.addAll(Arrays.asList(termPath.split("\\s+")));
                if (OSChecker.isLinux()) {
                    cmdList.add(sdbFile.getAbsolutePath());
                } else {
                    procSdb.directory(sdbFile.getParentFile());
                    cmdList.add(sdbFile.getName());
                }
                cmdList.add("-s");
                cmdList.add(serial);
                cmdList.add("shell");
            }
            this.logger.info(((Object)cmdList).toString());
            procSdb.command(cmdList);
            procSdb.start();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            DialogUtil.openErrorDialog((String)("Failed to open shell :\n" + e.getMessage()));
        }
    }
}

