/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.log;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.tizen.common.connection.explorer.ConnectionExplorerLabelProvider;
import org.tizen.common.connection.log.AddViewDialog;
import org.tizen.common.connection.log.LogColors;
import org.tizen.common.connection.log.LogFilter;
import org.tizen.common.connection.log.LogTab;
import org.tizen.common.connection.log.LogUIMessages;
import org.tizen.common.connection.log.model.LogMessage;
import org.tizen.common.ui.dialog.FileDialogUtils;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.NotificationType;
import org.tizen.common.util.NotifierDialog;
import org.tizen.common.util.SWTUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IDeviceChangeListener;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.util.DeviceUtil;
import org.tizen.sdblib.util.LogLevel;

public class LogPanel
implements IDeviceChangeListener {
    public static final int NO_TAB = 0;
    public static final int DEVICE_TAB = 1;
    public static final int ADDITIONAL_TAB = 2;
    public static final int DISCONNECTED_TAB = 3;
    private final int ENABLE_ADD = 1;
    private final int ENABLE_REMOVE = 16;
    private final int ENABLE_EDIT = 256;
    private final int ENABLE_SCROLL_LOCK = 4096;
    private final int ENABLE_EXPORT = 65536;
    private final int ENABLE_CLEAR = 0x100000;
    private final int ENABLE_LEVEL = 0x1000000;
    private final int ENABLE_CONVERT = 0x10000000;
    private final int[] ENABLE_VIEW_ACTIONS = new int[]{1, 16, 256, 4096, 65536, 0x100000, 0x10000000};
    private String defaultLogSave;
    private Composite parent;
    private CTabFolder cTabFolder;
    private GC gc;
    private final LogColors colors;
    private Action[] levelActions;
    private Action[] viewActions;
    private IActionBars actionBars;
    private StackLayout stackLayout;
    public static List<LogTab> logTabList = new ArrayList<LogTab>();
    public static final LogLevel DEFAULT_LOG_LEVEL = LogLevel.ERROR;
    public static final int MESSAGE_COLUMN_INDEX = 5;
    public static final int LOGTAB_LOG_FILTER_DELAY_TIME = 500;

    public LogPanel(LogColors pColors, IActionBars bars) {
        this.colors = pColors;
        this.actionBars = bars;
    }

    public void setActions(Action[] levelActs, Action[] toolbarActs) {
        this.levelActions = levelActs;
        this.viewActions = toolbarActs;
    }

    protected Control createControl(Composite p) {
        this.parent = p;
        this.cTabFolder = new CTabFolder(this.parent, 0);
        this.cTabFolder.setLayoutData((Object)new GridData(1808));
        this.stackLayout = new StackLayout();
        this.cTabFolder.setLayout((Layout)this.stackLayout);
        this.cTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogPanel.this.selectTabItem();
            }
        });
        this.gc = new GC((Drawable)this.cTabFolder);
        this.cTabFolder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                LogPanel.this.gc.dispose();
            }
        });
        SmartDevelopmentBridge.addDeviceChangeListener((IDeviceChangeListener)this, (boolean)true);
        return null;
    }

    private void selectTabItem() {
        int index = this.cTabFolder.getSelectionIndex();
        if (index == -1) {
            return;
        }
        CTabItem item = this.cTabFolder.getItem(index);
        LogTab logTab = this.getSelectionLogTab();
        if (logTab == null) {
            return;
        }
        this.setEnableAndCheckState(logTab);
        this.stackLayout.topControl = item.getControl();
    }

    private void setEnableAndCheckState(LogTab logTab) {
        String serial = logTab.getDeviceSerialNumber();
        if (serial == null) {
            this.setActionsState(3, logTab);
        } else if (logTab.isDefault()) {
            this.setActionsState(1, logTab);
        } else {
            this.setActionsState(2, logTab);
        }
        this.setCheckState(logTab);
    }

    public void changeLogLevelAndFilterMessages(int level, boolean beChecked) {
        this.updateLevelMode(level, beChecked);
        this.getSelectionLogTab().filterMessages();
    }

    private void updateLevelMode(int levelIndex, boolean setChecked) {
        boolean[] levelMode = this.getSelectionLogTab().getLogFilter().getLogLevelFilter();
        levelMode[levelIndex] = setChecked;
    }

    public void setVisible(boolean visible) {
        for (LogTab tab : logTabList) {
            tab.setVisible(visible);
        }
    }

    private LogTab createLogTab(String name, IDevice device, boolean isDefault) {
        Iterator<LogTab> iter = logTabList.iterator();
        LogFilter logFilter = null;
        while (iter.hasNext()) {
            LogTab oldTab = iter.next();
            if (!oldTab.getLogTabName().equals(name)) continue;
            logFilter = oldTab.getLogFilter();
            this.removeTab(oldTab);
            iter.remove();
        }
        LogTab logTab = new LogTab(name, device, this.colors);
        if (!logTab.isSupportProfile) {
            logTab = null;
        } else {
            if (logFilter != null) {
                logTab.setLogFilter(logFilter);
            }
            logTab.setGc(this.gc);
            logTabList.add(logTab);
            this.createCTabItem(this.cTabFolder, logTab);
            if (isDefault) {
                logTab.setDefault();
                this.setActionsState(1, logTab);
            } else {
                this.setActionsState(2, logTab);
            }
            this.setCheckState(logTab);
        }
        return logTab;
    }

    private Control createCTabItem(CTabFolder cTabFolder, LogTab logTab) {
        Composite composite = new Composite((Composite)cTabFolder, 0);
        composite.setLayoutData((Object)new GridData(1040));
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite top = new Composite(composite, 0);
        top.setLayoutData((Object)new GridData(1808));
        top.setLayout((Layout)new FillLayout());
        TableViewer tableViewer = new TableViewer(top, 268503298);
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String msg = ((LogMessage)e.item.getData()).msg;
                if (msg == null) {
                    return;
                }
                IStatusLineManager statusLineManager = LogPanel.this.actionBars.getStatusLineManager();
                if (statusLineManager == null) {
                    return;
                }
                statusLineManager.setMessage(msg);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        LogPanel.createTableColumn(table, "Time", 16384, "00-00 00:00:00.000");
        LogPanel.createTableColumn(table, "Level", 16384, "Verbose");
        LogPanel.createTableColumn(table, "Pid", 16384, "9999999");
        LogPanel.createTableColumn(table, "Tid", 16384, "9999999");
        LogPanel.createTableColumn(table, "Tag", 16384, "ABCDEFGHIJK");
        LogPanel.createTableColumn(table, "Message", 16384, "abcdefghijklmnopqrstuvwxyz0123456789abcdefghijklmnopqrstuvwxyz0123456789");
        Composite bottom = new Composite(composite, 0);
        bottom.setLayoutData((Object)new GridData(768));
        bottom.setLayout((Layout)new GridLayout(3, false));
        Combo filterComboOnView = new Combo(bottom, 8);
        String[] comboItems = new String[]{"Pid", "Tag", "Message"};
        filterComboOnView.setItems(comboItems);
        filterComboOnView.select(logTab.getLogFilter().getComboFilter());
        filterComboOnView.setToolTipText(LogUIMessages.Log_Tooltip_View_Filter_Combo);
        filterComboOnView.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.widget;
                LogPanel.this.getSelectionLogTab().setFilterCombo(combo.getSelectionIndex());
                LogPanel.this.getSelectionLogTab().filterMessages();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Text filterTextOnView = new Text(bottom, 2052);
        filterTextOnView.setLayoutData((Object)new GridData(768));
        filterTextOnView.setMessage(LogUIMessages.Log_Message_View_Filter_Text);
        filterTextOnView.setText(logTab.getLogFilter().getKeywordFilter());
        filterTextOnView.setToolTipText(LogUIMessages.Log_TAB_FILTER_TOOLTIP);
        filterTextOnView.addModifyListener(new ModifyListener(){
            Timer timer;

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.widget;
                final String filter = text.getText();
                if (this.timer != null) {
                    this.timer.cancel();
                }
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        SWTUtil.syncExec((Runnable)new ModifyLogRunnable(filter));
                        timer.cancel();
                    }
                }, 500L);
            }
        });
        CTabItem tabItem = new CTabItem(cTabFolder, 0, cTabFolder.getItemCount());
        tabItem.setText(logTab.getLogTabName());
        tabItem.setControl((Control)composite);
        logTab.setTable(table);
        logTab.setCTabItem(tabItem);
        cTabFolder.setSelection(tabItem);
        this.stackLayout.topControl = tabItem.getControl();
        return composite;
    }

    public void copy(Clipboard clipboard) {
        LogPanel.copyTableToClipboard(clipboard, this.getSelectionLogTab().getTable());
    }

    public void selectAll() {
        this.getSelectionLogTab().getTable().selectAll();
    }

    private static void copyTableToClipboard(Clipboard clipboard, Table table) {
        int[] selectionIndices = table.getSelectionIndices();
        Arrays.sort(selectionIndices);
        StringBuilder tableContentBuilder = new StringBuilder();
        int[] nArray = selectionIndices;
        int n = selectionIndices.length;
        int n2 = 0;
        while (n2 < n) {
            Object data;
            int index = nArray[n2];
            TableItem item = table.getItem(index);
            if (item != null && (data = item.getData()) instanceof LogMessage) {
                LogMessage msg = (LogMessage)data;
                tableContentBuilder.append(msg.toString());
                tableContentBuilder.append('\n');
            }
            ++n2;
        }
        String tableContents = tableContentBuilder.toString();
        TextTransfer textTansfer = TextTransfer.getInstance();
        clipboard.setContents(new Object[]{tableContents}, new Transfer[]{textTansfer});
    }

    public boolean save() {
        boolean again;
        if (this.getSelectionLogTab() == null) {
            return false;
        }
        FileDialog dlg = new FileDialog(this.parent.getShell(), 8192);
        dlg.setText(LogUIMessages.Log_Title_Tab_Export);
        String saveName = String.format(LogUIMessages.Log_File_Tab_Export_Postfix, this.getSelectionLogTab().getLogTabName());
        dlg.setFileName(saveName);
        String defaultPath = this.defaultLogSave;
        if (defaultPath == null) {
            defaultPath = System.getProperty("user.home");
        }
        dlg.setFilterPath(defaultPath);
        dlg.setFilterNames(new String[]{LogUIMessages.Log_File_Tab_Export_Filter});
        dlg.setFilterExtensions(new String[]{LogUIMessages.Log_File_Tab_Export_Filter_Extensions});
        String fileName = null;
        do {
            int ret;
            again = false;
            fileName = dlg.open();
            if (fileName == null) {
                return false;
            }
            File checkFile = new File(fileName);
            if (!checkFile.exists() || (ret = FileDialogUtils.allowFileOverwrite((String)fileName)) != 1) continue;
            again = true;
        } while (again);
        this.defaultLogSave = dlg.getFilterPath();
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(fileName);
                TableItem[] tableItemArray = this.getSelectionLogTab().getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    LogMessage msg = (LogMessage)item.getData();
                    String line = msg.toString();
                    writer.write(line);
                    writer.write(10);
                    ++n2;
                }
                writer.flush();
            }
            catch (IOException iOException) {
                IOUtil.tryClose((Object[])new Object[]{writer});
                return false;
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{writer});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{writer});
        return true;
    }

    public void clear() {
        LogTab tab = this.getSelectionLogTab();
        if (tab != null) {
            tab.clear();
        }
    }

    private boolean checkTabConnection(LogTab tab, String title) {
        String deviceName = tab.getDeviceSerialNumber();
        if (deviceName == null) {
            String tabName = tab.getLogTabName();
            String message = String.format(LogUIMessages.Log_Message_Tab_Device_Disconnected, tabName);
            DialogUtil.openErrorDialog((Shell)this.parent.getShell(), (String)title, (String)message);
            return false;
        }
        return true;
    }

    public void addTab() {
        LogTab tab = this.getSelectionLogTab();
        if (tab == null) {
            return;
        }
        if (!this.checkTabConnection(tab, LogUIMessages.Log_Title_Tab_AddTab_Error)) {
            return;
        }
        AddViewDialog dlg = new AddViewDialog(this.parent.getShell(), tab.getDeviceSerialNumber());
        if (dlg.getDevice() == null) {
            return;
        }
        if (dlg.open()) {
            IDevice[] iDeviceArray = this.getDevices();
            int n = iDeviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDevice device = iDeviceArray[n2];
                if (device.getSerialNumber().equals(dlg.getDevice())) {
                    LogTab newTab = this.createLogTab(dlg.getName(), device, false);
                    if (newTab == null) {
                        this.notifyNotSupport(device.getSerialNumber());
                    } else {
                        newTab.getLogFilter().setPidFilter(dlg.getPidKeyword());
                        newTab.getLogFilter().setTagFilter(dlg.getTagKeyword());
                        newTab.getLogFilter().setMsgFilter(dlg.getMsgKeyword());
                        newTab.start();
                    }
                    break;
                }
                ++n2;
            }
        } else {
            return;
        }
    }

    public void removeTab(LogTab tab) {
        tab.stop();
        SWTUtil.tryDispose((Widget[])new Widget[]{tab.getCTabItem()});
    }

    public void removeTab() {
        int index = this.cTabFolder.getSelectionIndex();
        if (index < 0) {
            return;
        }
        LogTab tab = logTabList.get(index);
        this.removeTab(tab);
        logTabList.remove(tab);
        if (logTabList.isEmpty()) {
            this.setActionsState(0, null);
        }
    }

    public void editTab() {
        LogTab oldTab = this.getSelectionLogTab();
        if (oldTab == null) {
            return;
        }
        if (oldTab.isDefault()) {
            return;
        }
        if (!this.checkTabConnection(oldTab, LogUIMessages.Log_Title_Tab_EditTab_Error)) {
            return;
        }
        AddViewDialog dlg = new AddViewDialog(this.parent.getShell(), oldTab);
        if (dlg.open()) {
            IDevice[] iDeviceArray = this.getDevices();
            int n = iDeviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDevice device = iDeviceArray[n2];
                if (device.getSerialNumber().equals(dlg.getDevice())) {
                    oldTab.stop();
                    oldTab.setDevice(device);
                    CTabItem[] cTabItemArray = this.cTabFolder.getItems();
                    int n3 = cTabItemArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        CTabItem item = cTabItemArray[n4];
                        if (item.getText().equals(oldTab.getLogTabName())) {
                            item.setText(dlg.getName());
                            oldTab.setLogTabName(dlg.getName());
                        }
                        ++n4;
                    }
                    oldTab.getLogFilter().setPidFilter(dlg.getPidKeyword());
                    oldTab.getLogFilter().setTagFilter(dlg.getTagKeyword());
                    oldTab.getLogFilter().setMsgFilter(dlg.getMsgKeyword());
                    oldTab.start();
                    break;
                }
                ++n2;
            }
        }
    }

    public static TableColumn createTableColumn(Table parent, String header, int style, String sampleText) {
        TableColumn col = new TableColumn(parent, style);
        col.setText(sampleText);
        col.setMoveable(true);
        col.pack();
        col.setText(header);
        return col;
    }

    public LogTab getSelectionLogTab() {
        if (logTabList.size() != 0) {
            int index = this.cTabFolder.getSelectionIndex();
            CTabItem item = this.cTabFolder.getItem(index);
            for (LogTab logTab : logTabList) {
                if (logTab.getCTabItem() != item) continue;
                return logTab;
            }
        }
        return null;
    }

    public void stopAllTabItems() {
        for (LogTab tab : logTabList) {
            this.removeTab(tab);
        }
        logTabList.clear();
    }

    private IDevice[] getDevices() {
        SmartDevelopmentBridge sdbBridge = SmartDevelopmentBridge.getBridge();
        IDevice[] devices = sdbBridge != null ? sdbBridge.getDevices() : new IDevice[]{};
        return devices;
    }

    public void onConnected(IDevice device) {
        if (DeviceUtil.isOnline((IDevice)device)) {
            this.onChanged(device, 1);
        }
    }

    public void onDisconnected(final IDevice device) {
        if (!this.parent.isDisposed()) {
            Display display = this.parent.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!LogPanel.this.parent.isDisposed()) {
                        String name = ConnectionExplorerLabelProvider.getDeviceSerialWithName(device);
                        String title = LogUIMessages.Log_Title_View_Device_Disconnected;
                        String message = String.format(LogUIMessages.Log_Message_View_Device_Disconnected, name, name);
                        NotifierDialog.notify((String)title, (String)message, (NotificationType)NotificationType.DISCONNECTED);
                        for (LogTab tab : logTabList) {
                            if (!device.getSerialNumber().equals(tab.getDeviceSerialNumber())) continue;
                            tab.setDevice(null);
                        }
                        LogPanel.this.setActionsState(3, null);
                        LogPanel.this.selectTabItem();
                    } else {
                        SmartDevelopmentBridge.removeDeviceChangeListener((IDeviceChangeListener)LogPanel.this);
                    }
                }
            });
        }
    }

    public void onChanged(final IDevice device, int changeMask) {
        if (changeMask == 1 && !this.parent.isDisposed()) {
            Display display = this.parent.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!LogPanel.this.cTabFolder.isDisposed()) {
                        LogTab tab = LogPanel.this.createLogTab(ConnectionExplorerLabelProvider.getDeviceSerialWithName(device), device, true);
                        if (tab == null) {
                            LogPanel.this.notifyNotSupport(device.getSerialNumber());
                        } else {
                            tab.start();
                        }
                    } else {
                        SmartDevelopmentBridge.removeDeviceChangeListener((IDeviceChangeListener)LogPanel.this);
                    }
                }
            });
        }
    }

    private void notifyNotSupport(final String deviceSerialNumber) {
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                NotifierDialog.notify((String)LogUIMessages.Log_Message_Not_Supported, (String)String.format(LogUIMessages.Log_Message_Not_Supported_Desc, deviceSerialNumber), (NotificationType)NotificationType.WARN);
            }
        });
    }

    private boolean getEnabled(int state, int action) {
        int result = state & action;
        return result != 0;
    }

    private void changeActionState(int state) {
        int i = 0;
        while (i < this.viewActions.length) {
            this.viewActions[i].setEnabled(this.getEnabled(state, this.ENABLE_VIEW_ACTIONS[i]));
            ++i;
        }
    }

    private void changeEnableState(int state, LogTab logTab) {
        boolean check = this.getEnabled(state, 0x1000000);
        if (check) {
            boolean[] logLevelFilter = logTab.getLogFilter().getLogLevelFilter();
            int i = 0;
            while (i < LogLevel.values().length) {
                this.updateLevelMode(i, logLevelFilter[i]);
                ++i;
            }
        }
        int i = 0;
        while (i < this.levelActions.length) {
            this.levelActions[i].setEnabled(true);
            ++i;
        }
    }

    private void setCheckState(LogTab tab) {
        boolean[] levelMode = tab.getLogFilter().getLogLevelFilter();
        int i = 0;
        while (i < this.levelActions.length) {
            this.levelActions[i].setChecked(levelMode[i]);
            ++i;
        }
        this.viewActions[3].setChecked(tab.getScrollLock());
    }

    public int getActionState(int tabType) {
        int state = 0;
        if (tabType == 0) {
            state = 0;
        } else if (tabType == 1) {
            state = 0x11111001;
        } else if (tabType == 2) {
            state = 0x11111111;
        } else if (tabType == 3) {
            state = 0x11010010;
        }
        return state;
    }

    public void setActionsState(int tabType, LogTab tab) {
        int state = this.getActionState(tabType);
        this.changeActionState(state);
        if (tab != null) {
            this.changeEnableState(state, tab);
        }
    }

    public void setScrollLock(boolean lock) {
        this.getSelectionLogTab().setScrollLock(lock);
    }

    public void restart() {
        LogTab logTab = this.getSelectionLogTab();
        logTab.restart();
    }

    class ModifyLogRunnable
    implements Runnable {
        private String text;

        ModifyLogRunnable(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            LogPanel.this.getSelectionLogTab().setFilterText(this.text);
            LogPanel.this.getSelectionLogTab().filterMessages();
        }
    }
}

