/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.preference;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.preference.PreferenceMessages;
import org.tizen.common.util.SWTUtil;

public class TizenLogViewPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String KEY_LOG_BUFFER_SIZE = "string_buffer_length";
    public static final int VALUE_LOG_BUFFER_SIZE_DEFAULT = 20000;
    private static final int VALID_BUFFER_SIZE_MAX = 100000;
    private static final int VALID_BUFFER_SIZE_MIN = 5000;

    public TizenLogViewPreferencePage() {
        this.setPreferenceStore(ConnectionPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferenceMessages.LOG_DESCRIPTION);
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        SWTUtil.createSpacer((Composite)composite, (int)1);
        this.createBufferSizePreferences(composite);
        this.createNoteComposite(JFaceResources.getDialogFont(), composite, "Note:", PreferenceMessages.LOG_LABEL_NOTE);
        SWTUtil.createSpacer((Composite)composite, (int)1);
    }

    private void createBufferSizePreferences(Composite parent) {
        Group comp = SWTUtil.createGroup((Composite)parent, (String)PreferenceMessages.LOG_GROUP_BUFFER, (int)1);
        Composite formatComposite = SWTUtil.createCompositeEx((Composite)comp, (int)2, (int)768);
        IntegerFieldEditor intField = new IntegerFieldEditor(KEY_LOG_BUFFER_SIZE, PreferenceMessages.LOG_LABEL_LINES, formatComposite);
        intField.setValidRange(5000, 100000);
        this.addField((FieldEditor)intField);
    }
}

