/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.toolbar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.TreeItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.explorer.ConnectionExplorer;
import org.tizen.common.connection.explorer.ConnectionExplorerPanel;
import org.tizen.common.connection.toolbar.DeviceDescriptor;
import org.tizen.common.connection.toolbar.EmulatorLaunchWorker;
import org.tizen.common.connection.toolbar.Messages;
import org.tizen.common.connection.toolbar.NoTargetDialog;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IDeviceChangeListener;
import org.tizen.sdblib.PlatformCapability;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.service.FileEntry;

public class TargetToolBarManager
implements IDeviceChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(TargetToolBarManager.class);
    private final List<TargetChangeListener> listeners = new LinkedList<TargetChangeListener>();
    private final Map<String, DeviceDescriptor> deviceDescriptors = new LinkedHashMap<String, DeviceDescriptor>();
    private final String initialDeviceName;
    private DeviceDescriptor defaultDeviceDescriptor = null;

    public TargetToolBarManager() {
        SmartDevelopmentBridge.addDeviceChangeListener((IDeviceChangeListener)this);
        this.initialDeviceName = this.getSavedDefaultDescriptor();
    }

    public void addListener(TargetChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(TargetChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    void fireLaunchTargetsChanged(DeviceDescriptor device, int changeMask) {
        for (TargetChangeListener listener : this.listeners) {
            listener.targetsChanged(device, changeMask);
        }
    }

    public IDevice getDefaultLaunchTarget(IProject project) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        return this.getDefaultLaunchTarget(project, (IProgressMonitor)monitor);
    }

    public IDevice getDefaultLaunchTarget(IProject project, IProgressMonitor monitor) throws CoreException {
        int taskCheckInterval = 3000;
        DeviceDescriptor descriptor = this.getDefaultDeviceDescriptor();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        monitor.subTask(Messages.ExceptionNoSelectedTarget);
        if (descriptor == null) {
            if (this.deviceDescriptors.isEmpty()) {
                SWTUtil.syncExec((Runnable)new NoTargetDialogRunnable());
                throw new CoreException((IStatus)new Status(0, "org.tizen.common.connection", Messages.ExceptionNoTarget));
            }
            logger.error("Failed to get default descriptor");
            return null;
        }
        if (descriptor.getDeviceState() == 32) {
            return descriptor.getIDevice();
        }
        if (descriptor.getDeviceState() == 16 && descriptor.getDeviceType() == 1) {
            if (this.launchEmulator(descriptor)) {
                EmulatorLaunchWorker worker = new EmulatorLaunchWorker(descriptor, (IProgressMonitor)subMonitor);
                Thread threadWorker = new Thread((Runnable)worker, "Worker: " + descriptor.getSerialId());
                threadWorker.start();
                while (!worker.isFinished()) {
                    if (subMonitor.isCanceled()) {
                        worker.finish();
                    }
                    try {
                        Thread.sleep(taskCheckInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error("Failed to wait for finished workder properly");
                    }
                }
            } else {
                throw new CoreException((IStatus)new Status(4, "org.tizen.common.connection", Messages.ExceptionCannotRunEmulator));
            }
            return descriptor.getIDevice();
        }
        logger.error("A fatal error occurred from " + descriptor.getSerialId());
        return null;
    }

    public Map<String, DeviceDescriptor> getDeviceDescriptors() {
        return this.deviceDescriptors;
    }

    public void updateDeviceDescriptor(DeviceDescriptor descriptor) {
        IDevice device = descriptor.getIDevice();
        if (device.isEmulator()) {
            if (device.isRemote()) {
                descriptor.setDescriptorName(String.format("%s (%s-%s)", device.getDeviceName(), Messages.ComboTargetNameRemote, device.getArchString()));
                descriptor.setDeviceType(2);
            } else {
                descriptor.setDescriptorName(String.format("%s (%s-%s)", device.getDeviceName(), Messages.ComboTargetNameEmulator, device.getArchString()));
                descriptor.setDeviceType(1);
            }
        } else if (device.isRemote()) {
            descriptor.setDescriptorName(String.format("%s (%s-%s)", device.getDeviceName(), Messages.ComboTargetNameDevice, device.getIp(), device.getArchString()));
            descriptor.setDeviceType(8);
        } else {
            descriptor.setDescriptorName(String.format("%s (%s-%s)", device.getDeviceName(), Messages.ComboTargetNameDevice, device.getArchString()));
            descriptor.setDeviceType(4);
        }
        try {
            PlatformCapability capa = device.getPlatformCapability();
            String platformVersion = capa.getPlatformVersion();
            String profileName = capa.getProfileName();
            descriptor.setTooltipName(String.format("%s (%s %s)", device.getSerialNumber(), profileName, platformVersion));
        }
        catch (IOException e) {
            logger.error("Failed to get platform capability", (Throwable)e);
            descriptor.setTooltipName(null);
        }
        descriptor.setDeviceState(32);
    }

    public String createTooltipName(String modelName, String profileName, String platformVersion, String resolution) {
        profileName = String.valueOf(profileName.substring(0, 1).toUpperCase()) + profileName.substring(1);
        if (StringUtil.isEmpty((CharSequence)resolution)) {
            return String.format("%s (%s %s)", modelName, profileName, platformVersion);
        }
        return String.format("%s (%s %s) - %s", modelName, profileName, platformVersion, resolution);
    }

    public String createTooltipName(String modelName, String profileName, String platformVersion) {
        return this.createTooltipName(modelName, profileName, platformVersion, null);
    }

    public void onConnected(IDevice device) {
        if (this.deviceDescriptors == null) {
            return;
        }
        DeviceDescriptor descriptor = null;
        if (this.deviceDescriptors.containsKey(device.getDeviceName())) {
            descriptor = this.deviceDescriptors.get(device.getDeviceName());
            this.deviceDescriptors.put(device.getSerialNumber(), this.deviceDescriptors.get(device.getDeviceName()));
            this.deviceDescriptors.remove(device.getDeviceName());
            descriptor = this.deviceDescriptors.get(device.getSerialNumber());
            descriptor.setSerialId(device.getDeviceName());
            descriptor.setIDevice(device);
            logger.debug(String.format("Target item(%s-%s) has been online", device.getSerialNumber(), device.getDeviceName()));
        } else {
            descriptor = new DeviceDescriptor(device.getSerialNumber(), device);
            this.addDeviceDescriptor(descriptor);
            logger.debug(String.format("Online Target item(%s-%s) has been added", device.getSerialNumber(), device.getDeviceName()));
        }
        descriptor.notifyIDeviceCreated();
        this.fireLaunchTargetsChanged(descriptor, 1);
    }

    public void onDisconnected(IDevice device) {
        DeviceDescriptor descriptor = this.deviceDescriptors.get(device.getSerialNumber());
        descriptor.setDescriptorName(String.format("%s (%s-%s)", device.getDeviceName(), Messages.ComboTargetNameOffline, device.getArchString()));
        descriptor.setDeviceState(16);
        descriptor.setIDevice(null);
        if (descriptor.getDeviceType() != 1) {
            this.removeDeviceDescriptor(device.getSerialNumber());
        }
        this.fireLaunchTargetsChanged(descriptor, 2);
    }

    public void onChanged(IDevice device, int changeMask) {
        if (changeMask == 1) {
            this.onConnected(device);
        }
    }

    public synchronized void addDeviceDescriptor(DeviceDescriptor descriptor) {
        if (this.deviceDescriptors == null) {
            return;
        }
        this.deviceDescriptors.put(descriptor.getSerialId(), descriptor);
        logger.debug(String.format("Device descriptor(%s) has been added", descriptor.getSerialId()));
    }

    public synchronized void removeDeviceDescriptor(String deviceSerialId) {
        if (this.deviceDescriptors == null) {
            return;
        }
        this.deviceDescriptors.remove(deviceSerialId);
        logger.debug(String.format("Device descriptor(%s) has been removed", deviceSerialId));
        if (this.deviceDescriptors.isEmpty()) {
            this.defaultDeviceDescriptor = null;
            return;
        }
    }

    public void setFirstItemAsDefaultDescriptor() {
        DeviceDescriptor firstItem = this.deviceDescriptors.get(this.deviceDescriptors.keySet().toArray()[0]);
        if (firstItem != null) {
            this.setDefaultDeviceDescriptor(firstItem);
        }
    }

    private String getDefaultDescriptorPreferencePrefix() {
        return this.getClass().getSimpleName();
    }

    private String getSavedDefaultDescriptor() {
        IPreferenceStore store = ConnectionPlugin.getDefault().getPreferenceStore();
        String prefName = this.getDefaultDescriptorPreferencePrefix();
        String descriptorName = store.getString(String.valueOf(prefName) + ".default.descriptor");
        logger.debug(String.format("Target item(%s) has been load from preferences", descriptorName));
        return descriptorName;
    }

    public void saveDefaultDescriptorToPreferenceStore(String descriptor) {
        IPreferenceStore store = ConnectionPlugin.getDefault().getPreferenceStore();
        String prefName = this.getDefaultDescriptorPreferencePrefix();
        store.setValue(String.valueOf(prefName) + ".default.descriptor", descriptor);
        logger.debug(String.format("Target item(%s) has been saved to preferences", descriptor));
    }

    public void setDefaultDeviceDescriptor(DeviceDescriptor defaultDeviceDescriptor) {
        this.defaultDeviceDescriptor = defaultDeviceDescriptor;
        if (defaultDeviceDescriptor == null) {
            return;
        }
        if (defaultDeviceDescriptor.getDeviceState() == 32) {
            ConnectionPlugin.getDefault().setCurrentDevice(defaultDeviceDescriptor.getIDevice());
            this.setConnectionExplorerTreeItem(defaultDeviceDescriptor.getIDevice());
            logger.debug(String.format("Target item(%s) has been selected from connection explorer", defaultDeviceDescriptor.getSerialId()));
        } else {
            ConnectionPlugin.getDefault().setCurrentDevice(null);
            this.setConnectionExplorerTreeItem(null);
            logger.debug("Deselect item from connection explorer");
        }
        logger.debug(String.format("Target item(%s) has been set as a default item", defaultDeviceDescriptor.getSerialId()));
    }

    public DeviceDescriptor getDefaultDeviceDescriptor() {
        return this.defaultDeviceDescriptor;
    }

    public String getInitialDescriptorName() {
        return this.initialDeviceName;
    }

    public DeviceDescriptor getDeviceDescriptor(String deviceName) {
        Map<String, DeviceDescriptor> deviceDescriptors = this.getDeviceDescriptors();
        for (DeviceDescriptor device : deviceDescriptors.values()) {
            if (!device.getDescriptorName().startsWith(deviceName)) continue;
            return device;
        }
        return null;
    }

    public List<DeviceDescriptor> getSortedDeviceItem() {
        Collection<DeviceDescriptor> deviceItems = this.deviceDescriptors.values();
        ArrayList<DeviceDescriptor> list = new ArrayList<DeviceDescriptor>(deviceItems);
        Collections.sort(list);
        return list;
    }

    public boolean launchEmulator(DeviceDescriptor descriptor) {
        descriptor.getSerialId();
        return true;
    }

    private void setConnectionExplorerTreeItem(IDevice device) {
        ConnectionExplorer exp = ConnectionExplorer.getConnectionExplorer();
        if (exp == null) {
            return;
        }
        ConnectionExplorerPanel panel = exp.getConnectionExplorerPanel();
        if (panel != null) {
            try {
                TreeItem[] treeItems = panel.getTreeViewer().getTree().getItems();
                int i = 0;
                while (i < treeItems.length) {
                    FileEntry entry = (FileEntry)treeItems[i].getData();
                    if (device != null) {
                        if (device.equals(entry.getDevice())) {
                            panel.getTreeViewer().getTree().setSelection(treeItems[i]);
                            break;
                        }
                    } else {
                        panel.getTreeViewer().getTree().deselectAll();
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                logger.debug("Failed to update selected item from connection explorer", (Throwable)e);
            }
        }
    }

    class NoTargetDialogRunnable
    implements Runnable {
        NoTargetDialogRunnable() {
        }

        @Override
        public void run() {
            NoTargetDialog noTarget = new NoTargetDialog(SWTUtil.getShell());
            noTarget.open();
        }
    }

    public static interface TargetChangeListener
    extends ConnectionPlugin.ISelectionListener {
        public void targetsChanged(DeviceDescriptor var1, int var2);
    }
}

