/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator.resources;

import java.net.URL;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IAggregateWorkingSet;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.navigator.framelist.Frame;
import org.eclipse.ui.internal.navigator.framelist.FrameList;
import org.eclipse.ui.internal.navigator.framelist.TreeFrame;
import org.eclipse.ui.internal.navigator.resources.ResourceToItemsMapper;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.ICommonViewerMapper;
import org.osgi.framework.Bundle;

public final class ProjectExplorer
extends CommonNavigator {
    public static final String VIEW_ID = "org.eclipse.ui.navigator.ProjectExplorer";
    public static final int WORKING_SETS = 0;
    public static final int PROJECTS = 1;
    private int rootMode;
    private boolean isMouseInImageArea = false;
    private String workingSetLabel;

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        this.getCommonViewer().setMapper((ICommonViewerMapper)new ResourceToItemsMapper(this.getCommonViewer()));
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.navigator.resources");
        URL fullPathString = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/full/wizban/new_project.png"), null);
        ImageDescriptor imageDesc = ImageDescriptor.createFromURL((URL)fullPathString);
        final Image image = imageDesc.createImage();
        final Tree tree = this.getCommonViewer().getTree();
        tree.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent event) {
                tree.redraw();
            }

            public void controlMoved(ControlEvent event) {
                tree.redraw();
            }
        });
        final TextLayout textLayout = new TextLayout((Device)Display.getCurrent());
        textLayout.setAlignment(0x1000000);
        textLayout.setText("Create new project");
        tree.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (tree.getItemCount() != 0) {
                    return;
                }
                GC gc = event.gc;
                if (!ProjectExplorer.this.isMouseInImageArea) {
                    gc.setAlpha(100);
                }
                int y = tree.getSize().y / 2 - 50;
                gc.drawImage(image, tree.getSize().x / 2 - 50, y);
                textLayout.draw(gc, 0, y + 100);
            }
        });
        tree.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                int size = tree.getSize().x;
                if (size > 0) {
                    textLayout.setWidth(size);
                }
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                if (tree.getItemCount() != 0) {
                    return;
                }
                int x = event.x;
                int y = event.y;
                if (tree.getSize().x / 2 - 50 < x && x < tree.getSize().x / 2 + 50 && tree.getSize().y / 2 - 50 < y && y < tree.getSize().y / 2 + 50) {
                    ProjectExplorer.this.isMouseInImageArea = false;
                    tree.redraw();
                    ICommandService service = (ICommandService)ProjectExplorer.this.getViewSite().getService(ICommandService.class);
                    Command command = service.getCommand("org.tizen.common.ui.command.projectwizard");
                    try {
                        command.executeWithChecks(new ExecutionEvent());
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                    catch (NotDefinedException e) {
                        e.printStackTrace();
                    }
                    catch (NotEnabledException e) {
                        e.printStackTrace();
                    }
                    catch (NotHandledException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                if (tree.getItemCount() != 0) {
                    return;
                }
                int x = event.x;
                int y = event.y;
                if (tree.getSize().x / 2 - 50 < x && x < tree.getSize().x / 2 + 50 && tree.getSize().y / 2 - 50 < y && y < tree.getSize().y / 2 + 50) {
                    if (!ProjectExplorer.this.isMouseInImageArea) {
                        ProjectExplorer.this.isMouseInImageArea = true;
                        tree.redraw();
                    }
                } else if (ProjectExplorer.this.isMouseInImageArea) {
                    ProjectExplorer.this.isMouseInImageArea = false;
                    tree.redraw();
                }
            }
        });
    }

    public void updateTitle() {
        super.updateTitle();
        Object input = this.getCommonViewer().getInput();
        if (input == null || input instanceof IAggregateWorkingSet) {
            this.setContentDescription("");
            return;
        }
        if (!(input instanceof IResource)) {
            IWorkbenchAdapter wbadapter;
            String label = ((ILabelProvider)this.getCommonViewer().getLabelProvider()).getText(input);
            if (label != null) {
                this.setContentDescription(label);
                return;
            }
            if (input instanceof IAdaptable && (wbadapter = (IWorkbenchAdapter)((IAdaptable)input).getAdapter(IWorkbenchAdapter.class)) != null) {
                this.setContentDescription(wbadapter.getLabel(input));
                return;
            }
            this.setContentDescription(input.toString());
            return;
        }
        IResource res = (IResource)input;
        this.setContentDescription(res.getName());
    }

    public String getFrameToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? (element instanceof IAggregateWorkingSet ? WorkbenchNavigatorMessages.ProjectExplorerPart_workingSetModel : (element instanceof IWorkingSet ? ((IWorkingSet)element).getLabel() : super.getFrameToolTipText(element))) : ((path = ((IResource)element).getFullPath()).isRoot() ? WorkbenchNavigatorMessages.ProjectExplorerPart_workspace : path.makeRelative().toString());
        if (this.rootMode == 1) {
            if (this.workingSetLabel == null) {
                return result;
            }
            if (result.length() == 0) {
                return NLS.bind((String)WorkbenchNavigatorMessages.ProjectExplorer_toolTip, (Object[])new String[]{this.workingSetLabel});
            }
            return NLS.bind((String)WorkbenchNavigatorMessages.ProjectExplorer_toolTip2, (Object[])new String[]{result, this.workingSetLabel});
        }
        if (element != null && !(element instanceof IWorkingSet) && this.getCommonViewer() != null) {
            FrameList frameList = this.getCommonViewer().getFrameList();
            if (frameList == null) {
                return result;
            }
            int index = frameList.getCurrentIndex();
            IWorkingSet ws = null;
            while (index >= 0) {
                Object input;
                Frame frame = frameList.getFrame(index);
                if (frame instanceof TreeFrame && (input = ((TreeFrame)frame).getInput()) instanceof IWorkingSet && !(input instanceof IAggregateWorkingSet)) {
                    ws = (IWorkingSet)input;
                    break;
                }
                --index;
            }
            if (ws != null) {
                return NLS.bind((String)WorkbenchNavigatorMessages.ProjectExplorer_toolTip3, (Object[])new String[]{ws.getLabel(), result});
            }
            return result;
        }
        return result;
    }

    public void setRootMode(int mode) {
        this.rootMode = mode;
    }

    public int getRootMode() {
        return this.rootMode;
    }

    public void setWorkingSetLabel(String label) {
        this.workingSetLabel = label;
    }

    public String getWorkingSetLabel() {
        return this.workingSetLabel;
    }

    protected void handleDoubleClick(DoubleClickEvent anEvent) {
        IStructuredSelection selection;
        Object element;
        ICommandService commandService = (ICommandService)this.getViewSite().getService(ICommandService.class);
        Command openProjectCommand = commandService.getCommand("org.eclipse.ui.project.openProject");
        if (openProjectCommand != null && openProjectCommand.isHandled() && (element = (selection = (IStructuredSelection)anEvent.getSelection()).getFirstElement()) instanceof IProject && !((IProject)element).isOpen()) {
            try {
                openProjectCommand.executeWithChecks(new ExecutionEvent());
            }
            catch (CommandException ex) {
                IStatus status = WorkbenchNavigatorPlugin.createErrorStatus("'Open Project' failed", ex);
                WorkbenchNavigatorPlugin.getDefault().getLog().log(status);
            }
            return;
        }
        super.handleDoubleClick(anEvent);
    }
}

