/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.internal.core.LaunchDelegate;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchCategoryFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.PerspectiveManager;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class LaunchPerspectivePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IActivityManagerListener {
    private RadioGroupFieldEditor fSwitchLaunch = null;
    private RadioGroupFieldEditor fSwitchSuspend = null;
    private Tree fTree = null;
    private PerspectivesTreeViewer fTreeViewer = null;
    private PerspectivesPanel fPerspectivesPanel = null;
    private static String[] fgPerspectiveLabels = null;
    private static Map<String, String> fgPerspectiveIdMap = null;
    private static HashSet<PerspectiveChange> fgChangeSet = null;
    private static HashSet<Object> fgCurrentWorkingContext = null;
    private SelectionListener fSelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object o2 = e.getSource();
            if (o2 instanceof Combo) {
                Combo combo = (Combo)o2;
                LaunchDelegate delegate = null;
                ILaunchConfigurationType type = null;
                PerspectiveChange change = null;
                for (Object o2 : fgCurrentWorkingContext) {
                    if (o2 instanceof ILaunchDelegate) {
                        delegate = (LaunchDelegate)o2;
                        type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(delegate.getLaunchConfigurationTypeId());
                    } else if (o2 instanceof ILaunchConfigurationType) {
                        delegate = null;
                        type = (ILaunchConfigurationType)o2;
                    }
                    Set modes = (Set)combo.getData();
                    change = LaunchPerspectivePreferencePage.this.findChange(type, (ILaunchDelegate)delegate, modes);
                    if (change == null) {
                        change = new PerspectiveChange(type, (ILaunchDelegate)delegate, modes, (String)fgPerspectiveIdMap.get(combo.getText()));
                        fgChangeSet.add(change);
                        continue;
                    }
                    change.fPid = (String)fgPerspectiveIdMap.get(combo.getText());
                }
            }
        }
    };

    public void dispose() {
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().removeActivityManagerListener((IActivityManagerListener)this);
        fgPerspectiveIdMap.clear();
        fgPerspectiveIdMap = null;
        fgPerspectiveLabels = null;
        fgChangeSet.clear();
        fgChangeSet = null;
        if (fgCurrentWorkingContext != null) {
            fgCurrentWorkingContext.clear();
            fgCurrentWorkingContext = null;
        }
        super.dispose();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.debug.ui.perspective_preference_page_context");
    }

    protected Control createContents(Composite parent) {
        SWTFactory.createWrapLabel(parent, DebugPreferencesMessages.PerspectivePreferencePage_0, 2, 300);
        SWTFactory.createVerticalSpacer(parent, 1);
        this.fSwitchLaunch = new RadioGroupFieldEditor("org.eclipse.debug.ui.switch_to_perspective", DebugPreferencesMessages.LaunchingPreferencePage_11, 3, (String[][])new String[][]{{DebugPreferencesMessages.LaunchingPreferencePage_12, "always"}, {DebugPreferencesMessages.LaunchingPreferencePage_13, "never"}, {DebugPreferencesMessages.LaunchingPreferencePage_14, "prompt"}}, SWTFactory.createComposite(parent, 1, 2, 768), true);
        this.fSwitchLaunch.setPreferenceName("org.eclipse.debug.ui.switch_to_perspective");
        this.fSwitchLaunch.setPreferenceStore(this.getPreferenceStore());
        this.fSwitchSuspend = new RadioGroupFieldEditor("org.eclipse.debug.ui.switch_perspective_on_suspend", DebugPreferencesMessages.DebugPreferencePage_21, 3, (String[][])new String[][]{{DebugPreferencesMessages.DebugPreferencePage_22, "always"}, {DebugPreferencesMessages.DebugPreferencePage_23, "never"}, {DebugPreferencesMessages.DebugPreferencePage_24, "prompt"}}, SWTFactory.createComposite(parent, 1, 2, 768), true);
        this.fSwitchSuspend.setPreferenceName("org.eclipse.debug.ui.switch_perspective_on_suspend");
        this.fSwitchSuspend.setPreferenceStore(this.getPreferenceStore());
        SWTFactory.createVerticalSpacer(parent, 1);
        SWTFactory.createWrapLabel(parent, DebugPreferencesMessages.PerspectivePreferencePage_5, 2, 300);
        Composite comp = SWTFactory.createComposite(parent, parent.getFont(), 2, 1, 1808, 0, 0);
        this.createTreeViewer(comp);
        this.fPerspectivesPanel = new PerspectivesPanel(comp, DebugPreferencesMessages.PerspectivePreferencePage_2);
        this.initializeControls();
        PlatformUI.getWorkbench().getActivitySupport().getActivityManager().addActivityManagerListener((IActivityManagerListener)this);
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    protected void createTreeViewer(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1040);
        SWTFactory.createWrapLabel(comp, DebugPreferencesMessages.PerspectivePreferencePage_1, 1);
        this.fTree = new Tree(comp, 2818);
        GridData gd = new GridData(1040);
        gd.widthHint = 220;
        gd.heightHint = 250;
        this.fTree.setLayoutData((Object)gd);
        this.fTreeViewer = new PerspectivesTreeViewer(this.fTree);
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LaunchPerspectivePreferencePage.this.fPerspectivesPanel.refreshPanel((IStructuredSelection)event.getSelection());
            }
        });
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                if (!ss.isEmpty()) {
                    Object obj = ss.getFirstElement();
                    LaunchPerspectivePreferencePage.this.fTreeViewer.setExpandedState(obj, !LaunchPerspectivePreferencePage.this.fTreeViewer.getExpandedState(obj));
                }
            }
        });
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        this.fTreeViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        this.fTreeViewer.setContentProvider((IContentProvider)new PerspectiveContentProvider());
        this.fTreeViewer.addFilter(new LaunchCategoryFilter("org.eclipse.ui.externaltools.builder"));
        this.fTreeViewer.setInput(DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes());
    }

    protected void createCombos(Composite parent, Object[] selection) {
        Set<Set<String>> modes = this.collectCommonModeSets(selection);
        if (modes.isEmpty()) {
            this.fPerspectivesPanel.setMessage(DebugPreferencesMessages.LaunchPerspectivePreferencePage_1);
            return;
        }
        this.fPerspectivesPanel.setMessage("");
        List<String> fmodes = null;
        Combo combo = null;
        for (Set<String> smodes : modes) {
            fmodes = LaunchConfigurationPresentationManager.getDefault().getLaunchModeNames(smodes);
            if (fmodes.isEmpty()) continue;
            String modeString = fmodes.size() == 1 ? fmodes.get(0).toString() : fmodes.toString();
            SWTFactory.createLabel(parent, String.valueOf(modeString) + ":", 1);
            combo = SWTFactory.createCombo(parent, 8, 1, fgPerspectiveLabels);
            if (combo == null) continue;
            String text = this.getComboSelection(smodes);
            if (text != null) {
                combo.setText(text);
            }
            combo.setData(smodes);
            combo.addSelectionListener(this.fSelectionListener);
            GridData gd = (GridData)combo.getLayoutData();
            gd.grabExcessHorizontalSpace = true;
        }
    }

    private String getComboSelection(Set<String> modes) {
        String text = DebugPreferencesMessages.PerspectivePreferencePage_4;
        IStructuredSelection ss = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (ss != null && !ss.isEmpty()) {
            Object o2 = null;
            HashSet<String> tmp = new HashSet<String>();
            String id = null;
            ILaunchConfigurationType type = null;
            LaunchDelegate delegate = null;
            PerspectiveChange change = null;
            for (Object o2 : ss) {
                if (o2 instanceof LaunchDelegate) {
                    delegate = o2;
                    type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(delegate.getLaunchConfigurationTypeId());
                } else if (o2 instanceof ILaunchConfigurationType) {
                    type = o2;
                }
                change = this.findChange(type, (ILaunchDelegate)delegate, modes);
                id = change != null ? change.getPerspectiveId() : DebugUIPlugin.getDefault().getPerspectiveManager().getLaunchPerspective(type, modes, (ILaunchDelegate)delegate);
                if (id == null) {
                    id = "perspective_none";
                }
                tmp.add(id);
            }
            if (tmp.size() == 1 && !"perspective_none".equals(id = (String)tmp.iterator().next())) {
                for (Map.Entry<String, String> entry : fgPerspectiveIdMap.entrySet()) {
                    if (!id.equals(entry.getValue())) continue;
                    return entry.getKey();
                }
            }
        }
        return text;
    }

    private PerspectiveChange findChange(ILaunchConfigurationType type, ILaunchDelegate delegate, Set<String> modes) {
        PerspectiveChange change = new PerspectiveChange(type, delegate, modes, null);
        for (PerspectiveChange ch : fgChangeSet) {
            if (!change.equals(ch)) continue;
            return ch;
        }
        return null;
    }

    protected Set<Set<String>> collectCommonModeSets(Object[] selection) {
        HashSet<ILaunchDelegate> delegates = new HashSet<ILaunchDelegate>();
        Object o = null;
        int i = 0;
        while (i < selection.length) {
            o = selection[i];
            if (o instanceof ILaunchDelegate) {
                delegates.add((ILaunchDelegate)o);
            } else if (o instanceof ILaunchConfigurationType) {
                fgCurrentWorkingContext.add(o);
                Object[] kids = this.fTreeViewer.getFilteredChildren(o);
                int j = 0;
                while (j < kids.length) {
                    delegates.add((ILaunchDelegate)kids[i]);
                    ++j;
                }
            }
            ++i;
        }
        HashSet<Set<String>> common = new HashSet<Set<String>>();
        List modes = null;
        HashSet<Set<String>> pruned = new HashSet<Set<String>>();
        for (ILaunchDelegate delegate : delegates) {
            modes = delegate.getModes();
            for (Set fmodes : modes) {
                if (!this.isCommonModeset(fmodes, delegates, pruned)) continue;
                common.add(fmodes);
                fgCurrentWorkingContext.add(delegate);
            }
        }
        return common;
    }

    private boolean isCommonModeset(Set<String> modeset, Set<ILaunchDelegate> delegates, Set<Set<String>> pruned) {
        if (!pruned.contains(modeset)) {
            boolean common = true;
            for (ILaunchDelegate delegate : delegates) {
                common &= delegate.getModes().contains(modeset);
            }
            if (!common) {
                pruned.add(modeset);
            } else {
                return true;
            }
        }
        return false;
    }

    protected void initializeControls() {
        if (this.fTree.getItemCount() > 0) {
            TreeItem item = this.fTree.getItem(0);
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(item.getData()));
            this.fTreeViewer.expandToLevel(item.getData(), 1);
        }
        this.fSwitchLaunch.load();
        this.fSwitchSuspend.load();
    }

    protected void performDefaults() {
        fgChangeSet.clear();
        this.fSwitchLaunch.loadDefault();
        this.fSwitchSuspend.loadDefault();
        PerspectiveManager pm = DebugUIPlugin.getDefault().getPerspectiveManager();
        TreeItem[] items = this.fTree.getItems();
        ILaunchConfigurationType type = null;
        HashSet modes = null;
        Object[] delegates = null;
        int i = 0;
        while (i < items.length) {
            type = (ILaunchConfigurationType)items[i].getData();
            modes = type.getSupportedModeCombinations();
            delegates = this.fTreeViewer.getFilteredChildren(type);
            for (Set modeset : modes) {
                fgChangeSet.add(new PerspectiveChange(type, null, modeset, pm.getDefaultLaunchPerspective(type, null, modeset)));
            }
            int j = 0;
            while (j < delegates.length) {
                ILaunchDelegate delegate = (ILaunchDelegate)delegates[j];
                modes = new HashSet(delegate.getModes());
                for (Set modeset : modes) {
                    fgChangeSet.add(new PerspectiveChange(type, delegate, modeset, pm.getDefaultLaunchPerspective(type, delegate, modeset)));
                }
                ++j;
            }
            ++i;
        }
        if (this.fTree.getItemCount() > 0) {
            TreeItem item = this.fTree.getItem(0);
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(item.getData()));
            this.fTreeViewer.expandToLevel(item.getData(), 1);
        }
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(DebugUIPlugin.getDefault().getPreferenceStore());
        fgChangeSet = new HashSet();
        fgPerspectiveIdMap = new HashMap<String, String>();
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(DebugPreferencesMessages.PerspectivePreferencePage_4);
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] descriptors = registry.getPerspectives();
        String label = null;
        int i = 0;
        while (i < descriptors.length) {
            if (!WorkbenchActivityHelper.filterItem((Object)descriptors[i])) {
                label = descriptors[i].getLabel();
                labels.add(label);
                fgPerspectiveIdMap.put(label, descriptors[i].getId());
            }
            ++i;
        }
        fgPerspectiveLabels = labels.toArray(new String[labels.size()]);
    }

    public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
        if (!this.fTree.isDisposed()) {
            this.fTreeViewer.refresh();
        }
    }

    public boolean performOk() {
        this.fSwitchLaunch.store();
        this.fSwitchSuspend.store();
        if (!fgChangeSet.isEmpty()) {
            PerspectiveManager mgr = DebugUIPlugin.getDefault().getPerspectiveManager();
            for (PerspectiveChange change : fgChangeSet) {
                mgr.setLaunchPerspective(change.getType(), change.getModes(), change.getDelegate(), change.getPerspectiveId());
            }
        }
        return super.performOk();
    }

    final class PerspectiveChange {
        private ILaunchConfigurationType fType = null;
        private ILaunchDelegate fDelegate = null;
        private Set<String> fModes = null;
        private String fPid = null;

        public PerspectiveChange(ILaunchConfigurationType type, ILaunchDelegate delegate, Set<String> modes, String perspectiveid) {
            this.fType = type;
            this.fDelegate = delegate;
            this.fModes = modes;
            this.fPid = perspectiveid;
        }

        public ILaunchConfigurationType getType() {
            return this.fType;
        }

        public ILaunchDelegate getDelegate() {
            return this.fDelegate;
        }

        public String getPerspectiveId() {
            return this.fPid;
        }

        public Set<String> getModes() {
            return this.fModes;
        }

        public boolean equals(Object o) {
            if (o instanceof PerspectiveChange) {
                PerspectiveChange change = (PerspectiveChange)o;
                return change.getDelegate() == this.fDelegate && change.getType().equals(this.fType) && change.getModes().equals(this.fModes);
            }
            return super.equals(o);
        }

        public int hashCode() {
            return (this.fDelegate != null ? this.fDelegate.hashCode() : 0) + this.fType.hashCode() + this.fModes.hashCode();
        }
    }

    final class PerspectiveContentProvider
    implements ITreeContentProvider {
        PerspectiveContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ILaunchConfigurationType) {
                ILaunchConfigurationType type = (ILaunchConfigurationType)parentElement;
                return ((LaunchManager)DebugPlugin.getDefault().getLaunchManager()).getLaunchDelegates(type.getIdentifier());
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        }

        public boolean hasChildren(Object element) {
            return element instanceof ILaunchConfigurationType;
        }

        public Object getParent(Object element) {
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class PerspectivesPanel {
        private Composite fMainComposite = null;
        private Label fMessage = null;

        public PerspectivesPanel(Composite parent, String heading) {
            this.createPanel(parent, heading);
        }

        protected void createPanel(Composite parent, String heading) {
            this.fMainComposite = SWTFactory.createComposite(parent, 2, 1, 1808);
            SWTFactory.createWrapLabel(this.fMainComposite, heading, 2);
            this.fMessage = SWTFactory.createWrapLabel(this.fMainComposite, "", 2, 250);
        }

        public void setMessage(String msg) {
            this.fMessage.setText(msg == null ? "" : msg);
        }

        public void refreshPanel(IStructuredSelection selection) {
            Control[] children = this.fMainComposite.getChildren();
            int i = 2;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
            if (fgCurrentWorkingContext == null) {
                fgCurrentWorkingContext = new HashSet();
            }
            fgCurrentWorkingContext.clear();
            if (!selection.isEmpty()) {
                LaunchPerspectivePreferencePage.this.createCombos(this.fMainComposite, selection.toArray());
                this.fMainComposite.layout();
            } else {
                SWTFactory.createWrapLabel(this.fMainComposite, DebugPreferencesMessages.LaunchPerspectivePreferencePage_0, 2, 275);
            }
            this.fMainComposite.layout();
        }
    }

    final class PerspectivesTreeViewer
    extends TreeViewer {
        public PerspectivesTreeViewer(Tree tree) {
            super(tree);
        }

        public Object[] getFilteredChildren(Object o) {
            return super.getFilteredChildren(o);
        }
    }
}

