/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.custom.TizenResourceManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TizenList
extends Canvas {
    private static final String STR_EMPTY = "";
    private static final int RIGHT_TEXT_MARGIN = 5;
    private static final int MOUSE_RIGHT = 3;
    private int originalStyle = 0;
    private List<String> itemList = null;
    private List<Integer> selectionList = null;
    private List<Rectangle> cellList = null;
    private int hoverIndex = -1;
    private boolean isPressedShiftKey = false;
    private int clickIndexWithShift = 0;
    private int pressedKey = 0;
    private int clickIndexWithoutShift = 0;
    private int selectionIndex = -1;
    private int firstIndexOfCurrentArea = 0;
    protected ScrollBar vScrollbar = null;
    private int vScrollbarSelection = 0;
    protected ScrollBar hScrollbar = null;
    private int maxContentLenght = 0;
    private int contentHeight = 0;
    private int topIndex = 0;

    public TizenList(Composite parent, int style) {
        super(parent, TizenList.filteringSyle(style) | 0x20000000);
        this.originalStyle = style;
        this.selectionList = new ArrayList<Integer>();
        this.itemList = new ArrayList<String>();
        this.cellList = new ArrayList<Rectangle>();
        this.addListeners();
        this.setBackground(TizenResourceManager.WHITE_COLOR);
    }

    static int filteringSyle(int style) {
        int bits = 2822;
        return style & bits;
    }

    private void addListeners() {
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                TizenList.this.updateScrollbarBound();
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                switch (e.detail) {
                    case 8: 
                    case 16: {
                        e.doit = true;
                        break;
                    }
                    case 2: {
                        e.doit = true;
                    }
                }
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TizenList.this.paint(e);
            }
        });
        this.addMouseListeners();
        this.addKeyListeners();
        this.addScrollListeners();
    }

    private boolean isMultiSelectionStyle() {
        return (this.originalStyle & 2) == 2;
    }

    private boolean isVScrollStyle() {
        return (this.originalStyle & 0x200) == 512;
    }

    private boolean isHScrollStyle() {
        return (this.originalStyle & 0x100) == 256;
    }

    private void addMouseListeners() {
        this.addListener(5, new Listener(){

            public void handleEvent(Event e) {
                TizenList.this.updateMouseHoverPoint(e);
            }
        });
        this.addListener(7, new Listener(){

            public void handleEvent(Event e) {
                TizenList.this.hoverIndex = -1;
                TizenList.this.redraw(TizenList.this.getClientArea().x, TizenList.this.getClientArea().y, TizenList.this.getClientArea().width, TizenList.this.getClientArea().height, false);
            }
        });
        this.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                if (e.button == 3) {
                    return;
                }
                if (!TizenList.this.isMultiSelectionStyle()) {
                    return;
                }
                switch (TizenList.this.pressedKey) {
                    case 262144: {
                        int index = TizenList.this.selectionList.indexOf(TizenList.this.hoverIndex);
                        if (index == -1) {
                            TizenList.this.select(TizenList.this.hoverIndex);
                            break;
                        }
                        TizenList.this.deselect(index);
                        break;
                    }
                    case 131072: {
                        TizenList.this.updateSelection(TizenList.this.clickIndexWithoutShift, TizenList.this.hoverIndex);
                    }
                }
                if (TizenList.this.pressedKey != 131072) {
                    TizenList.this.clickIndexWithoutShift = TizenList.this.hoverIndex;
                }
                TizenList.this.redraw(TizenList.this.getClientArea().x, TizenList.this.getClientArea().y, TizenList.this.getClientArea().width, TizenList.this.getClientArea().height, false);
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event e) {
                if (e.button == 3 || TizenList.this.hoverIndex == -1) {
                    return;
                }
                if (TizenList.this.pressedKey == 0 || !TizenList.this.isMultiSelectionStyle()) {
                    TizenList.this.deselectAll();
                    TizenList.this.addSelectionIndex(TizenList.this.selectionList, TizenList.this.hoverIndex);
                }
                TizenList.this.selectionIndex = TizenList.this.hoverIndex;
                TizenList.this.fireSelectionEvent(13);
                TizenList.this.redraw(TizenList.this.getClientArea().x, TizenList.this.getClientArea().y, TizenList.this.getClientArea().width, TizenList.this.getClientArea().height, false);
            }
        });
        this.addListener(8, new Listener(){

            public void handleEvent(Event e) {
                TizenList.this.fireSelectionEvent(14);
            }
        });
        if (!this.isVScrollStyle()) {
            this.addListener(37, new Listener(){

                public void handleEvent(Event e) {
                    if (e.count > 0) {
                        TizenList tizenList = TizenList.this;
                        tizenList.firstIndexOfCurrentArea = tizenList.firstIndexOfCurrentArea - 1;
                    } else {
                        TizenList tizenList = TizenList.this;
                        tizenList.firstIndexOfCurrentArea = tizenList.firstIndexOfCurrentArea + 1;
                    }
                    int firstIndexOfLastArea = TizenList.this.getItemCount() - TizenList.this.getItemCountOfArea();
                    if (TizenList.this.firstIndexOfCurrentArea >= firstIndexOfLastArea) {
                        TizenList.this.firstIndexOfCurrentArea = firstIndexOfLastArea;
                    } else if (TizenList.this.firstIndexOfCurrentArea < 0) {
                        TizenList.this.firstIndexOfCurrentArea = 0;
                    }
                    TizenList.this.redraw(TizenList.this.getClientArea().x, TizenList.this.getClientArea().y, TizenList.this.getClientArea().width, TizenList.this.getClientArea().height, false);
                }
            });
        }
    }

    private void addKeyListeners() {
        this.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                TizenList.this.pressedKey = 0;
                if (event.keyCode == 131072) {
                    TizenList.this.isPressedShiftKey = false;
                    TizenList.this.clickIndexWithShift = 0;
                }
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 131072) {
                    TizenList.this.isPressedShiftKey = true;
                    TizenList.this.clickIndexWithShift = TizenList.this.getSelectionIndex();
                }
                switch (event.character) {
                    case '\r': 
                    case ' ': {
                        int lastSelectionIndex = (Integer)TizenList.this.selectionList.get(TizenList.this.selectionList.size() - 1);
                        TizenList.this.selectionList.clear();
                        TizenList.this.addSelectionIndex(TizenList.this.selectionList, lastSelectionIndex);
                        TizenList.this.redraw(TizenList.this.getClientArea().x, TizenList.this.getClientArea().y, TizenList.this.getClientArea().width, TizenList.this.getClientArea().height, false);
                        TizenList.this.fireSelectionEvent(13);
                        TizenList.this.fireSelectionEvent(14);
                        return;
                    }
                }
                int itemCountOfArea = TizenList.this.getItemCountOfArea() - 1;
                int lastIndexOfArea = TizenList.this.firstIndexOfCurrentArea + itemCountOfArea;
                int n = event.keyCode;
                TizenList.this.pressedKey = n;
                switch (n) {
                    case 0x1000001: {
                        TizenList tizenList = TizenList.this;
                        tizenList.selectionIndex = tizenList.selectionIndex - 1;
                        if (TizenList.this.selectionIndex < 0) {
                            TizenList.this.selectionIndex = 0;
                            return;
                        }
                        if (TizenList.this.selectionIndex >= TizenList.this.firstIndexOfCurrentArea) break;
                        TizenList tizenList2 = TizenList.this;
                        tizenList2.firstIndexOfCurrentArea = tizenList2.firstIndexOfCurrentArea - 1;
                        --lastIndexOfArea;
                        break;
                    }
                    case 0x1000002: {
                        TizenList tizenList = TizenList.this;
                        tizenList.selectionIndex = tizenList.selectionIndex + 1;
                        if (TizenList.this.selectionIndex >= TizenList.this.getItemCount()) {
                            TizenList.this.selectionIndex = TizenList.this.getItemCount() - 1;
                            return;
                        }
                        if (TizenList.this.selectionIndex <= lastIndexOfArea) break;
                        TizenList tizenList3 = TizenList.this;
                        tizenList3.firstIndexOfCurrentArea = tizenList3.firstIndexOfCurrentArea + 1;
                        ++lastIndexOfArea;
                        break;
                    }
                    case 0x1000005: {
                        TizenList tizenList = TizenList.this;
                        tizenList.selectionIndex = tizenList.selectionIndex - itemCountOfArea;
                        if (TizenList.this.selectionIndex < 0) {
                            TizenList.this.selectionIndex = 0;
                            break;
                        }
                        if (TizenList.this.selectionIndex - itemCountOfArea <= 0) {
                            TizenList.this.firstIndexOfCurrentArea = 0;
                            lastIndexOfArea = itemCountOfArea;
                            break;
                        }
                        TizenList tizenList4 = TizenList.this;
                        tizenList4.firstIndexOfCurrentArea = tizenList4.firstIndexOfCurrentArea - itemCountOfArea;
                        lastIndexOfArea -= itemCountOfArea;
                        break;
                    }
                    case 0x1000006: {
                        TizenList tizenList = TizenList.this;
                        tizenList.selectionIndex = tizenList.selectionIndex + itemCountOfArea;
                        if (TizenList.this.selectionIndex >= TizenList.this.getItemCount()) {
                            TizenList.this.selectionIndex = TizenList.this.getItemCount() - 1;
                            break;
                        }
                        if (TizenList.this.selectionIndex + itemCountOfArea >= TizenList.this.getItemCount()) {
                            TizenList.this.firstIndexOfCurrentArea = TizenList.this.getItemCount() - 1 - itemCountOfArea;
                            lastIndexOfArea = TizenList.this.getItemCount() - 1;
                            break;
                        }
                        TizenList tizenList5 = TizenList.this;
                        tizenList5.firstIndexOfCurrentArea = tizenList5.firstIndexOfCurrentArea + itemCountOfArea;
                        lastIndexOfArea += itemCountOfArea;
                        break;
                    }
                    case 0x1000007: {
                        TizenList.this.selectionIndex = 0;
                        TizenList.this.firstIndexOfCurrentArea = 0;
                        lastIndexOfArea = TizenList.this.firstIndexOfCurrentArea + itemCountOfArea;
                        break;
                    }
                    case 0x1000008: {
                        TizenList.this.selectionIndex = TizenList.this.getItemCount() - 1;
                        TizenList.this.firstIndexOfCurrentArea = TizenList.this.selectionIndex - itemCountOfArea;
                        lastIndexOfArea = TizenList.this.selectionIndex;
                    }
                }
                TizenList.this.updateSelectionByKey();
                if (TizenList.this.isVScrollStyle()) {
                    TizenList.this.vScrollbar.setSelection(TizenList.this.firstIndexOfCurrentArea);
                }
                TizenList.this.hoverIndex = -1;
                TizenList.this.fireSelectionEventByKeyInput();
                TizenList.this.redraw(TizenList.this.getClientArea().x, TizenList.this.getClientArea().y, TizenList.this.getClientArea().width, TizenList.this.getClientArea().height, false);
            }
        });
    }

    private void updateSelectionByKey() {
        if (this.isPressedShiftKey && this.isMultiSelectionStyle()) {
            int backupSelectionIndex = this.selectionIndex;
            this.updateSelection(this.clickIndexWithShift, this.selectionIndex);
            this.selectionIndex = backupSelectionIndex;
        } else {
            this.deselectAll();
            this.addSelectionIndex(this.selectionList, this.selectionIndex);
        }
    }

    private void fireSelectionEventByKeyInput() {
        if (this.isDisposed()) {
            return;
        }
        Event e = new Event();
        e.item = this;
        e.widget = this;
        e.type = 13;
        this.notifyListeners(13, e);
    }

    private void fireSelectionEvent(int eventType) {
        if (this.isDisposed()) {
            return;
        }
        if (this.hoverIndex == -1) {
            return;
        }
        Event e = new Event();
        e.item = this;
        e.widget = this;
        e.type = eventType;
        this.notifyListeners(eventType, e);
    }

    private void updateSelection(int startIndex, int endIndex) {
        this.selectionList.clear();
        if (startIndex > endIndex) {
            this.setSelection(endIndex, startIndex);
        } else {
            this.setSelection(startIndex, endIndex);
        }
    }

    private void addScrollListeners() {
        if (this.isVScrollStyle()) {
            this.vScrollbar = this.getVerticalBar();
            this.vScrollbar.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TizenList.this.firstIndexOfCurrentArea = TizenList.this.vScrollbar.getSelection();
                    TizenList.this.redraw(TizenList.this.getClientArea().x, TizenList.this.getClientArea().y, TizenList.this.getClientArea().width, TizenList.this.getClientArea().height, false);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    TizenList.this.firstIndexOfCurrentArea = TizenList.this.vScrollbar.getSelection();
                    TizenList.this.redraw(TizenList.this.getClientArea().x, TizenList.this.getClientArea().y, TizenList.this.getClientArea().width, TizenList.this.getClientArea().height, false);
                }
            });
        }
        if (this.isHScrollStyle()) {
            this.hScrollbar = this.getHorizontalBar();
            this.hScrollbar.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TizenList.this.redraw(TizenList.this.getClientArea().x, TizenList.this.getClientArea().y, TizenList.this.getClientArea().width, TizenList.this.getClientArea().height, false);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    TizenList.this.redraw(TizenList.this.getClientArea().x, TizenList.this.getClientArea().y, TizenList.this.getClientArea().width, TizenList.this.getClientArea().height, false);
                }
            });
        }
    }

    private void updateMouseHoverPoint(Event e) {
        List<Rectangle> rs = this.cellList;
        int i = 0;
        while (i < rs.size()) {
            int index = i + this.firstIndexOfCurrentArea;
            if (rs.get(i).contains(e.x, e.y) && index < this.getItemCount()) {
                this.hoverIndex = index;
                this.redraw(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width, this.getClientArea().height, false);
                return;
            }
            ++i;
        }
        this.hoverIndex = -1;
        this.redraw(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width, this.getClientArea().height, false);
    }

    private Point getTextSize(String text) {
        Point size = new Point(0, 0);
        GC gc = new GC(this);
        if (text != null && text.length() > 0) {
            Point e = gc.textExtent(text, 8);
            size.x += e.x;
            size.y = Math.max(size.y, e.y);
        } else {
            size.y = Math.max(size.y, gc.getFontMetrics().getHeight());
        }
        gc.dispose();
        return size;
    }

    private String getMaxLengthString() {
        String maxLengthString = STR_EMPTY;
        for (String str : this.itemList) {
            if (maxLengthString.length() >= str.length()) continue;
            maxLengthString = str;
        }
        return maxLengthString;
    }

    private void updateScrollbarBound() {
        Point pSize = this.getTextSize(this.getMaxLengthString());
        this.maxContentLenght = pSize.x + 10;
        this.contentHeight = pSize.y;
        if (this.isVScrollStyle()) {
            if (this.getClientArea().height < this.getItemHeight() * this.getItemCount()) {
                this.vScrollbar.setVisible(true);
            } else {
                this.vScrollbar.setVisible(false);
            }
            this.vScrollbar.setMinimum(0);
            this.vScrollbar.setMaximum(this.itemList.size());
            this.vScrollbar.setThumb(this.getClientArea().height / this.getItemHeight());
            this.vScrollbar.setSelection(this.vScrollbarSelection);
        }
        if (this.isHScrollStyle()) {
            if (this.getClientArea().width < this.maxContentLenght) {
                this.hScrollbar.setVisible(true);
            } else {
                this.hScrollbar.setVisible(false);
            }
            this.hScrollbar.setMinimum(0);
            this.hScrollbar.setMaximum(this.maxContentLenght);
            this.hScrollbar.setThumb(this.getClientArea().width);
        }
        this.updateCellList();
        this.redraw(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width, this.getClientArea().height, false);
    }

    private void updateCellList() {
        this.cellList.clear();
        int height = 0;
        Rectangle rect = this.getClientArea();
        height = this.getItemHeight() == 0 ? rect.height : this.getItemHeight();
        int shellWidth = this.maxContentLenght > rect.width ? this.maxContentLenght : rect.width;
        int i = 0;
        while (i < this.getItemCountOfArea()) {
            Rectangle r = new Rectangle(0, i * height, shellWidth, height);
            this.cellList.add(r);
            ++i;
        }
    }

    private void paint(PaintEvent e) {
        if (this.itemList.size() == 0 || this.getItemCountOfArea() != this.cellList.size()) {
            return;
        }
        if (!this.getEnabled()) {
            e.gc.setAlpha(90);
        }
        if (this.isVScrollStyle()) {
            this.firstIndexOfCurrentArea = this.vScrollbar.getSelection();
        }
        int i = 0;
        while (i < this.getItemCountOfArea()) {
            Rectangle r = this.cellList.get(i);
            int contentIndex = i + this.firstIndexOfCurrentArea;
            if (this.selectionList.indexOf(contentIndex) != -1) {
                this.drawCell(e.gc, r, TizenResourceManager.LIST_ITEM_SELECT_BG_COLOR, TizenResourceManager.LIST_ITEM_SELECT_FONT_COLOR);
            } else if (this.hoverIndex == contentIndex) {
                this.drawCell(e.gc, r, TizenResourceManager.LIST_ITEM_HOVER_BG_COLOR, TizenResourceManager.LIST_ITEM_HOVER_FONT_COLOR);
            } else {
                this.drawCell(e.gc, r, TizenResourceManager.LIST_ITEM_NORMAL_BG_COLOR, TizenResourceManager.LIST_ITEM_NORMAL_FONT_COLOR);
            }
            this.drawText(e.gc, contentIndex, i, r);
            ++i;
        }
    }

    private void drawCell(GC gc, Rectangle r, Color bgColor, Color fontColor) {
        gc.setBackground(bgColor);
        gc.fillRectangle(r);
        gc.setForeground(fontColor);
    }

    private void drawText(GC gc, int contentIndex, int i, Rectangle r) {
        if (contentIndex >= this.getItemCount() || contentIndex < 0) {
            return;
        }
        String content = this.itemList.get(contentIndex);
        if (this.isHScrollStyle()) {
            int shiftTextIndex = this.hScrollbar.getSelection();
            if (shiftTextIndex > 0 && shiftTextIndex < content.length()) {
                content = content.substring(shiftTextIndex);
            } else if (shiftTextIndex >= content.length()) {
                content = STR_EMPTY;
            }
        }
        gc.drawString(content, 5, i * r.height + this.getItemHeight() / 2 - this.contentHeight / 2, true);
    }

    protected int getItemCountOfArea() {
        int listAreaHeight = this.getClientArea().height;
        int correctLength = listAreaHeight % this.getItemHeight();
        return Math.min((listAreaHeight + correctLength) / this.getItemHeight(), this.getItemCount());
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point size = super.computeSize(wHint, hHint, changed);
        if (wHint == -1 && size.x < this.maxContentLenght) {
            size.x = this.maxContentLenght;
        }
        if (hHint == -1 && size.y < this.getClientArea().height) {
            size.y = this.getClientArea().height;
        }
        return size;
    }

    public void add(String item) {
        if (item == null) {
            this.error(4);
            return;
        }
        this.itemList.add(item);
        this.updateScrollbarBound();
    }

    public void add(String string, int index) {
        if (string == null) {
            this.error(4);
            return;
        }
        if (index < 0 || index > this.itemList.size()) {
            this.error(6);
            return;
        }
        this.itemList.add(index, string);
        this.updateScrollbarBound();
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener == null) {
            this.error(4);
            return;
        }
        this.addListener(13, new TypedListener(listener));
        this.addListener(14, new TypedListener(listener));
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (listener == null) {
            this.error(4);
            return;
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public void deselect(int[] indices) {
        if (indices == null) {
            this.error(4);
            return;
        }
        ArrayList<Integer> removeIndexs = new ArrayList<Integer>();
        int i = 0;
        while (i < indices.length) {
            removeIndexs.add(indices[i]);
            ++i;
        }
        this.selectionList.removeAll(removeIndexs);
        this.redraw(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width, this.getClientArea().height, false);
    }

    public void deselect(int ItemIndex) {
        int selectionIndex = this.selectionList.indexOf(ItemIndex);
        if (selectionIndex < 0 || this.selectionList.size() <= selectionIndex) {
            return;
        }
        this.selectionList.remove(selectionIndex);
        this.redraw(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width, this.getClientArea().height, false);
    }

    public void deselect(int start, int end) {
        if (start < 0 && end < 0) {
            return;
        }
        if (start >= this.getItemCount() && end >= this.getItemCount()) {
            return;
        }
        ArrayList<Integer> removeIndexs = new ArrayList<Integer>();
        int i = start;
        while (i <= end) {
            removeIndexs.add(i);
            ++i;
        }
        this.selectionList.removeAll(removeIndexs);
        this.redraw(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width, this.getClientArea().height, false);
    }

    public void deselectAll() {
        this.selectionList.clear();
        this.redraw(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width, this.getClientArea().height, false);
    }

    public int getFocusIndex() {
        return this.selectionIndex;
    }

    public String getItem(int index) {
        if (index < 0 || this.itemList.size() <= index) {
            this.error(6);
            return STR_EMPTY;
        }
        return this.itemList.get(index);
    }

    public int getItemCount() {
        return this.itemList.size();
    }

    public int getItemHeight() {
        return this.contentHeight + 9;
    }

    public String[] getItems() {
        this.checkWidget();
        int size = this.getItemCount();
        String[] result = new String[size];
        int i = 0;
        while (i < size) {
            result[i] = this.getItem(i);
            ++i;
        }
        return result;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] indices = this.getSelectionIndices();
        String[] result = new String[indices.length];
        int i = 0;
        while (i < indices.length) {
            result[i] = this.getItem(indices[i]);
            ++i;
        }
        return result;
    }

    public int getSelectionCount() {
        return this.selectionList.size();
    }

    public int getSelectionIndex() {
        if (this.selectionList.isEmpty()) {
            return -1;
        }
        return this.selectionIndex;
    }

    public int[] getSelectionIndices() {
        int[] returnValue = new int[this.selectionList.size()];
        int i = 0;
        while (i < this.selectionList.size()) {
            returnValue[i] = this.selectionList.get(i);
            ++i;
        }
        Arrays.sort(returnValue);
        return returnValue;
    }

    public int getTopIndex() {
        return this.topIndex;
    }

    public int indexOf(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
            return -1;
        }
        return this.itemList.indexOf(string);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
            return -1;
        }
        String[] items = this.getItems();
        if (start < 0 || start > items.length) {
            return -1;
        }
        int i = start;
        while (i < items.length) {
            if (items[i].equals(string)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isSelected(int index) {
        return this.selectionList.indexOf(index) != -1;
    }

    public void remove(int[] indices) {
        if (indices == null) {
            this.error(4);
            return;
        }
        if (indices.length <= 0) {
            this.error(6);
            return;
        }
        Arrays.sort(indices);
        int start = indices[0];
        int end = indices[indices.length - 1];
        int count = this.getItemCount();
        if (start < 0 || start > end || end >= count) {
            this.error(6);
            return;
        }
        int preDeleteIndex = -1;
        ArrayList<String> removeItemList = new ArrayList<String>();
        int i = 0;
        while (i < indices.length) {
            int deleteIndex = indices[i];
            if (preDeleteIndex != deleteIndex) {
                removeItemList.add(this.itemList.get(indices[i]));
            }
            preDeleteIndex = deleteIndex;
            ++i;
        }
        this.itemList.removeAll(removeItemList);
        this.deselect(indices);
        this.updateScrollbarBound();
    }

    public void remove(int index) {
        if (index < 0 || index >= this.itemList.size()) {
            this.error(6);
            return;
        }
        this.deselect(index);
        this.itemList.remove(index);
        this.updateScrollbarBound();
    }

    public void remove(int start, int end) {
        if (start < 0 || start >= this.itemList.size() || end < 0 || end >= this.itemList.size()) {
            this.error(6);
            return;
        }
        int preDeleteIndex = -1;
        ArrayList<String> removeItemList = new ArrayList<String>();
        int i = start;
        while (i <= end) {
            if (preDeleteIndex != i) {
                removeItemList.add(this.itemList.get(i));
            }
            preDeleteIndex = i++;
        }
        this.deselect(start, end);
        this.itemList.removeAll(removeItemList);
        this.updateScrollbarBound();
    }

    public void remove(String string) {
        if (string == null) {
            this.error(4);
            return;
        }
        int index = this.indexOf(string, 0);
        if (index == -1) {
            this.error(5);
            return;
        }
        this.deselect(index);
        this.remove(index);
        this.updateScrollbarBound();
    }

    public void removeAll() {
        this.selectionIndex = -1;
        this.firstIndexOfCurrentArea = 0;
        this.itemList.clear();
        this.selectionList.clear();
        this.updateScrollbarBound();
    }

    public void select(int index) {
        if (index < 0) {
            return;
        }
        if (index >= this.itemList.size()) {
            return;
        }
        if (this.selectionList.indexOf(index) != -1) {
            return;
        }
        if (!this.isMultiSelectionStyle()) {
            this.deselectAll();
        }
        this.addSelectionIndex(this.selectionList, index);
        this.selectionIndex = index;
        this.redraw(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width, this.getClientArea().height, false);
    }

    public void select(int start, int end) {
        if (end < 0 || start > end || !this.isMultiSelectionStyle() && start != end) {
            return;
        }
        if (this.getItemCount() == 0 || start >= this.getItemCount()) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, this.getItemCount() - 1);
        int i = start;
        while (i <= end) {
            this.select(i);
            ++i;
        }
        if (!this.isFocusControl()) {
            this.setFocus();
        }
        this.redraw(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width, this.getClientArea().height, false);
    }

    public void select(int[] indices) {
        if (indices == null) {
            this.error(4);
            return;
        }
        int length = indices.length;
        if (length == 0 || !this.isMultiSelectionStyle() && length > 1) {
            this.selectionIndex = -1;
            return;
        }
        if (!this.isMultiSelectionStyle()) {
            this.deselectAll();
        }
        if (length > this.itemList.size()) {
            length = this.itemList.size();
        }
        int i = 0;
        while (i < length) {
            int index = indices[i];
            if (index >= this.itemList.size()) {
                index = this.itemList.size() - 1;
            }
            this.select(index);
            ++i;
        }
        if (!this.isFocusControl()) {
            this.setFocus();
        }
        this.redraw(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width, this.getClientArea().height, false);
        this.showSelection();
    }

    public void selectAll() {
        if (!this.isMultiSelectionStyle()) {
            return;
        }
        int i = 0;
        while (i < this.itemList.size()) {
            this.addSelectionIndex(this.selectionList, i);
            ++i;
        }
        if (!this.isFocusControl()) {
            this.setFocus();
        }
        this.selectionIndex = 0;
        this.redraw(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width, this.getClientArea().height, false);
    }

    public void setItem(int index, String string) {
        if (string == null) {
            this.error(4);
            return;
        }
        if (index < 0 || index >= this.getItemCount()) {
            this.error(6);
        }
        this.itemList.set(index, string);
        this.deselectAll();
        this.updateScrollbarBound();
    }

    public void setItems(String[] items) {
        if (items == null) {
            this.error(4);
            return;
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                this.error(5);
                return;
            }
            ++i;
        }
        this.itemList.clear();
        i = 0;
        while (i < items.length) {
            if (this.itemList.size() <= i) {
                this.itemList.add(items[i]);
            } else {
                this.itemList.set(i, items[i]);
            }
            ++i;
        }
        this.deselectAll();
        this.updateScrollbarBound();
    }

    public void setSelection(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
            return;
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || !this.isMultiSelectionStyle() && length > 1) {
            this.selectionIndex = -1;
            return;
        }
        boolean first = true;
        int i = 0;
        while (i < length) {
            int index = 0;
            String string = items[i];
            if (string != null) {
                while ((index = this.indexOf(string, index)) != -1) {
                    if (!this.isMultiSelectionStyle()) {
                        this.selectionIndex = index;
                        this.select(index);
                        break;
                    }
                    if (first) {
                        first = false;
                        this.selectionIndex = index;
                        this.select(index);
                    } else if (this.selectionList.indexOf(index) == -1) {
                        this.addSelectionIndex(this.selectionList, index);
                    }
                    ++index;
                }
            }
            ++i;
        }
    }

    public void setSelection(int[] indices) {
        if (indices == null) {
            this.error(4);
            return;
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || !this.isMultiSelectionStyle() && length > 1) {
            return;
        }
        int i = 0;
        while (i < length) {
            int selection = indices[i];
            if (selection < this.itemList.size()) {
                this.select(selection);
                this.selectionIndex = selection;
            }
            ++i;
        }
        this.showSelection();
    }

    public void setSelection(int index) {
        this.selectionIndex = index;
        this.deselectAll();
        if (index < 0 || this.itemList.size() <= index) {
            this.selectionIndex = -1;
        } else {
            this.addSelectionIndex(this.selectionList, this.selectionIndex);
        }
        this.showSelection();
        this.redraw(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width, this.getClientArea().height, false);
    }

    public void setSelection(int start, int end) {
        this.deselectAll();
        if (end < 0 || start > end || !this.isMultiSelectionStyle() && start != end) {
            return;
        }
        if (this.getItemCount() == 0 || start >= this.getItemCount()) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, this.getItemCount() - 1);
        if ((this.originalStyle & 2) != 0) {
            this.select(start, end);
        } else {
            this.select(start);
        }
        this.selectionIndex = start;
        this.showSelection();
    }

    public void setTopIndex(int index) {
        this.topIndex = index = Math.min(this.itemList.size(), Math.max(0, index));
        this.setSelection(index);
    }

    public void showSelection() {
        int index = this.getSelectionIndex();
        if (index == -1) {
            return;
        }
        if (this.vScrollbar != null) {
            this.vScrollbar.setSelection(index);
            this.vScrollbarSelection = this.vScrollbar.getSelection();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.redraw(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width, this.getClientArea().height, false);
    }

    private void addSelectionIndex(List<Integer> selectionList, int index) {
        if (selectionList.indexOf(index) == -1) {
            selectionList.add(index);
        }
    }
}

