/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.TizenResourceManager;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class TizenProgressBar
extends Canvas {
    static final int SLEEP = 30;
    static final int DEFAULT_WIDTH = 160;
    static final int DEFAULT_HEIGHT = 18;
    private boolean active = false;
    private int value = 0;
    private int orientation = 256;
    private boolean showBorder = false;
    private boolean isIndeterminateStyle = false;
    private int minimum = 0;
    private int maximum = 100;
    private int selection = -1;
    private Thread animationThread = null;

    public TizenProgressBar(Composite parent, int style) {
        super(parent, TizenProgressBar.checkStyle(style | 0x20000000));
        if ((style & 0x200) != 0) {
            this.orientation = 512;
        }
        boolean bl = this.showBorder = (style & 0x800) != 0;
        if ((style & 2) != 0) {
            this.isIndeterminateStyle = true;
        }
        this.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TizenProgressBar.this.redraw();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TizenProgressBar.this.paint(e);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TizenProgressBar.this.stop();
            }
        });
        this.animationThread = new Thread(new AnimationThread(parent.getDisplay(), this));
        this.animationThread.start();
    }

    private static int checkStyle(int style) {
        int mask = 0x20000000;
        return style & mask;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = null;
        size = this.orientation == 256 ? new Point(160, 18) : new Point(18, 160);
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        return size;
    }

    private void drawBevelRect(GC gc, int x, int y, int w, int h, Color topleft, Color bottomright) {
        gc.setForeground(topleft);
        gc.drawLine(x, y, x + w - 1, y);
        gc.drawLine(x, y, x, y + h - 1);
        gc.setForeground(bottomright);
        gc.drawLine(x + w, y, x + w, y + h);
        gc.drawLine(x, y + h, x + w, y + h);
    }

    private void paint(PaintEvent event) {
        GC gc = event.gc;
        Display disp = this.getDisplay();
        Rectangle rect = this.getClientArea();
        gc.fillRectangle(rect);
        if (this.showBorder) {
            this.drawBevelRect(gc, rect.x, rect.y, rect.width - 1, rect.height - 1, disp.getSystemColor(18), disp.getSystemColor(20));
        }
        this.paintStripes(gc);
    }

    protected void paintStripes(GC gc) {
        Rectangle rect = this.getClientArea();
        if (this.orientation == 256) {
            rect = new Rectangle(rect.x, rect.y, this.getProgressWidth(), rect.height);
            gc.setClipping(rect.x, rect.y, this.getProgressWidth(), rect.height);
        } else {
            rect = new Rectangle(rect.x, rect.y, rect.width, this.getProgressHeight());
            gc.setClipping(rect.x, rect.y, rect.width, this.getProgressHeight());
        }
        gc.setAdvanced(true);
        gc.setAntialias(1);
        int lineWidth = 12;
        gc.setLineWidth(lineWidth);
        gc.setBackground(TizenResourceManager.PROGRESS_BAR_BG_COLOR);
        gc.fillRectangle(rect);
        gc.setForeground(TizenResourceManager.PROGRESS_BAR_LINE_COLOR);
        if (this.isIndeterminateStyle) {
            int foregroundValue;
            int step = 12 + lineWidth;
            int n = foregroundValue = this.value == 0 ? step - 2 : this.value - 2;
            if (this.orientation == 256) {
                int y = rect.y - lineWidth;
                int w = rect.width;
                int h = rect.height + lineWidth;
                int i = 0;
                while (i < w) {
                    int x = i + foregroundValue;
                    gc.drawLine(x, y, x + lineWidth, h);
                    i += step;
                }
            } else {
                int x = rect.x - lineWidth;
                int w = rect.width + lineWidth;
                int h = rect.height;
                int i = 0;
                while (i < h) {
                    int y = i + foregroundValue;
                    gc.drawLine(x, y, w, y + lineWidth);
                    i += step;
                }
            }
            if (this.active) {
                this.value = (this.value + 2) % step;
            }
        }
    }

    public synchronized void stop() {
        this.checkWidget();
        this.active = false;
    }

    public synchronized void clear() {
        this.checkWidget();
        if (this.active) {
            this.stop();
        }
        this.redraw();
    }

    private int getProgressWidth() {
        Rectangle rect = this.getClientArea();
        if (this.selection == -1) {
            return rect.width;
        }
        double currentSelectionPercent = (double)this.selection / (double)this.maximum * 100.0;
        return (int)((double)rect.width / 100.0 * currentSelectionPercent);
    }

    public void setSelection(int value) {
        this.selection = Math.max(this.minimum, Math.min(this.maximum, value));
        this.redraw();
    }

    public void setMaximum(int value) {
        if (value <= this.minimum) {
            return;
        }
        this.maximum = value;
        this.selection = Math.min(this.selection, this.maximum);
    }

    public void setMinimum(int value) {
        if (value < 0 || value >= this.maximum) {
            return;
        }
        this.minimum = value;
        this.selection = Math.max(this.selection, this.minimum);
    }

    public int getSelection() {
        return this.selection;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setState(int state) {
        this.checkWidget();
    }

    public int getState() {
        this.checkWidget();
        return 0;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.active = visible;
        if (this.active && this.animationThread == null) {
            this.animationThread = new Thread(new AnimationThread(this.getParent().getDisplay(), this));
            this.animationThread.start();
        }
    }

    private int getProgressHeight() {
        Rectangle rect = this.getClientArea();
        double currentSelectionPercent = (double)this.selection / (double)this.maximum * 100.0;
        return (int)((double)rect.height / 100.0 * currentSelectionPercent);
    }

    class AnimationThread
    extends Thread {
        private Display display;
        private TizenProgressBar progressBar;

        public AnimationThread(Display display, TizenProgressBar progressBar) {
            this.display = display;
            this.progressBar = progressBar;
            TizenProgressBar.this.active = true;
        }

        public void run() {
            while (TizenProgressBar.this.active) {
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (this.display.isDisposed()) {
                    return;
                }
                this.display.asyncExec(new Runnable(){

                    public void run() {
                        if (AnimationThread.this.progressBar.isDisposed()) {
                            return;
                        }
                        AnimationThread.this.progressBar.redraw();
                    }
                });
            }
            TizenProgressBar.this.animationThread = null;
        }
    }
}

