/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TizenResourceManager {
    private static TizenResourceManager instance;
    public static final Color GRAY_COLOR;
    public static final Color WHITE_COLOR;
    public static final Color BLACK_COLOR;
    public static final Color BLUE_COLOR;
    public static final Color LINE_NORMAL;
    public static final Color LINE_SELECT;
    public static final Color PROGRESS_BAR_BG_COLOR;
    public static final Color PROGRESS_BAR_LINE_COLOR;
    public static final Color RADIO_BUTTON_NORMAL_FONT_COLOR;
    public static final Color RADIO_BUTTON_SELECT_COLOR;
    public static final Color RADIO_BUTTON_DISABLE_FONT_COLOR;
    public static final Color PUSH_BUTTON_NORMAL_FONT_COLOR;
    public static final Color PUSH_BUTTON_HOVER_FONT_COLOR;
    public static final Color PUSH_BUTTON_PRESSED_FONT_COLOR;
    public static final Color PUSH_BUTTON_DIMMED_FONT_COLOR;
    public static final Color PUSH_BUTTON_DEFAULT_FONT_COLOR;
    public static final Color PUSH_BUTTON_NORMAL_BG_COLOR;
    public static final Color PUSH_BUTTON_HOVER_BG_COLOR;
    public static final Color PUSH_BUTTON_PRESSED_BG_COLOR;
    public static final Color PUSH_BUTTON_DIMMED_BG_COLOR;
    public static final Color PUSH_BUTTON_OUTLINE_NORMAL_COLOR;
    public static final Color PUSH_BUTTON_OUTLINE_HOVER_COLOR;
    public static final Color PUSH_BUTTON_OUTLINE_PRESSED_COLOR;
    public static final Color PUSH_BUTTON_OUTLINE_DIMMED_COLOR;
    public static final Color PUSH_BUTTON_OUTLINE_DEFAULT_COLOR;
    public static final Color PUSH_BUTTON_FOCUSED_LIEN_COLOR;
    public static final Color ARROW_BUTTON_NORMAL_COLOR;
    public static final Color ARROW_BUTTON_PUSH_COLOR;
    public static final Color ARROW_BUTTON_HOVER_COLOR;
    public static final Color ARROW_BUTTON_DISABLE_COLOR;
    public static final Color COMBO_LINE_EDITABLE_COLOR;
    public static final Color COMBO_LINE_NORMAL_COLOR;
    public static final Color COMBO_LINE_HOVER_COLOR;
    public static final Color COMBO_LINE_DIMMED_COLOR;
    public static final Color COMBO_LINE_UNFOLD_COLOR;
    public static final Color COMBO_BG_EDITABLE_COLOR;
    public static final Color COMBO_BG_NORMAL_COLOR;
    public static final Color COMBO_BG_HOVER_COLOR;
    public static final Color COMBO_BG_DIMMED_COLOR;
    public static final Color COMBO_BG_UNFOLD_COLOR;
    public static final Color COMBO_FONT_EDITABLE_COLOR;
    public static final Color COMBO_FONT_NORMAL_COLOR;
    public static final Color COMBO_FONT_HOVER_COLOR;
    public static final Color COMBO_FONT_DIMMED_COLOR;
    public static final Color COMBO_FONT_UNFOLD_COLOR;
    public static final Color TEXT_LINE_NORAML_COLOR;
    public static final Color TEXT_LINE_HOVER_COLOR;
    public static final Color TEXT_LINE_EDITING_COLOR;
    public static final Color TEXT_LINE_DIMMED_COLOR;
    public static final Color TEXT_BG_NORMAL_COLOR;
    public static final Color TEXT_BG_HOVER_COLOR;
    public static final Color TEXT_BG_EDITING_COLOR;
    public static final Color TEXT_BG_DIMMED_COLOR;
    public static final Color TEXT_FONT_NORMAL_COLOR;
    public static final Color TEXT_FONT_HOVER_COLOR;
    public static final Color TEXT_FONT_EDITING_COLOR;
    public static final Color TEXT_FONT_DIMMED_COLOR;
    public static final Color LIST_ITEM_NORMAL_BG_COLOR;
    public static final Color LIST_ITEM_HOVER_BG_COLOR;
    public static final Color LIST_ITEM_SELECT_BG_COLOR;
    public static final Color LIST_ITEM_NORMAL_FONT_COLOR;
    public static final Color LIST_ITEM_HOVER_FONT_COLOR;
    public static final Color LIST_ITEM_SELECT_FONT_COLOR;
    public static final Color CTABFOLDER_DARKGRAY_1_COLOR;
    public static final Color CTABFOLDER_DARKGRAY_2_COLOR;
    public static String DEFAULT_FONT_NAME;
    public static Font NORMAL_FONT;
    static final ClassLoader loader;
    public Image checkBoxSelected = TizenResourceManager.getImageSafely("images/check_sel.png");
    public Image checkBoxSelectedHover = TizenResourceManager.getImageSafely("images/check_sel_hover.png");
    public Image checkBoxSelectedDisable = TizenResourceManager.getImageSafely("images/check_sel_disable.png");
    public Image checkBoxSelectedFocused = TizenResourceManager.getImageSafely("images/check_sel_focused.png");
    public Image checkBoxNormal = TizenResourceManager.getImageSafely("images/check_nor.png");
    public Image checkBoxNormalHover = TizenResourceManager.getImageSafely("images/check_nor_hover.png");
    public Image checkBoxNormalDisable = TizenResourceManager.getImageSafely("images/check_nor_disable.png");
    public Image checkBoxNormalFocused = TizenResourceManager.getImageSafely("images/check_nor_focused.png");
    public Image checkBoxGrayed = TizenResourceManager.getImageSafely("images/check_gray.png");
    public Image checkBoxGrayedHover = TizenResourceManager.getImageSafely("images/check_gray_hover.png");
    public Image checkBoxGrayedDisable = TizenResourceManager.getImageSafely("images/check_gray_disable.png");
    public Image checkBoxGrayedFocused = TizenResourceManager.getImageSafely("images/check_gray_focused.png");
    public Image radioSelected = TizenResourceManager.getImageSafely("images/radio_sel.png");
    public Image radioSelectedHover = TizenResourceManager.getImageSafely("images/radio_sel_hover.png");
    public Image radioSelectedDisable = TizenResourceManager.getImageSafely("images/radio_sel_disable.png");
    public Image radioSelectedFocused = TizenResourceManager.getImageSafely("images/radio_sel_focused.png");
    public Image radioNormalHover = TizenResourceManager.getImageSafely("images/radio_nor_hover.png");
    public Image radioNormal = TizenResourceManager.getImageSafely("images/radio_nor.png");
    public Image radioNormalDisable = TizenResourceManager.getImageSafely("images/radio_nor_disable.png");
    public Image radioNormalFocused = TizenResourceManager.getImageSafely("images/radio_nor_focused.png");

    static {
        GRAY_COLOR = TizenResourceManager.getColorSafely(177, 177, 177);
        WHITE_COLOR = TizenResourceManager.getColorSafely(255, 255, 255);
        BLACK_COLOR = TizenResourceManager.getColorSafely(0, 0, 0);
        BLUE_COLOR = TizenResourceManager.getColorSafely(0, 0, 255);
        LINE_NORMAL = TizenResourceManager.getColorSafely(170, 170, 170);
        LINE_SELECT = TizenResourceManager.getColorSafely(0, 150, 221);
        PROGRESS_BAR_BG_COLOR = TizenResourceManager.getColorSafely(0, 138, 238);
        PROGRESS_BAR_LINE_COLOR = TizenResourceManager.getColorSafely(0, 90, 238);
        RADIO_BUTTON_NORMAL_FONT_COLOR = TizenResourceManager.getColorSafely(88, 88, 88);
        RADIO_BUTTON_SELECT_COLOR = TizenResourceManager.getColorSafely(88, 88, 88);
        RADIO_BUTTON_DISABLE_FONT_COLOR = TizenResourceManager.getColorSafely(153, 153, 153);
        PUSH_BUTTON_NORMAL_FONT_COLOR = TizenResourceManager.getColorSafely(51, 51, 51);
        PUSH_BUTTON_HOVER_FONT_COLOR = TizenResourceManager.getColorSafely(51, 51, 51);
        PUSH_BUTTON_PRESSED_FONT_COLOR = TizenResourceManager.getColorSafely(255, 255, 255);
        PUSH_BUTTON_DIMMED_FONT_COLOR = TizenResourceManager.getColorSafely(153, 153, 153);
        PUSH_BUTTON_DEFAULT_FONT_COLOR = TizenResourceManager.getColorSafely(0, 150, 200);
        PUSH_BUTTON_NORMAL_BG_COLOR = TizenResourceManager.getColorSafely(225, 225, 225);
        PUSH_BUTTON_HOVER_BG_COLOR = TizenResourceManager.getColorSafely(205, 233, 255);
        PUSH_BUTTON_PRESSED_BG_COLOR = TizenResourceManager.getColorSafely(0, 138, 238);
        PUSH_BUTTON_DIMMED_BG_COLOR = TizenResourceManager.getColorSafely(204, 204, 204);
        PUSH_BUTTON_OUTLINE_NORMAL_COLOR = TizenResourceManager.getColorSafely(177, 177, 177);
        PUSH_BUTTON_OUTLINE_HOVER_COLOR = TizenResourceManager.getColorSafely(0, 138, 238);
        PUSH_BUTTON_OUTLINE_PRESSED_COLOR = TizenResourceManager.getColorSafely(0, 138, 238);
        PUSH_BUTTON_OUTLINE_DIMMED_COLOR = TizenResourceManager.getColorSafely(191, 191, 191);
        PUSH_BUTTON_OUTLINE_DEFAULT_COLOR = TizenResourceManager.getColorSafely(0, 138, 238);
        PUSH_BUTTON_FOCUSED_LIEN_COLOR = TizenResourceManager.getColorSafely(153, 153, 153);
        ARROW_BUTTON_NORMAL_COLOR = TizenResourceManager.getColorSafely(240, 240, 240);
        ARROW_BUTTON_PUSH_COLOR = TizenResourceManager.getColorSafely(163, 163, 163);
        ARROW_BUTTON_HOVER_COLOR = TizenResourceManager.getColorSafely(240, 240, 240);
        ARROW_BUTTON_DISABLE_COLOR = TizenResourceManager.getColorSafely(170, 170, 170);
        COMBO_LINE_EDITABLE_COLOR = TizenResourceManager.getColorSafely(0, 138, 238);
        COMBO_LINE_NORMAL_COLOR = TizenResourceManager.getColorSafely(170, 170, 170);
        COMBO_LINE_HOVER_COLOR = TizenResourceManager.getColorSafely(0, 138, 238);
        COMBO_LINE_DIMMED_COLOR = TizenResourceManager.getColorSafely(170, 170, 170);
        COMBO_LINE_UNFOLD_COLOR = TizenResourceManager.getColorSafely(0, 138, 238);
        COMBO_BG_EDITABLE_COLOR = TizenResourceManager.getColorSafely(255, 255, 255);
        COMBO_BG_NORMAL_COLOR = TizenResourceManager.getColorSafely(245, 245, 245);
        COMBO_BG_HOVER_COLOR = TizenResourceManager.getColorSafely(245, 245, 245);
        COMBO_BG_DIMMED_COLOR = TizenResourceManager.getColorSafely(245, 245, 245);
        COMBO_BG_UNFOLD_COLOR = TizenResourceManager.getColorSafely(245, 245, 245);
        COMBO_FONT_EDITABLE_COLOR = TizenResourceManager.getColorSafely(70, 70, 70);
        COMBO_FONT_NORMAL_COLOR = TizenResourceManager.getColorSafely(70, 70, 70);
        COMBO_FONT_HOVER_COLOR = TizenResourceManager.getColorSafely(70, 70, 70);
        COMBO_FONT_DIMMED_COLOR = TizenResourceManager.getColorSafely(70, 70, 70);
        COMBO_FONT_UNFOLD_COLOR = TizenResourceManager.getColorSafely(0, 138, 238);
        TEXT_LINE_NORAML_COLOR = TizenResourceManager.getColorSafely(170, 170, 170);
        TEXT_LINE_HOVER_COLOR = TizenResourceManager.getColorSafely(0, 138, 238);
        TEXT_LINE_EDITING_COLOR = TizenResourceManager.getColorSafely(0, 138, 238);
        TEXT_LINE_DIMMED_COLOR = TizenResourceManager.getColorSafely(170, 170, 170);
        TEXT_BG_NORMAL_COLOR = TizenResourceManager.getColorSafely(255, 255, 255);
        TEXT_BG_HOVER_COLOR = TizenResourceManager.getColorSafely(255, 255, 255);
        TEXT_BG_EDITING_COLOR = TizenResourceManager.getColorSafely(255, 255, 255);
        TEXT_BG_DIMMED_COLOR = TizenResourceManager.getColorSafely(245, 245, 245);
        TEXT_FONT_NORMAL_COLOR = TizenResourceManager.getColorSafely(88, 88, 88);
        TEXT_FONT_HOVER_COLOR = TizenResourceManager.getColorSafely(88, 88, 88);
        TEXT_FONT_EDITING_COLOR = TizenResourceManager.getColorSafely(88, 88, 88);
        TEXT_FONT_DIMMED_COLOR = TizenResourceManager.getColorSafely(153, 153, 153);
        LIST_ITEM_NORMAL_BG_COLOR = TizenResourceManager.getColorSafely(255, 255, 255);
        LIST_ITEM_HOVER_BG_COLOR = TizenResourceManager.getColorSafely(205, 233, 255);
        LIST_ITEM_SELECT_BG_COLOR = TizenResourceManager.getColorSafely(0, 138, 238);
        LIST_ITEM_NORMAL_FONT_COLOR = TizenResourceManager.getColorSafely(70, 70, 70);
        LIST_ITEM_HOVER_FONT_COLOR = TizenResourceManager.getColorSafely(70, 70, 70);
        LIST_ITEM_SELECT_FONT_COLOR = TizenResourceManager.getColorSafely(255, 255, 255);
        CTABFOLDER_DARKGRAY_1_COLOR = TizenResourceManager.getColorSafely(102, 102, 102);
        CTABFOLDER_DARKGRAY_2_COLOR = TizenResourceManager.getColorSafely(119, 119, 119);
        DEFAULT_FONT_NAME = Display.getCurrent().getSystemFont().getFontData()[0].getName();
        NORMAL_FONT = TizenResourceManager.getDefaultFontSafely();
        loader = TizenResourceManager.class.getClassLoader();
    }

    public static TizenResourceManager getInstance() {
        if (instance == null) {
            instance = new TizenResourceManager();
        }
        return instance;
    }

    public static Image getImageSafely(String file) {
        final Image img = new Image((Device)Display.getCurrent(), TizenResourceManager.class.getResourceAsStream(file));
        Display display = Display.getCurrent();
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (!img.isDisposed()) {
                    img.dispose();
                }
            }
        });
        return img;
    }

    public static Color getColorSafely(int r, int g, int b) {
        Display display = Display.getCurrent();
        final Color color = new Color(display, r, g, b);
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (!color.isDisposed()) {
                    color.dispose();
                }
            }
        });
        return color;
    }

    public static Font getFontSafely(String fontName, int size) {
        final Font font = new Font((Device)Display.getCurrent(), fontName, size, 0);
        Display.getCurrent().addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (!font.isDisposed()) {
                    font.dispose();
                }
            }
        });
        return font;
    }

    public static Font getDefaultFontSafely() {
        int nSize = 11;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("win")) {
            nSize = 9;
        }
        final Font font = new Font((Device)Display.getCurrent(), DEFAULT_FONT_NAME, nSize, 0);
        Display.getCurrent().addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (!font.isDisposed()) {
                    font.dispose();
                }
            }
        });
        return font;
    }
}

