/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.progress.AnimationItem;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressRegion;
import org.eclipse.ui.internal.progress.StatusAdapterHelper;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.IProgressConstants2;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class ProgressAnimationItem
extends AnimationItem
implements FinishedJobs.KeptJobsListener {
    MouseListener mouseListener;
    Composite top;
    ToolBar toolbar;
    ToolItem toolButton;
    ProgressRegion progressRegion;
    Image noneImage;
    Image okImage;
    Image errorImage;
    ArrayList<Image> progressImages = new ArrayList();
    boolean animationRunning;
    private int flags;
    private AccessibleListener currentAccessibleListener;

    ProgressAnimationItem(ProgressRegion region, int flags) {
        super(region.workbenchWindow);
        this.flags = flags;
        FinishedJobs.getInstance().addListener(this);
        this.progressRegion = region;
        this.mouseListener = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ProgressAnimationItem.this.doAction();
            }
        };
    }

    void doAction() {
        JobTreeElement[] jobTreeElements = FinishedJobs.getInstance().getKeptElements();
        int i = jobTreeElements.length - 1;
        while (i >= 0) {
            JobInfo ji;
            Job job;
            if (jobTreeElements[i] instanceof JobInfo && (job = (ji = (JobInfo)jobTreeElements[i]).getJob()) != null) {
                IStatus status = job.getResult();
                if (status != null && status.getSeverity() == 4) {
                    StatusAdapter statusAdapter = StatusAdapterHelper.getInstance().getStatusAdapter(ji);
                    if (statusAdapter == null) {
                        statusAdapter = new StatusAdapter(status);
                    }
                    StatusManager.getManager().handle(statusAdapter, 2);
                    this.removeTopElement(ji);
                }
                if (this.execute(ji, job)) {
                    return;
                }
            }
            --i;
        }
        this.progressRegion.processDoubleClick();
        this.refresh();
    }

    private boolean execute(JobInfo ji, Job job) {
        Object prop = job.getProperty(IProgressConstants.ACTION_PROPERTY);
        if (prop instanceof IAction && ((IAction)prop).isEnabled()) {
            IAction action = (IAction)prop;
            action.run();
            this.removeTopElement(ji);
            return true;
        }
        prop = job.getProperty(IProgressConstants2.COMMAND_PROPERTY);
        if (prop instanceof ParameterizedCommand) {
            ParameterizedCommand command = (ParameterizedCommand)prop;
            WorkbenchWindow window = this.getWindow();
            IHandlerService service = (IHandlerService)window.getService(IHandlerService.class);
            Throwable exception = null;
            try {
                service.executeCommand(command, null);
                this.removeTopElement(ji);
            }
            catch (ExecutionException e) {
                exception = e;
            }
            catch (NotDefinedException e) {
                exception = e;
            }
            catch (NotEnabledException e) {
                exception = e;
            }
            catch (NotHandledException e) {
                exception = e;
            }
            if (exception != null) {
                Status status = new Status(4, "org.eclipse.ui", exception.getMessage(), exception);
                StatusManager.getManager().handle((IStatus)status, 3);
            }
            return true;
        }
        return false;
    }

    private void removeTopElement(JobInfo ji) {
        JobTreeElement topElement = (JobTreeElement)ji.getParent();
        if (topElement == null) {
            topElement = ji;
        }
        FinishedJobs.getInstance().remove(topElement);
    }

    private IAction getAction(Job job) {
        Object property = job.getProperty(IProgressConstants.ACTION_PROPERTY);
        if (property instanceof IAction) {
            return (IAction)property;
        }
        return null;
    }

    private void refresh() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        if (this.toolbar == null || this.toolbar.isDisposed()) {
            return;
        }
        JobTreeElement[] jobTreeElements = FinishedJobs.getInstance().getKeptElements();
        int i = jobTreeElements.length - 1;
        while (i >= 0) {
            JobInfo ji;
            Job job;
            if (jobTreeElements[i] instanceof JobInfo && (job = (ji = (JobInfo)jobTreeElements[i]).getJob()) != null) {
                IStatus status = job.getResult();
                if (status != null && status.getSeverity() == 4) {
                    this.initButton(this.errorImage, NLS.bind((String)ProgressMessages.ProgressAnimationItem_error, (Object)job.getName()));
                    return;
                }
                IAction action = this.getAction(job);
                if (action != null && action.isEnabled()) {
                    String tt = action.getToolTipText();
                    if (tt == null || tt.trim().length() == 0) {
                        tt = NLS.bind((String)ProgressMessages.ProgressAnimationItem_ok, (Object)job.getName());
                    }
                    this.initButton(this.okImage, tt);
                    return;
                }
                this.initButton(this.noneImage, ProgressMessages.ProgressAnimationItem_tasks);
                return;
            }
            --i;
        }
        if (this.animationRunning) {
            this.initButton(this.noneImage, ProgressMessages.ProgressAnimationItem_tasks);
            return;
        }
        this.toolbar.setVisible(false);
    }

    private void initButton(Image im, final String tt) {
        this.toolButton.setImage(im);
        this.toolButton.setToolTipText(tt);
        this.toolbar.setVisible(true);
        this.toolbar.getParent().layout();
        if (this.currentAccessibleListener != null) {
            this.toolbar.getAccessible().removeAccessibleListener(this.currentAccessibleListener);
        }
        this.currentAccessibleListener = new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = tt;
            }
        };
        this.toolbar.getAccessible().addAccessibleListener(this.currentAccessibleListener);
    }

    public void updateProgressImage(int percent) {
        if ((percent = (percent + 9) / 10) < 0 || 10 < percent) {
            percent = 0;
        }
        this.toolButton.setImage(this.progressImages.get(percent));
    }

    @Override
    protected Control createAnimationItem(Composite parent) {
        if (this.okImage == null) {
            Display display = parent.getDisplay();
            this.noneImage = WorkbenchImages.getWorkbenchImageDescriptor("progress20/progress_none.png").createImage((Device)display);
            this.progressImages.add(0, this.noneImage);
            this.progressImages.add(1, WorkbenchImages.getWorkbenchImageDescriptor("progress20/progress_10.png").createImage((Device)display));
            this.progressImages.add(2, WorkbenchImages.getWorkbenchImageDescriptor("progress20/progress_20.png").createImage((Device)display));
            this.progressImages.add(3, WorkbenchImages.getWorkbenchImageDescriptor("progress20/progress_30.png").createImage((Device)display));
            this.progressImages.add(4, WorkbenchImages.getWorkbenchImageDescriptor("progress20/progress_40.png").createImage((Device)display));
            this.progressImages.add(5, WorkbenchImages.getWorkbenchImageDescriptor("progress20/progress_50.png").createImage((Device)display));
            this.progressImages.add(6, WorkbenchImages.getWorkbenchImageDescriptor("progress20/progress_60.png").createImage((Device)display));
            this.progressImages.add(7, WorkbenchImages.getWorkbenchImageDescriptor("progress20/progress_70.png").createImage((Device)display));
            this.progressImages.add(8, WorkbenchImages.getWorkbenchImageDescriptor("progress20/progress_80.png").createImage((Device)display));
            this.progressImages.add(9, WorkbenchImages.getWorkbenchImageDescriptor("progress20/progress_90.png").createImage((Device)display));
            this.progressImages.add(10, WorkbenchImages.getWorkbenchImageDescriptor("progress20/progress_100.png").createImage((Device)display));
            this.okImage = WorkbenchImages.getWorkbenchImageDescriptor("progress/progress_ok.png").createImage((Device)display);
            this.errorImage = WorkbenchImages.getWorkbenchImageDescriptor("progress/progress_error.png").createImage((Device)display);
        }
        this.top = new Composite(parent, 0);
        this.top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FinishedJobs.getInstance().removeListener(ProgressAnimationItem.this);
                ProgressAnimationItem.this.noneImage.dispose();
                ProgressAnimationItem.this.okImage.dispose();
                ProgressAnimationItem.this.errorImage.dispose();
                if (ProgressAnimationItem.this.progressImages != null) {
                    for (Image progressImage : ProgressAnimationItem.this.progressImages) {
                        progressImage.dispose();
                    }
                }
            }
        });
        boolean isCarbon = Util.isMac();
        GridLayout gl = new GridLayout();
        if (this.isHorizontal()) {
            gl.numColumns = isCarbon ? 3 : 2;
        }
        gl.marginHeight = Util.isWindows() || Util.isMac() ? 7 : 3;
        gl.marginWidth = 0;
        if (this.isHorizontal()) {
            gl.horizontalSpacing = 2;
        } else {
            gl.verticalSpacing = 2;
        }
        this.top.setLayout((Layout)gl);
        this.toolbar = new ToolBar(this.top, 0x800000);
        this.toolbar.setVisible(false);
        this.toolButton = new ToolItem(this.toolbar, 0);
        this.toolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressAnimationItem.this.doAction();
            }
        });
        if (isCarbon) {
            new Label(this.top, 0).setLayoutData((Object)new GridData(4, 4));
        }
        this.refresh();
        return this.top;
    }

    private boolean isHorizontal() {
        return (this.flags & 0x100) != 0;
    }

    @Override
    public Control getControl() {
        return this.top;
    }

    @Override
    void animationDone() {
        super.animationDone();
        this.animationRunning = false;
        this.refresh();
    }

    public boolean animationRunning() {
        return this.animationRunning;
    }

    @Override
    void animationStart() {
        super.animationStart();
        this.animationRunning = true;
        this.refresh();
    }

    @Override
    public void removed(JobTreeElement info) {
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ProgressAnimationItem.this.refresh();
            }
        });
    }

    @Override
    public void finished(JobTreeElement jte) {
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ProgressAnimationItem.this.refresh();
            }
        });
    }
}

