/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables.details;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.variables.details.DefaultDetailPaneFactory;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.debug.ui.IDetailPaneFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.osgi.service.prefs.BackingStoreException;

public class DetailPaneManager {
    private static DetailPaneManager fgSingleton;
    private Map<String, IDetailPaneFactory> fFactoriesByPaneID = new HashMap<String, IDetailPaneFactory>();
    private Map<Set<String>, String> fPreferredDetailPanes;
    private List<DetailPaneFactoryExtension> fKnownFactories;
    public static final String PREF_DETAIL_AREAS = "preferredDetailPanes";

    private DetailPaneManager() {
        this.fFactoriesByPaneID.put("org.eclipse.debug.ui.detailpanes.message", new DefaultDetailPaneFactory());
    }

    public static DetailPaneManager getDefault() {
        if (fgSingleton == null) {
            fgSingleton = new DetailPaneManager();
        }
        return fgSingleton;
    }

    public String getPreferredPaneFromSelection(IStructuredSelection selection) {
        List<IDetailPaneFactory> possibleFactories = this.getEnabledFactories(selection);
        Set<String> possiblePaneIDs = this.getPossiblePaneIDs(possibleFactories, selection);
        return this.chooseDetailsAreaIDInSet(possiblePaneIDs, possibleFactories, selection);
    }

    public Set<String> getAvailablePaneIDs(IStructuredSelection selection) {
        List<IDetailPaneFactory> possibleFactories = this.getEnabledFactories(selection);
        return this.getPossiblePaneIDs(possibleFactories, selection);
    }

    public IDetailPane getDetailPaneFromID(String ID) {
        IDetailPaneFactory factory = this.fFactoriesByPaneID.get(ID);
        if (factory != null) {
            return factory.createDetailPane(ID);
        }
        return null;
    }

    public String getNameFromID(String ID) {
        IDetailPaneFactory factory = this.fFactoriesByPaneID.get(ID);
        if (factory != null) {
            return factory.getDetailPaneName(ID);
        }
        return null;
    }

    public String getDescriptionFromID(String ID) {
        IDetailPaneFactory factory = this.fFactoriesByPaneID.get(ID);
        if (factory != null) {
            return factory.getDetailPaneDescription(ID);
        }
        return null;
    }

    private List<IDetailPaneFactory> getEnabledFactories(IStructuredSelection selection) {
        ArrayList<IDetailPaneFactory> factoriesForSelection = new ArrayList<IDetailPaneFactory>();
        if (this.fKnownFactories == null) {
            this.initializeDetailFactories();
        }
        for (IDetailPaneFactory iDetailPaneFactory : this.fKnownFactories) {
            if (!(iDetailPaneFactory instanceof DetailPaneFactoryExtension) || !((DetailPaneFactoryExtension)iDetailPaneFactory).isEnabled(selection)) continue;
            factoriesForSelection.add(iDetailPaneFactory);
        }
        return factoriesForSelection;
    }

    private Set<String> getPossiblePaneIDs(List<IDetailPaneFactory> factoriesToQuery, IStructuredSelection selection) {
        LinkedHashSet<String> idsForSelection = new LinkedHashSet<String>();
        for (IDetailPaneFactory currentFactory : factoriesToQuery) {
            for (String currentAreaTypeID : currentFactory.getDetailPaneTypes(selection)) {
                this.fFactoriesByPaneID.put(currentAreaTypeID, currentFactory);
                idsForSelection.add(currentAreaTypeID);
            }
        }
        return idsForSelection;
    }

    private String chooseDetailsAreaIDInSet(Set<String> possiblePaneIDs, List<IDetailPaneFactory> enabledFactories, IStructuredSelection selection) {
        if (possiblePaneIDs == null || possiblePaneIDs.isEmpty()) {
            return null;
        }
        String preferredID = this.getUserPreferredDetailPane(possiblePaneIDs);
        if (preferredID == null) {
            for (IDetailPaneFactory currentFactory : enabledFactories) {
                preferredID = currentFactory.getDefaultDetailPane(selection);
                if (preferredID != null) break;
            }
            if (preferredID == null) {
                Iterator<String> paneIterator = possiblePaneIDs.iterator();
                preferredID = paneIterator.next();
                while (paneIterator.hasNext() && preferredID != DefaultDetailPaneFactory.DEFAULT_DETAIL_PANE_ID) {
                    String currentID = paneIterator.next();
                    if (!currentID.equals(DefaultDetailPaneFactory.DEFAULT_DETAIL_PANE_ID)) continue;
                    preferredID = currentID;
                }
            }
            this.setPreferredDetailPane(possiblePaneIDs, preferredID);
        }
        return preferredID;
    }

    private synchronized void initializeDetailFactories() {
        if (this.fKnownFactories == null) {
            this.fKnownFactories = new ArrayList<DetailPaneFactoryExtension>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "detailPaneFactories");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            DetailPaneFactoryExtension delegate = null;
            int i = 0;
            while (i < infos.length) {
                delegate = new DetailPaneFactoryExtension(infos[i]);
                this.fKnownFactories.add(delegate);
                ++i;
            }
        }
    }

    public String getUserPreferredDetailPane(Set<String> possibleDetailsAreaIDs) {
        if (this.fPreferredDetailPanes == null) {
            this.loadPreferredDetailsAreas();
        }
        return this.fPreferredDetailPanes.get(possibleDetailsAreaIDs);
    }

    public void setPreferredDetailPane(Set<String> possibleDetailsAreaIDs, String preferredDetailsAreaID) {
        String currentKey;
        if (possibleDetailsAreaIDs == null) {
            return;
        }
        if (this.fPreferredDetailPanes == null) {
            this.loadPreferredDetailsAreas();
        }
        if ((currentKey = this.fPreferredDetailPanes.get(possibleDetailsAreaIDs)) == null || !currentKey.equals(preferredDetailsAreaID)) {
            this.fPreferredDetailPanes.put(possibleDetailsAreaIDs, preferredDetailsAreaID);
            this.storePreferredDetailsAreas();
        }
    }

    private void storePreferredDetailsAreas() {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<Set<String>, String> entry : this.fPreferredDetailPanes.entrySet()) {
            for (String currentID : entry.getKey()) {
                buffer.append(currentID);
                buffer.append(',');
            }
            buffer.deleteCharAt(buffer.length() - 1);
            buffer.append(':');
            buffer.append(entry.getValue());
            buffer.append('|');
        }
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(DebugUIPlugin.getUniqueIdentifier());
        if (node != null) {
            node.put(PREF_DETAIL_AREAS, buffer.toString());
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                DebugUIPlugin.log(e);
            }
        }
    }

    private void loadPreferredDetailsAreas() {
        this.fPreferredDetailPanes = new HashMap<Set<String>, String>();
        String preferenceValue = Platform.getPreferencesService().getString(DebugUIPlugin.getUniqueIdentifier(), PREF_DETAIL_AREAS, "", null);
        StringTokenizer entryTokenizer = new StringTokenizer(preferenceValue, "|");
        while (entryTokenizer.hasMoreTokens()) {
            String token = entryTokenizer.nextToken();
            int valueStart = token.indexOf(58);
            StringTokenizer keyTokenizer = new StringTokenizer(token.substring(0, valueStart), ",");
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            while (keyTokenizer.hasMoreTokens()) {
                keys.add(keyTokenizer.nextToken());
            }
            this.fPreferredDetailPanes.put(keys, token.substring(valueStart + 1));
        }
    }

    private class DetailPaneFactoryExtension
    implements IDetailPaneFactory {
        private IConfigurationElement fConfigElement;
        private IDetailPaneFactory fFactory;
        private Expression fEnablementExpression;

        public DetailPaneFactoryExtension(IConfigurationElement configElement) {
            this.fConfigElement = configElement;
        }

        @Override
        public IDetailPane createDetailPane(String paneID) {
            if (this.getFactory() != null) {
                return this.getFactory().createDetailPane(paneID);
            }
            return null;
        }

        @Override
        public Set<String> getDetailPaneTypes(IStructuredSelection selection) {
            if (this.getFactory() != null) {
                return this.getFactory().getDetailPaneTypes(selection);
            }
            return Collections.EMPTY_SET;
        }

        @Override
        public String getDefaultDetailPane(IStructuredSelection selection) {
            if (this.getFactory() != null) {
                return this.getFactory().getDefaultDetailPane(selection);
            }
            return null;
        }

        @Override
        public String getDetailPaneName(String paneID) {
            if (this.getFactory() != null) {
                return this.getFactory().getDetailPaneName(paneID);
            }
            return null;
        }

        @Override
        public String getDetailPaneDescription(String paneID) {
            if (this.getFactory() != null) {
                return this.getFactory().getDetailPaneDescription(paneID);
            }
            return null;
        }

        private IDetailPaneFactory getFactory() {
            if (this.fFactory != null) {
                return this.fFactory;
            }
            try {
                Object obj = this.fConfigElement.createExecutableExtension("class");
                if (!(obj instanceof IDetailPaneFactory)) {
                    throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, "org.eclipse.debug.ui.detailFactories extension failed to load a detail factory because the specified class does not implement org.eclipse.debug.ui.IDetailPaneFactory.  Class specified was: " + obj, null));
                }
                this.fFactory = (IDetailPaneFactory)obj;
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e.getStatus());
                this.fFactory = null;
            }
            return this.fFactory;
        }

        public boolean isEnabled(IStructuredSelection selection) {
            boolean enabled = false;
            if (selection == null || selection.isEmpty()) {
                return "org.eclipse.debug.ui.defaultDetailPaneFactory".equals(this.fConfigElement.getAttribute("id"));
            }
            Expression expression = this.getEnablementExpression();
            if (expression != null) {
                List list = selection.toList();
                IEvaluationContext context = DebugUIPlugin.createEvaluationContext(list);
                context.addVariable("selection", (Object)list);
                enabled = this.evalEnablementExpression(context, expression);
            } else {
                enabled = true;
            }
            return enabled;
        }

        private boolean evalEnablementExpression(IEvaluationContext context, Expression exp) {
            try {
                EvaluationResult result;
                if (exp != null && ((result = exp.evaluate(context)) == EvaluationResult.TRUE || result == EvaluationResult.NOT_LOADED)) {
                    return true;
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e.getStatus());
            }
            return false;
        }

        private Expression getEnablementExpression() {
            if (this.fEnablementExpression == null) {
                try {
                    IConfigurationElement enablement;
                    IConfigurationElement[] elements = this.fConfigElement.getChildren("enablement");
                    IConfigurationElement iConfigurationElement = enablement = elements.length > 0 ? elements[0] : null;
                    if (enablement != null) {
                        this.fEnablementExpression = ExpressionConverter.getDefault().perform(enablement);
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e.getStatus());
                    this.fEnablementExpression = null;
                }
            }
            return this.fEnablementExpression;
        }
    }
}

