/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.ui.dialog.Messages;
import org.tizen.common.sign.util.SigningProfileUtil;
import org.tizen.common.ui.font.TizenFonts;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.StringUtil;

public class ProfileMigrationDialog
extends Dialog {
    private Label lDescription;
    private Text textProfilePath;
    private String profilePath;
    private boolean doNotAskAgain = !SigningProfileUtil.getShowMigrationOnStartup();
    private static final Logger logger = LoggerFactory.getLogger(ProfileMigrationDialog.class);

    public ProfileMigrationDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.PROFILE_MIGRATE_DLG_TITLE);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Point getInitialSize() {
        return new Point(576, 353);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        ProfileMigrationDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.createTitleArea(composite);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        return composite;
    }

    public void setDescription(String description) {
        this.lDescription.setText(description);
    }

    private Control createTitleArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 20;
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 80;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)layoutData);
        composite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.lDescription = new Label(composite, 0);
        layoutData = new GridData(772);
        layoutData.grabExcessVerticalSpace = true;
        this.lDescription.setLayoutData((Object)layoutData);
        this.lDescription.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.setDescription(Messages.PROFILE_MIGRATE_DLG_DESC);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 30;
        layout.marginWidth = 30;
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createPathComposite(composite);
        this.askAgainComposite(composite);
        return composite;
    }

    private void createPathComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 4;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label lCertPath = new Label(composite, 0);
        lCertPath.setFont(TizenFonts.getBoldFont());
        lCertPath.setText(Messages.PROFILE_MIGRATE_DLG_FILEPATH);
        GridData labelLayout = new GridData(769);
        labelLayout.horizontalSpan = 2;
        lCertPath.setLayoutData((Object)labelLayout);
        this.textProfilePath = new Text(composite, 2048);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 24;
        layoutData.verticalIndent = 11;
        this.textProfilePath.setLayoutData((Object)layoutData);
        this.textProfilePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ProfileMigrationDialog.this.validate();
            }
        });
        Button btBrowse = new Button(composite, 8);
        layoutData = new GridData();
        layoutData.verticalIndent = 11;
        btBrowse.setLayoutData((Object)layoutData);
        btBrowse.setText(Messages.CERT_EDIT_DLG_BROWSE);
        btBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FileDialog dlg = new FileDialog(ProfileMigrationDialog.this.getShell(), 4096);
                dlg.setFilterExtensions(new String[]{"*.xml"});
                String filepath = dlg.open();
                if (!StringUtil.isEmpty((CharSequence)filepath)) {
                    ProfileMigrationDialog.this.textProfilePath.setText(filepath);
                }
            }
        });
        Label lpathError = this.createErrorLabel(composite);
        layoutData = new GridData();
        lpathError.setLayoutData((Object)layoutData);
        this.textProfilePath.setData("label", (Object)lpathError);
    }

    private void askAgainComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Button btAskAgain = new Button(composite, 32);
        GridData layoutData = new GridData(768);
        layoutData = new GridData();
        layoutData.verticalIndent = 11;
        btAskAgain.setLayoutData((Object)layoutData);
        btAskAgain.setText(Messages.PROFILE_MIGRATE_DLG_ASK_AGAIN);
        btAskAgain.setSelection(this.doNotAskAgain);
        btAskAgain.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileMigrationDialog.this.doNotAskAgain = ((Button)e.widget).getSelection();
            }
        });
    }

    private Label createErrorLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setFont(TizenFonts.getSmallFont());
        label.setForeground(this.getShell().getDisplay().getSystemColor(3));
        return label;
    }

    private void setErrorLabel(String message) {
        Label label = (Label)this.textProfilePath.getData("label");
        label.setText(message);
        label.getParent().layout();
    }

    public String getCertPath() {
        return this.profilePath;
    }

    public boolean getDoNotAskAgain() {
        return this.doNotAskAgain;
    }

    protected void okPressed() {
        this.profilePath = this.textProfilePath.getText();
        super.okPressed();
    }

    protected void validate() {
        boolean validPath = false;
        if (!this.textProfilePath.getText().isEmpty()) {
            if (FileUtil.isExist((String)this.textProfilePath.getText())) {
                this.setErrorLabel("");
                validPath = true;
            } else {
                this.setErrorLabel(Messages.CERT_PATH_ERROR);
                validPath = false;
            }
        } else {
            this.setErrorLabel("");
            validPath = false;
        }
        this.getButton(0).setEnabled(validPath);
    }
}

