/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.util.IOUtil;

public class SigningProfileUtil {
    protected static final Logger logger;
    protected static final String PROFILES_FILE = "profiles.xml";
    protected static final String CONFIG_FILE = "config";
    private static final String SHOW_MIGRATION_ON_STARTUP = "Show migration on startup";
    private static final String AUTHOR = "author";
    private static final String KEYSTORE_DIRECTORY = "keystore";
    private static final String PROFILE_DIRECTORY = "profile";
    protected static SigningProfileContainer container;
    private static IPath profilePath;
    public static final String KEYSTORE_CUSTOM_PATH_MAGIC_STR = "/keystore:";
    public static final String PROFILER_CUSTOM_PATH_MAGIC_STR = "/profiles:";
    public static final String USERDATA_CUSTOM_PATH_MAGIC_STR = "/userdata:";
    private static String keyStoreCustomPath;
    private static String profileCustomPath;
    private static boolean isExistProfileFolder;
    private static String userdataCustomPath;

    static {
        String[] args;
        logger = LoggerFactory.getLogger(SigningProfileUtil.class);
        container = null;
        profilePath = null;
        keyStoreCustomPath = null;
        profileCustomPath = null;
        isExistProfileFolder = false;
        userdataCustomPath = null;
        String[] stringArray = args = Platform.getCommandLineArgs();
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.contains(KEYSTORE_CUSTOM_PATH_MAGIC_STR) && arg.split(KEYSTORE_CUSTOM_PATH_MAGIC_STR).length == 2) {
                keyStoreCustomPath = arg.split(KEYSTORE_CUSTOM_PATH_MAGIC_STR)[1];
            }
            if (arg.contains(PROFILER_CUSTOM_PATH_MAGIC_STR) && arg.split(PROFILER_CUSTOM_PATH_MAGIC_STR).length == 2) {
                profileCustomPath = arg.split(PROFILER_CUSTOM_PATH_MAGIC_STR)[1];
            }
            if (arg.contains(USERDATA_CUSTOM_PATH_MAGIC_STR) && arg.split(USERDATA_CUSTOM_PATH_MAGIC_STR).length == 2) {
                userdataCustomPath = arg.split(USERDATA_CUSTOM_PATH_MAGIC_STR)[1];
            }
            ++n2;
        }
    }

    public static SigningProfileContainer getProfileContainerFromFile() {
        container = new SigningProfileContainer();
        IPath profilesPath = SigningProfileUtil.getProfilesPath();
        InputStream inputStream = null;
        try {
            inputStream = SigningProfileUtil.openFileStream(profilesPath.toFile());
            if (inputStream != null) {
                container.readProfileXML(inputStream);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{inputStream});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{inputStream});
        return container;
    }

    public static SigningProfileContainer getProfileContainerFromFile(String filePath) {
        SigningProfileContainer newContainer = new SigningProfileContainer();
        InputStream inputStream = null;
        try {
            inputStream = SigningProfileUtil.openFileStream(new Path(filePath).toFile());
            if (inputStream != null) {
                newContainer.readProfileXML(inputStream);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{inputStream});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{inputStream});
        return newContainer;
    }

    public static InputStream openFileStream(File file) {
        try {
            if (file.exists()) {
                return new FileInputStream(file);
            }
        }
        catch (IllegalStateException e) {
            logger.error("Can't access state location", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error("Can't open profile", (Throwable)e);
        }
        return null;
    }

    public static String getActiveProfileName() {
        return container.getActiveProfileName();
    }

    public static void setActiveProfileName(String profileName) {
        if (profileName == null) {
            profileName = "";
        }
        container.setActiveProfile(profileName);
        SigningProfileUtil.writeProfilesToFile();
    }

    public static String getUserDataPath() {
        if (userdataCustomPath != null) {
            return userdataCustomPath;
        }
        String sdkDataPath = null;
        try {
            sdkDataPath = InstallPathConfig.getUserDataPath();
        }
        catch (Exception e) {
            logger.error("Can't read Sdk User Data Path", (Throwable)e);
        }
        return sdkDataPath;
    }

    public static IPath getProfilesPath() {
        if (profileCustomPath != null && profileCustomPath.contains("xml")) {
            if (!isExistProfileFolder) {
                File profileFile = new File(profileCustomPath);
                if (!profileFile.exists()) {
                    File profileParentFolder = new File(profileFile.getParent());
                    profileParentFolder.mkdirs();
                    IOUtil.tryClose((Object[])new Object[]{profileParentFolder});
                }
                IOUtil.tryClose((Object[])new Object[]{profileFile});
                isExistProfileFolder = true;
            }
            return new Path(profileCustomPath);
        }
        if (profilePath != null) {
            return profilePath;
        }
        String profileFolder = null;
        profileFolder = userdataCustomPath == null ? new Path(SigningProfileUtil.getUserDataPath()).append(PROFILE_DIRECTORY).toString() : new Path(userdataCustomPath).append(PROFILE_DIRECTORY).toString();
        File profileFile = new File(profileFolder);
        if (!profileFile.exists()) {
            profileFile.mkdirs();
        }
        profilePath = new Path(profileFolder).append(PROFILES_FILE);
        IOUtil.tryClose((Object[])new Object[]{profileFile});
        return profilePath;
    }

    public static boolean writeProfilesToFile() {
        IPath profilesPath = SigningProfileUtil.getProfilesPath();
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(profilesPath.toFile());
            container.writeProfileXML(outputStream);
        }
        catch (FileNotFoundException e) {
            try {
                logger.error("Can't write a profile", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{outputStream});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{outputStream});
            return false;
        }
        IOUtil.tryClose((Object[])new Object[]{outputStream});
        return true;
    }

    public static boolean writeProfilesToFile(SigningProfileContainer profileContainer) {
        container = profileContainer;
        return SigningProfileUtil.writeProfilesToFile();
    }

    public static IPath getCertStorePath() {
        if (keyStoreCustomPath == null) {
            return new Path(SigningProfileUtil.getUserDataPath()).append(KEYSTORE_DIRECTORY);
        }
        return new Path(keyStoreCustomPath).append(KEYSTORE_DIRECTORY);
    }

    public static IPath getAuthorCertStorePath() {
        return SigningProfileUtil.getCertStorePath().append(AUTHOR);
    }

    public static IPath getConfigPath() {
        return new Path(SigningProfileUtil.getUserDataPath()).append(PROFILE_DIRECTORY).append(CONFIG_FILE);
    }

    /*
     * Exception decompiling
     */
    public static boolean getShowMigrationOnStartup() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void setShowMigrationOnStartup(boolean show) {
        block7: {
            File configFile = SigningProfileUtil.getConfigPath().toFile();
            FileWriter fileWriter = null;
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    fileWriter = new FileWriter(configFile);
                    bufferedWriter = new BufferedWriter(fileWriter);
                    bufferedWriter.write("Show migration on startup=");
                    if (show) {
                        bufferedWriter.write("1");
                    } else {
                        bufferedWriter.write("0");
                    }
                    bufferedWriter.flush();
                }
                catch (IOException iOException) {
                    logger.error("Writing config file failed.");
                    IOUtil.tryClose((Object[])new Object[]{bufferedWriter, fileWriter});
                    break block7;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{bufferedWriter, fileWriter});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{bufferedWriter, fileWriter});
        }
    }
}

