/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.internal.ProductProperties;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.about.AboutBundleGroupData;
import org.eclipse.ui.internal.about.AboutFeaturesButtonManager;
import org.eclipse.ui.internal.about.AboutItem;
import org.eclipse.ui.internal.about.AboutTextManager;
import org.eclipse.ui.internal.about.InstallationDialog;
import org.eclipse.ui.internal.dialogs.AboutFeaturesDialog;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;

public class AboutDialog
extends TrayDialog {
    private static final int MAX_IMAGE_WIDTH_FOR_TEXT = 250;
    private static final int DETAILS_ID = 1025;
    private String productName;
    private IProduct product;
    private AboutBundleGroupData[] bundleGroupInfos;
    private ArrayList<Image> images = new ArrayList();
    private AboutFeaturesButtonManager buttonManager = new AboutFeaturesButtonManager();
    private StyledText text;
    private AboutTextManager aboutTextManager;
    private String releaseNoteName;
    private final String releaseNoteNameKey = "RELEASE_NOTE_NAME";
    private final String releaseNoteUrlKey = "RELEASE_NOTE_URL";
    private String releaseNoteUrl;
    private static final RGB LINK_FOREGROUND = new RGB(0, 138, 238);
    private static Color linkColor;

    public AboutDialog(Shell parentShell) {
        super(parentShell);
        File file;
        this.product = Platform.getProduct();
        if (this.product != null) {
            this.productName = this.product.getName();
        }
        if (this.productName == null) {
            this.productName = WorkbenchMessages.AboutDialog_defaultProductName;
        }
        String sdkPath = null;
        if ("macosx".equals(Platform.getOS())) {
            file = new File(Platform.getInstallLocation().getURL().getPath());
            sdkPath = file.getParentFile().getParentFile().getParentFile().getAbsolutePath();
        } else {
            file = new File(Platform.getInstallLocation().getURL().getPath());
            sdkPath = file.getParentFile().getAbsolutePath();
        }
        sdkPath = String.valueOf(sdkPath) + File.separatorChar + "sdk.version";
        linkColor = new Color((Device)parentShell.getDisplay(), LINK_FOREGROUND);
        TreeMap<String, String> info = this.getVersionInfo(sdkPath);
        this.releaseNoteName = info.get("RELEASE_NOTE_NAME");
        this.releaseNoteUrl = info.get("RELEASE_NOTE_URL");
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        LinkedList<AboutBundleGroupData> groups = new LinkedList<AboutBundleGroupData>();
        if (providers != null) {
            IBundleGroupProvider[] iBundleGroupProviderArray = providers;
            int n = providers.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleGroup[] bundleGroups;
                IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
                IBundleGroup[] iBundleGroupArray = bundleGroups = provider.getBundleGroups();
                int n3 = bundleGroups.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBundleGroup bundleGroup = iBundleGroupArray[n4];
                    groups.add(new AboutBundleGroupData(bundleGroup));
                    ++n4;
                }
                ++n2;
            }
        }
        this.bundleGroupInfos = groups.toArray(new AboutBundleGroupData[0]);
    }

    private TreeMap<String, String> getVersionInfo(String file) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        try {
            String line;
            BufferedReader bfr = new BufferedReader(new FileReader(new File(file)));
            while ((line = bfr.readLine()) != null) {
                if (line.startsWith("#") || line.isEmpty()) continue;
                String[] pair = line.trim().split("=");
                map.put(pair[0].trim(), pair[1].trim());
            }
            bfr.close();
        }
        catch (Exception exception) {}
        return map;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        InstallationDialog dialog = new InstallationDialog(AboutDialog.this.getShell(), workbenchWindow);
                        dialog.setModalParent((Dialog)AboutDialog.this);
                        dialog.open();
                    }
                });
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    public boolean close() {
        int i = 0;
        while (i < this.images.size()) {
            Image image = this.images.get(i);
            image.dispose();
            ++i;
        }
        if (!linkColor.isDisposed()) {
            linkColor.dispose();
        }
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NLS.bind((String)WorkbenchMessages.AboutDialog_shellTitle, (Object)this.productName));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.ui.about_dialog_context");
    }

    protected void createButtonsForButtonBar(final Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        this.createButton(parent, 1025, WorkbenchMessages.AboutDialog_DetailsButton, false);
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        Color background = JFaceColors.getBannerBackground((Display)parent.getDisplay());
        parent.setBackground(background);
        l.setBackground(background);
        parent.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(new Color((Device)e.display, 88, 88, 88));
                e.gc.drawLine(0, 1, parent.getClientArea().width, 1);
            }
        });
        Button b = this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
        b.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        Image aboutImage = null;
        AboutItem item = null;
        if (this.product != null) {
            String aboutText;
            ImageDescriptor imageDescriptor = ProductProperties.getAboutImage(this.product);
            if (imageDescriptor != null) {
                aboutImage = imageDescriptor.createImage();
            }
            if ((aboutImage == null || aboutImage.getBounds().width <= 250) && (aboutText = ProductProperties.getAboutText(this.product)) != null) {
                item = AboutTextManager.scan(aboutText);
            }
            if (aboutImage != null) {
                this.images.add(aboutImage);
            }
        }
        Composite workArea = new Composite(parent, 0);
        GridLayout workLayout = new GridLayout();
        workLayout.marginHeight = 0;
        workLayout.marginWidth = 0;
        workLayout.verticalSpacing = 0;
        workLayout.horizontalSpacing = 0;
        workArea.setLayout((Layout)workLayout);
        workArea.setLayoutData((Object)new GridData(1808));
        Color background = JFaceColors.getBannerBackground((Display)parent.getDisplay());
        Color foreground = JFaceColors.getBannerForeground((Display)parent.getDisplay());
        Composite top = (Composite)super.createDialogArea(workArea);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(1808));
        top.setBackground(background);
        top.setForeground(foreground);
        Composite topContainer = new Composite(top, 0);
        topContainer.setBackground(background);
        topContainer.setForeground(foreground);
        layout = new GridLayout();
        layout.numColumns = aboutImage == null || item == null ? 1 : 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        topContainer.setLayout((Layout)layout);
        GC gc = new GC((Drawable)parent);
        int topContainerHeightHint = 100;
        try {
            topContainerHeightHint = Math.max(topContainerHeightHint, gc.getFontMetrics().getHeight() * 6);
        }
        finally {
            gc.dispose();
        }
        if (aboutImage != null) {
            final Canvas imageLabel = new Canvas(topContainer, 0);
            imageLabel.setBackground(background);
            imageLabel.setForeground(foreground);
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            data.grabExcessHorizontalSpace = false;
            data.widthHint = 430;
            data.heightHint = 90;
            data.horizontalSpan = 2;
            imageLabel.setLayoutData((Object)data);
            imageLabel.setBackgroundImage(aboutImage);
            topContainerHeightHint = aboutImage.getBounds().height;
            int productNameHeightHint = 32;
            final int fontSizeHeight = topContainerHeightHint - productNameHeightHint * 2;
            imageLabel.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent event) {
                    String fontName = "BreezeSans";
                    Font font = new Font((Device)event.display, fontName, fontSizeHeight, 1);
                    event.gc.setForeground(event.display.getSystemColor(1));
                    event.gc.setFont(font);
                    Point textSize = event.gc.textExtent(AboutDialog.this.productName);
                    event.gc.drawText(AboutDialog.this.productName, 28, (imageLabel.getSize().y - textSize.y) / 2, true);
                    font.dispose();
                }
            });
        }
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 28;
        layout.marginHeight = 22;
        layout.verticalSpacing = 17;
        layout.horizontalSpacing = 47;
        GridData data = new GridData(1808);
        Composite scroller = new Composite(topContainer, 0);
        scroller.setLayout((Layout)layout);
        scroller.setBackground(background);
        scroller.setLayoutData((Object)data);
        scroller.setFont(parent.getFont());
        scroller.setForeground(foreground);
        String aboutText = ProductProperties.getAboutText(this.product);
        StringTokenizer st = new StringTokenizer(aboutText, "\n");
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            int index = str.indexOf(":");
            if (index == -1) continue;
            String key = str.substring(0, index);
            String value = str.substring(index + 1);
            if (value == null || value.isEmpty()) continue;
            Label label = new Label(scroller, 0);
            GridData gd = new GridData(256);
            FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
            Font boldFont = boldDescriptor.createFont((Device)label.getDisplay());
            label.setFont(boldFont);
            label.setText(key);
            label.setBackground(background);
            gd.widthHint = 104;
            label.setLayoutData((Object)gd);
            if (value.startsWith("http")) {
                gd = new GridData(256);
                gd.widthHint = 198;
                final Hyperlink link = new Hyperlink(scroller, 64);
                link.setLayoutData((Object)gd);
                link.setBackground(background);
                link.setText(value);
                link.setHref((Object)value);
                link.setForeground(linkColor);
                link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        try {
                            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(link.getHref().toString()));
                        }
                        catch (Exception exception) {}
                    }
                });
                continue;
            }
            label = new Label(scroller, 0);
            Pattern p = Pattern.compile("^\\d\\d\\d\\d.\\d\\d.\\d\\d.\\d\\d.\\d\\d$");
            Matcher match = p.matcher(value);
            if (match.matches()) {
                String yyyy = value.substring(0, 4);
                String mm = value.substring(5, 7);
                String dd = value.substring(8, 10);
                String hh = value.substring(11, 13);
                String mm2 = value.substring(14, 16);
                value = String.format("%s-%s-%s %s:%s", yyyy, mm, dd, hh, mm2);
            }
            label.setText(value);
            label.setBackground(background);
        }
        if (this.releaseNoteName != null && this.releaseNoteUrl != null) {
            Label label = new Label(scroller, 0);
            FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
            Font boldFont = boldDescriptor.createFont((Device)label.getDisplay());
            label.setFont(boldFont);
            label.setText("Release Note");
            label.setBackground(background);
            GridData gd = new GridData(256);
            gd.widthHint = 198;
            final Hyperlink link = new Hyperlink(scroller, 64);
            link.setLayoutData((Object)gd);
            link.setBackground(background);
            link.setText(this.releaseNoteName);
            link.setHref((Object)this.releaseNoteUrl);
            link.setForeground(linkColor);
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(link.getHref().toString()));
                    }
                    catch (Exception exception) {}
                }
            });
        }
        return workArea;
    }

    private void createTextMenu() {
        final MenuManager textManager = new MenuManager();
        textManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter(PlatformUI.getWorkbench(), null, "org.eclipse.ui.edit.copy", 8)));
        textManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter(PlatformUI.getWorkbench(), null, "org.eclipse.ui.edit.selectAll", 8)));
        this.text.setMenu(textManager.createContextMenu((Control)this.text));
        this.text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                textManager.dispose();
            }
        });
    }

    private void createFeatureImageButtonRow(Composite parent) {
        Composite featureContainer = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = true;
        featureContainer.setLayout((Layout)rowLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        featureContainer.setLayoutData((Object)data);
        AboutBundleGroupData[] aboutBundleGroupDataArray = this.bundleGroupInfos;
        int n = this.bundleGroupInfos.length;
        int n2 = 0;
        while (n2 < n) {
            AboutBundleGroupData bundleGroupInfo = aboutBundleGroupDataArray[n2];
            this.createFeatureButton(featureContainer, bundleGroupInfo);
            ++n2;
        }
    }

    private Button createFeatureButton(Composite parent, final AboutBundleGroupData info) {
        if (!this.buttonManager.add(info)) {
            return null;
        }
        ImageDescriptor desc = info.getFeatureImage();
        Image featureImage = null;
        Button button = new Button(parent, 0x800008);
        button.setData((Object)info);
        featureImage = desc.createImage();
        this.images.add(featureImage);
        button.setImage(featureImage);
        button.setToolTipText(info.getProviderName());
        button.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = info.getProviderName();
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AboutBundleGroupData[] groupInfos = AboutDialog.this.buttonManager.getRelatedInfos(info);
                AboutBundleGroupData selection = (AboutBundleGroupData)event.widget.getData();
                AboutFeaturesDialog d = new AboutFeaturesDialog(AboutDialog.this.getShell(), AboutDialog.this.productName, groupInfos, selection);
                d.open();
            }
        });
        return button;
    }

    protected boolean isResizable() {
        return false;
    }
}

