/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;

public class CTabItem
extends Item {
    CTabFolder parent;
    int x;
    int y;
    int width;
    int height = 0;
    Control control;
    String toolTipText;
    String shortenedText;
    int shortenedTextWidth;
    Font font;
    Image disabledImage;
    Image selectedTabImage;
    boolean narrow = false;
    Rectangle closeRect = new Rectangle(0, 0, 0, 0);
    int closeImageState = 8;
    int state = 0;
    boolean showClose = false;
    boolean showing = false;

    public CTabItem(CTabFolder parent, int style) {
        this(parent, style, parent.getItemCount());
    }

    public CTabItem(CTabFolder parent, int style, int index) {
        super(parent, style);
        this.showClose = (style & 0x40) != 0;
        parent.createItem(this, index);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.parent.destroyItem(this);
        super.dispose();
        this.parent = null;
        this.control = null;
        this.toolTipText = null;
        this.shortenedText = null;
        this.font = null;
    }

    public Image getSelectedTabImage() {
        return this.selectedTabImage;
    }

    public void setSelectedTabImage(Image image) {
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        this.selectedTabImage = image;
    }

    public void setNarrow(boolean narrow) {
        if (narrow && this.getImage() != null) {
            this.narrow = true;
            if (this.getToolTipText() == null) {
                this.setToolTipText(this.getText());
            }
        } else {
            this.narrow = false;
            if (this.getToolTipText() != null && this.getToolTipText().equals(this.getText())) {
                this.setToolTipText(null);
            }
        }
    }

    public boolean getNarrow() {
        return this.narrow;
    }

    public Rectangle getBounds() {
        this.parent.runUpdate();
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    @Deprecated
    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public CTabFolder getParent() {
        return this.parent;
    }

    public boolean getShowClose() {
        this.checkWidget();
        return this.showClose;
    }

    public String getToolTipText() {
        String text;
        this.checkWidget();
        if (this.toolTipText == null && this.shortenedText != null && !this.shortenedText.equals(text = this.getText())) {
            return text;
        }
        return this.toolTipText;
    }

    public boolean isShowing() {
        this.checkWidget();
        return this.showing;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                SWT.error(5);
            }
            if (control.getParent() != this.parent) {
                SWT.error(32);
            }
        }
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setVisible(false);
        }
        this.control = control;
        if (this.control != null) {
            int index = this.parent.indexOf(this);
            if (index == this.parent.getSelectionIndex()) {
                this.control.setBounds(this.parent.getClientArea());
                this.control.setVisible(true);
            } else {
                int selectedIndex = this.parent.getSelectionIndex();
                Control selectedControl = null;
                if (selectedIndex != -1) {
                    selectedControl = this.parent.getItem((int)selectedIndex).control;
                }
                if (this.control != selectedControl) {
                    this.control.setVisible(false);
                }
            }
        }
    }

    @Deprecated
    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        this.disabledImage = image;
    }

    boolean setFocus() {
        return this.control != null && !this.control.isDisposed() && this.control.setFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (font == null && this.font == null) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.font = font;
        this.parent.updateFolder(12);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        Image oldImage = this.getImage();
        if (image == null && oldImage == null) {
            return;
        }
        if (image != null && image.equals(oldImage)) {
            return;
        }
        super.setImage(image);
        this.parent.updateFolder(12);
    }

    public void setShowClose(boolean close) {
        this.checkWidget();
        if (this.showClose == close) {
            return;
        }
        this.showClose = close;
        this.parent.updateFolder(4);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.getText())) {
            return;
        }
        super.setText(string);
        this.shortenedText = null;
        this.shortenedTextWidth = 0;
        this.parent.updateFolder(12);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }
}

