/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.ArrayList;
import org.eclipse.swt.custom.TizenAbstractButtonRenderer;
import org.eclipse.swt.custom.TizenArrowButtonRenderer;
import org.eclipse.swt.custom.TizenButtonAttribute;
import org.eclipse.swt.custom.TizenCheckBoxButtonRenderer;
import org.eclipse.swt.custom.TizenPushButtonRenderer;
import org.eclipse.swt.custom.TizenRadioButtonRenderer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TizenButton
extends Canvas {
    protected TizenButtonAttribute attr = new TizenButtonAttribute();
    protected TizenAbstractButtonRenderer buttonRenderer = null;

    public TizenButton(Composite parent, int style) {
        super(parent, TizenButton.checkStyle(style));
        switch (this.getType(style)) {
            case 16: {
                this.buttonRenderer = new TizenRadioButtonRenderer(this, parent);
                break;
            }
            case 32: {
                this.buttonRenderer = new TizenCheckBoxButtonRenderer(this, parent);
                break;
            }
            case 4: {
                this.buttonRenderer = new TizenArrowButtonRenderer(this, parent, style);
                break;
            }
            case 8: {
                this.buttonRenderer = new TizenPushButtonRenderer(this, parent);
                break;
            }
            default: {
                this.buttonRenderer = new TizenPushButtonRenderer(this, parent);
            }
        }
        this.addEventListener(this.buttonRenderer.getMouseListener());
    }

    static int checkStyle(int style) {
        if (((style = TizenButton.checkBits(style, 8, 4, 32, 16, 2)) & 4) != 0) {
            style |= 0x80000;
        }
        return TizenButton.styleFilter(style) | 0x20000000;
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4) {
        int mask = int0 | int1 | int2 | int3 | int4;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        return style;
    }

    static int styleFilter(int style) {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.equals("linux")) {
            return style &= 0xFEFFFFFF;
        }
        return style;
    }

    protected boolean isEqualsType(int style, int cmpStyle) {
        int bits = 62;
        return (style & bits) == cmpStyle;
    }

    protected int getType(int style) {
        int bits = 62;
        return style & bits;
    }

    public void addEventListener(Listener listener) {
        this.addListener(13, listener);
        this.addListener(6, listener);
        this.addListener(7, listener);
        this.addListener(4, listener);
        this.addListener(3, listener);
        this.addListener(9, listener);
        this.addListener(12, listener);
        this.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                switch (e.detail) {
                    case 8: 
                    case 16: {
                        e.doit = true;
                        break;
                    }
                    case 2: {
                        e.doit = true;
                    }
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event e) {
                TizenButton.this.buttonRenderer.setFocusByKeyInput(true);
                TizenButton.this.buttonRenderer.setFocus();
            }
        });
        this.addListener(16, new Listener(){

            public void handleEvent(Event e) {
                TizenButton.this.buttonRenderer.removeFocus();
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (!TizenButton.this.isFocus()) {
                    return;
                }
                switch (event.character) {
                    case ' ': {
                        TizenButton.this.fireEventWhenSpaceKeyPressed();
                        break;
                    }
                    case '\r': {
                        TizenButton.this.fireEventWhenEnterKeyPressed();
                    }
                }
            }
        });
    }

    protected void fireSelectionEvent() {
        if (this.isDisposed()) {
            return;
        }
        Event e = new Event();
        e.item = this;
        e.widget = this;
        e.type = 13;
        this.notifyListeners(13, e);
    }

    private void fireEventWhenEnterKeyPressed() {
        if (this.isActivateDefaultButtonCurrentWindow()) {
            this.fireSelectionEventOfDefaultButton();
        } else {
            this.fireSelectionEvent();
        }
    }

    private void fireEventWhenSpaceKeyPressed() {
        if (this.isEqualsType(this.getStyle(), 8)) {
            this.fireSelectionEvent();
        } else if (this.isEqualsType(this.getStyle(), 32) || this.isEqualsType(this.getStyle(), 16)) {
            this.buttonRenderer.checkTypeButtonPressed();
        }
    }

    protected Widget[] getWidgetList() {
        return null;
    }

    protected ArrayList<Button> getPushButtonInWindow() {
        Widget[] widgetList;
        ArrayList<Button> buttonArray = new ArrayList<Button>();
        Widget[] widgetArray = widgetList = this.getWidgetList();
        int n = widgetList.length;
        int n2 = 0;
        while (n2 < n) {
            Button button;
            Widget widget = widgetArray[n2];
            if (widget instanceof Button && (button = (Button)widget).isEqualsType(button.getStyle(), 8)) {
                buttonArray.add(button);
            }
            ++n2;
        }
        return buttonArray;
    }

    private boolean isActivateDefaultButtonCurrentWindow() {
        ArrayList<Button> buttonList = this.getPushButtonInWindow();
        for (Button button : buttonList) {
            if (!button.isDefaultButton() || !button.isActiveDefaultButton()) continue;
            return true;
        }
        return false;
    }

    private void fireSelectionEventOfDefaultButton() {
        ArrayList<Button> buttonList = this.getPushButtonInWindow();
        for (Button button : buttonList) {
            if (!button.isDefaultButton()) continue;
            button.setFocus();
            button.fireSelectionEvent();
            return;
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener == null) {
            this.error(4);
            return;
        }
        this.addListener(13, new TypedListener(listener));
        this.addListener(14, new TypedListener(listener));
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (listener == null) {
            this.error(4);
            return;
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point computedSize = this.buttonRenderer.computeSize(this, wHint, hHint, changed);
        if (wHint != -1) {
            computedSize.x = wHint;
        }
        if (hHint != -1) {
            computedSize.y = hHint;
        }
        return computedSize;
    }

    protected TizenButtonAttribute getAttribute() {
        return this.attr;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.redraw();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.buttonRenderer.setEnabled(enabled);
    }

    @Override
    public void setBackground(Color color) {
        this.buttonRenderer.setBackground(color);
    }

    @Override
    public Color getBackground() {
        Color bgColor = this.attr.getBackground();
        if (bgColor == null) {
            return super.getBackground();
        }
        return bgColor;
    }

    @Override
    public void setForeground(Color color) {
        this.buttonRenderer.setForeground(color);
    }

    @Override
    public Color getForeground() {
        Color fgColor = this.attr.getForeground();
        if (fgColor == null) {
            return super.getForeground();
        }
        return fgColor;
    }

    public String getText() {
        return this.attr.getText();
    }

    public void setText(String text) {
        if (text == null) {
            this.error(4);
            return;
        }
        if ((this.getStyle() & 4) != 0) {
            return;
        }
        this.attr.setText(text);
    }

    public void setImage(Image image) {
        if (image == null) {
            this.error(4);
            return;
        }
        if ((this.getStyle() & 4) != 0) {
            return;
        }
        this.attr.setImage(image);
        this.redraw();
    }

    public Image getImage() {
        return this.attr.getImage();
    }

    @Override
    public void setBackgroundImage(Image image) {
        if (image == null) {
            this.error(4);
            return;
        }
        this.attr.setImage(image);
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            this.error(4);
            return;
        }
        this.attr.setFont(font);
    }

    public void setAlignment(int align) {
        if ((this.getStyle() & 4) != 0) {
            if ((align & 0x1024480) == 0) {
                align = 128;
            }
            if (align == 0x1000000) {
                align = 128;
            }
        } else if ((align & 0x1024000) == 0) {
            return;
        }
        this.attr.setAlign(align);
    }

    public int getAlignment() {
        return this.attr.getAlign();
    }

    public void setSelection(boolean selected) {
        if ((this.getStyle() & 0x32) == 0) {
            return;
        }
        this.buttonRenderer.setSelection(selected);
    }

    @Override
    public boolean setFocus() {
        if (this.isDisposed()) {
            return false;
        }
        super.setFocus();
        this.buttonRenderer.setFocusByKeyInput(false);
        this.buttonRenderer.setFocus();
        return true;
    }

    public void removeFocus() {
        this.buttonRenderer.removeFocus();
    }

    public boolean isFocus() {
        return this.buttonRenderer.isFocus();
    }

    public boolean getSelection() {
        return this.buttonRenderer.getSelection();
    }

    public void setDefault(boolean b) {
        if (!this.isEqualsType(this.getStyle(), 8)) {
            return;
        }
        this.buttonRenderer.setDefaultButtonListener(b);
    }

    protected boolean isDefaultButton() {
        return this.buttonRenderer.isDefaultButton;
    }

    protected boolean isActiveDefaultButton() {
        return this.buttonRenderer.isActiveDefaultButton();
    }

    public void click() {
    }

    public void setGrayed(boolean grayed) {
        if (!this.isEqualsType(this.getStyle(), 32)) {
            return;
        }
        this.buttonRenderer.setGrayed(grayed);
        this.redraw();
    }

    public boolean getGrayed() {
        return this.buttonRenderer.getGrayed();
    }
}

