/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.TizenAbstractButtonRenderer;
import org.eclipse.swt.custom.TizenButton;
import org.eclipse.swt.custom.TizenResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;

public class TizenRadioButtonRenderer
extends TizenAbstractButtonRenderer {
    protected static final int DISABLE = 1;
    protected static final int SELECT = 2;
    protected static final int ENABLE = 4;
    protected static final int FOCUS = 8;
    protected static final int HOVER = 16;
    protected static final int GRAYED = 32;
    protected int state = 4;

    TizenRadioButtonRenderer(TizenButton parent, Composite parentComposite) {
        super(parent, parentComposite);
        if (parentComposite instanceof Group) {
            this.setEnabled(parentComposite.getEnabled());
        }
    }

    protected boolean isState(int style, int cmpStyle) {
        return (style & cmpStyle) == cmpStyle;
    }

    public Listener getMouseListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 6: 
                    case 32: {
                        TizenRadioButtonRenderer.this.drawMouseHover();
                        break;
                    }
                    case 7: {
                        TizenRadioButtonRenderer.this.drawMouseExit();
                        break;
                    }
                    case 3: {
                        if (event.button != 3) break;
                        TizenRadioButtonRenderer.this.parent.setFocus();
                        return;
                    }
                    case 4: {
                        if (event.button == 3) {
                            return;
                        }
                        TizenRadioButtonRenderer.this.checkTypeButtonPressed();
                        break;
                    }
                    case 9: {
                        TizenRadioButtonRenderer.this.drawButton(event);
                    }
                }
            }
        };
    }

    protected void setBackground(Color color) {
        this.parent.getAttribute().setBackground(color);
    }

    protected void setForeground(Color color) {
        this.parent.getAttribute().setForeground(color);
    }

    private void drawMouseHover() {
        if (!this.isEnable) {
            return;
        }
        this.state |= 0x10;
        this.parent.redraw();
    }

    private void drawMouseExit() {
        if (!this.isEnable) {
            return;
        }
        if (this.isFocus()) {
            this.state |= 8;
        }
        this.state &= 0xFFFFFFEF;
        this.parent.redraw();
    }

    protected void checkTypeButtonPressed() {
        if (!this.isEnable) {
            return;
        }
        this.state ^= 2;
        this.parent.redraw();
        this.selectRadio();
        this.parent.fireSelectionEvent();
    }

    protected void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.state = enabled ? (this.state |= 4) : (this.state &= 0xFFFFFFFB);
        this.parent.redraw();
    }

    protected void setSelection(boolean selected) {
        this.state = selected ? (this.state |= 2) : (this.state &= 0xFFFFFFFD);
        this.parent.redraw();
    }

    protected boolean getSelection() {
        return (this.state & 2) == 2;
    }

    protected boolean setFocus() {
        this.isFocus = true;
        if (!this.isEnable) {
            return true;
        }
        this.state |= 8;
        this.parent.redraw();
        return true;
    }

    protected boolean removeFocus() {
        this.isFocus = false;
        if (!this.isEnable) {
            return true;
        }
        this.state &= 0xFFFFFFF7;
        this.parent.redraw();
        return false;
    }

    private void selectRadio() {
        if (!this.parent.isEqualsType(this.parent.getStyle(), 16)) {
            return;
        }
        Control[] controlArray = this.parentComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Button && ((Button)child).isEqualsType(child.getStyle(), 16)) {
                if (this.parent == child) {
                    ((Button)child).setSelection(true);
                    ((Button)child).fireSelectionEvent();
                } else {
                    ((Button)child).setSelection(false);
                    ((Button)child).fireSelectionEvent();
                }
                ((Button)child).redraw();
            }
            ++n2;
        }
    }

    protected Image getImage() {
        if (this.isState(this.state, 22)) {
            return TizenResourceManager.getInstance().radioSelectedHover;
        }
        if (this.isState(this.state, 14)) {
            return TizenResourceManager.getInstance().radioSelectedFocused;
        }
        if (this.isState(this.state, 6)) {
            return TizenResourceManager.getInstance().radioSelected;
        }
        if (this.isState(this.state, 2)) {
            return TizenResourceManager.getInstance().radioSelectedDisable;
        }
        if (this.isState(this.state, 20)) {
            return TizenResourceManager.getInstance().radioNormalHover;
        }
        if (this.isState(this.state, 12)) {
            return TizenResourceManager.getInstance().radioNormalFocused;
        }
        if (this.isState(this.state, 4)) {
            return TizenResourceManager.getInstance().radioNormal;
        }
        return TizenResourceManager.getInstance().radioNormalDisable;
    }

    private void drawBackground(Rectangle rect, GC gc) {
        Color color = this.parent.getAttribute().getBackground();
        if (color == null) {
            return;
        }
        gc.setBackground(color);
        gc.fillRectangle(rect);
    }

    private void drawForeground(GC gc) {
        Color color = this.parent.getAttribute().getForeground();
        if (color != null) {
            gc.setForeground(color);
            return;
        }
        if (this.isState(this.state, 4)) {
            gc.setForeground(TizenResourceManager.RADIO_BUTTON_NORMAL_FONT_COLOR);
        } else {
            gc.setForeground(TizenResourceManager.RADIO_BUTTON_DISABLE_FONT_COLOR);
        }
    }

    protected void drawButton(Event e) {
        TizenButton me = (TizenButton)e.widget;
        Rectangle rect = me.getClientArea();
        this.drawBackground(rect, e.gc);
        int x = 0;
        int y = 0;
        Image img = this.getImage();
        if (img != null) {
            Rectangle imgRect = img.getBounds();
            y = (rect.height - imgRect.height) / 2;
            e.gc.drawImage(img, x, y);
            int fontHeight = e.gc.getFontMetrics().getHeight();
            x = imgRect.width + 6;
            y = (rect.height - fontHeight) / 2;
        }
        this.drawForeground(e.gc);
        if (this.parent.getAttribute().getFont() != null) {
            e.gc.setFont(this.parent.getAttribute().getFont());
        }
        if (this.parent.getText() != null) {
            e.gc.drawText(this.parent.getText(), x, y, 15);
        }
    }
}

