/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.application;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.OSChecker;
import org.tizen.library.sdkutils.api.impl.SDKUtils;

public final class InstallPathConfig {
    private static final Logger logger = LoggerFactory.getLogger(InstallPathConfig.class);
    private static final String DIR_TOOLS = "tools";
    public static final String REG_PROFILE = "[a-zA-Z\\-]+";
    public static final String REG_VERSION = "(((\\d)|([1-9]\\d{2,}))\\.)+((\\d)|([1-9]\\d{2,}))";
    public static final String PLATFORM_SEPARATOR = "-";
    public static final String REG_DIR_PLATFORM = "[a-zA-Z\\-]+-(((\\d)|([1-9]\\d{2,}))\\.)+((\\d)|([1-9]\\d{2,}))";
    public static final String FORMAT_PLATFORM_NAME = "%s-%s";
    private static String defaultHomePath;
    private static final String REGISTRY_PATH_OF_SHELL_FOLDER = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
    private static final String REGISTRY_LOCAL_APP_DATA_OF_SHELL_FOLDER = "\"Local AppData\"";
    private static final String REG_VALUE = "REG_SZ";
    private static final String DIR_SDK_DATA = "tizen-sdk-data";
    private static String sdkInstallPath;
    private static String sdkDataPath;

    static {
        sdkInstallPath = null;
        sdkDataPath = null;
        try {
            SDKUtils sdkUtils = SDKUtils.getInstance();
            sdkInstallPath = sdkUtils.getInstalledSDKPath();
            sdkDataPath = sdkUtils.getInstalledSDKDataPath();
        }
        catch (Throwable e) {
            logger.error("Failed to load the supported profile list from the Package Manager", e);
        }
    }

    public static String getSDKPath() {
        return sdkInstallPath;
    }

    public static String getToolsPath() {
        return String.valueOf(InstallPathConfig.getSDKPath()) + File.separator + DIR_TOOLS;
    }

    public static String getSDBPath() {
        return String.valueOf(InstallPathConfig.getToolsPath()) + File.separator + (OSChecker.isWindows() ? "sdb.exe" : "sdb");
    }

    public static String getUserDataPath() throws Exception {
        if (sdkDataPath != null) {
            return sdkDataPath;
        }
        if (OSChecker.isWindows()) {
            defaultHomePath = InstallPathConfig.getRegistryValue(REGISTRY_PATH_OF_SHELL_FOLDER, REGISTRY_LOCAL_APP_DATA_OF_SHELL_FOLDER);
        } else if (OSChecker.isLinux() || OSChecker.isUnix() || OSChecker.isMAC()) {
            defaultHomePath = System.getProperty("user.home");
        } else {
            throw new Exception(String.valueOf(System.getProperty("os.name")) + " is not supported currently.");
        }
        return String.valueOf(defaultHomePath) + File.separator + DIR_SDK_DATA;
    }

    private static String getRegistryValue(String node, String key) throws IOException {
        if (!OSChecker.isWindows()) {
            return null;
        }
        BufferedReader br = null;
        String value = "";
        String query = "reg query \"" + node + "\" /v " + key;
        try {
            try {
                Process process = Runtime.getRuntime().exec(query);
                String encoding = System.getProperty("sun.jnu.encoding");
                br = new BufferedReader(new InputStreamReader(process.getInputStream(), encoding));
                String line = null;
                while ((line = br.readLine()) != null) {
                    int index = line.indexOf(REG_VALUE);
                    if (index < 0) continue;
                    value = line.substring(index + REG_VALUE.length()).trim();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                if (br != null) {
                    br.close();
                }
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return value;
    }
}

