/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.tizen.common.file.AbstractFileHandler;
import org.tizen.common.file.FileHandler;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;

public class StandardFileHandler
extends AbstractFileHandler {
    protected String cwd;

    public StandardFileHandler() {
        try {
            this.cwd = new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public StandardFileHandler(String cwd) {
        try {
            this.cwd = new File(cwd).getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected File getFile(String path) {
        File dummy = new File(path);
        if (dummy.isAbsolute()) {
            this.logger.trace("{} is absolute path", (Object)path);
            return dummy;
        }
        File ret = new File(this.getCurrentWorkingDirectory(), path);
        this.logger.trace("File {} for {}", (Object)ret, (Object)path);
        return ret;
    }

    @Override
    public String getCurrentWorkingDirectory() {
        return this.cwd;
    }

    @Override
    public void setCurrentWorkingDirectory(String cwd) {
        this.cwd = cwd;
    }

    @Override
    public void makeDirectory(String path) throws IOException {
        this.getFile(path).mkdirs();
    }

    @Override
    public void moveDirectory(String source, String target) throws IOException {
        File file = this.getFile(source);
        if (!file.isDirectory()) {
            throw new IOException();
        }
        file.renameTo(this.getFile(target));
    }

    @Override
    public void copyDirectory(String source, String target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeDirectory(String path) throws IOException {
        if (!FileHandler.Type.DIRECTORY.equals(this.get(path, FileHandler.Attribute.TYPE))) {
            throw new IOException();
        }
        for (String childPath : this.list(path)) {
            Object type = this.get(childPath, FileHandler.Attribute.TYPE);
            if (FileHandler.Type.DIRECTORY.equals(type)) {
                this.removeDirectory(childPath);
                continue;
            }
            if (!FileHandler.Type.FILE.equals(type)) continue;
            this.removeFile(childPath);
        }
        this.getFile(path).delete();
    }

    @Override
    public Collection<String> list(String path) throws IOException {
        File file = this.getFile(path);
        File[] children = file.listFiles();
        ArrayList<String> ret = new ArrayList<String>();
        if (children == null) {
            return ret;
        }
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            ret.add(FilenameUtil.getCanonicalForm(child.getAbsolutePath()));
            ++n2;
        }
        return ret;
    }

    @Override
    public void write(String path, InputStream in) throws IOException {
        File file = this.getFile(path);
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        this.logger.trace("Path :{}", (Object)path);
        FileOutputStream fileOut = new FileOutputStream(file);
        try {
            IOUtil.redirect(in, fileOut);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(fileOut);
            throw throwable;
        }
        IOUtil.tryClose(fileOut);
    }

    @Override
    public InputStream read(String path) throws IOException {
        return new FileInputStream(this.getFile(path));
    }

    @Override
    public void moveFile(String source, String target) throws IOException {
        File file = this.getFile(source);
        if (!file.isFile()) {
            throw new IOException();
        }
        file.renameTo(this.getFile(target));
    }

    @Override
    public void copyFile(String source, String target) throws IOException {
        File file = this.getFile(source);
        if (!file.isFile()) {
            throw new IOException();
        }
        FileInputStream sourceIn = new FileInputStream(this.getFile(source));
        FileOutputStream targetOut = new FileOutputStream(this.getFile(target));
        try {
            IOUtil.redirect(sourceIn, targetOut);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(targetOut, sourceIn);
            throw throwable;
        }
        IOUtil.tryClose(targetOut, sourceIn);
    }

    @Override
    public void removeFile(String path) throws IOException {
        File file = this.getFile(path);
        if (!file.isFile()) {
            if (!file.exists()) {
                this.logger.error("{} is not exist.", (Object)path);
                throw new FileNotFoundException(String.valueOf(path) + " is not exist.");
            }
            this.logger.error("{} is not a file", (Object)path);
            throw new IOException(String.valueOf(path) + " is not a file.");
        }
        file.delete();
    }

    @Override
    public Object get(String path, FileHandler.Attribute name) throws IOException {
        this.logger.trace("Path :{}, Attribute :{}", (Object)path, (Object)name);
        File file = this.getFile(path);
        if (FileHandler.Attribute.TYPE.equals((Object)name)) {
            if (file.isDirectory()) {
                return FileHandler.Type.DIRECTORY;
            }
            if (file.isFile()) {
                return FileHandler.Type.FILE;
            }
        } else {
            if (FileHandler.Attribute.EXISTS.equals((Object)name)) {
                return file.exists();
            }
            if (FileHandler.Attribute.PATH.equals((Object)name)) {
                return file.getCanonicalFile().getCanonicalPath();
            }
            if (FileHandler.Attribute.URI.equals((Object)name) || FileHandler.Attribute.URL.equals((Object)name)) {
                return file.toURI().toURL().toString();
            }
            if (FileHandler.Attribute.MODIFIED.equals((Object)name)) {
                return file.lastModified();
            }
            if (FileHandler.Attribute.HIDDEN.equals((Object)name)) {
                return file.isHidden();
            }
            if (FileHandler.Attribute.READABLE.equals((Object)name)) {
                return file.canRead();
            }
            if (FileHandler.Attribute.WRITABLE.equals((Object)name)) {
                return file.canWrite();
            }
            if (FileHandler.Attribute.NAME.equals((Object)name)) {
                return file.getName();
            }
        }
        throw new IOException(String.valueOf(path) + "'s Unknown attribute :" + (Object)((Object)name));
    }

    @Override
    public void set(String path, FileHandler.Attribute name, Object value) throws IOException {
    }
}

