/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.ui.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.dialog.NotificationIconType;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.cache.ColorCache;
import org.tizen.common.util.cache.FontCache;
import org.tizen.common.util.cache.ImageCache;

public class NotificationTrayPopup {
    private static Logger logger = LoggerFactory.getLogger(NotificationTrayPopup.class);
    private static final int DISPLAY_TIME = 3000;
    private static final int FADE_TIMER = 100;
    private static final int FADE_IN_STEP = 30;
    private static final int FADE_OUT_STEP = 8;
    private static final int FINAL_ALPHA = 229;
    private static final int SHELL_HEIGHT = 110;
    private static final int SHELL_WIDTH = 320;
    private static final int TITLE_SIZE = 13;
    private static final int DETAIL_SIZE = OSChecker.isWindows() ? 9 : 10;
    private static final String systemFontName = SWTUtil.getDisplay().getSystemFont().getFontData()[0].getName();
    private static final Font titleFont = FontCache.getFont(new Font((Device)SWTUtil.getDisplay(), systemFontName, 13, 1));
    private static final Font detailFont = FontCache.getFont(new Font((Device)SWTUtil.getDisplay(), systemFontName, DETAIL_SIZE, 64));
    private static Color _bgColorWithAlpha = new Color((Device)SWTUtil.getDisplay(), new RGB(117, 117, 117), 229);
    private static Color _titleFgColor;
    private static Color _fgColor;
    private static Color _fgOptionColor;
    private static List<Shell> _activeShells;
    private static Image _oldImage;
    private static Shell _shell;
    private static int startX;
    private static int startY;
    private static final Region region;

    static {
        _fgColor = _titleFgColor = ColorCache.getWhite();
        _fgOptionColor = new Color((Device)SWTUtil.getDisplay(), new RGB(255, 255, 255), 165);
        _activeShells = new ArrayList<Shell>();
        startX = 0;
        startY = 0;
        region = (Region)JFaceResources.getResources().get(new DeviceResourceDescriptor(){

            public Object createResource(Device device) {
                return SWTUtil.getTrimmedRegion(ImageCache.getImage("noti_pop_bg.png"), 6);
            }

            public void destroyResource(Object previouslyCreatedObject) {
                SWTUtil.tryDispose(new Resource[]{(Region)previouslyCreatedObject});
            }
        });
    }

    private static void createLeftIconSection(NotificationIconType type, Composite inner) {
        CLabel imgLabel = new CLabel(inner, 0);
        imgLabel.setLayoutData((Object)new GridData(68));
        imgLabel.setImage(type.getImage());
    }

    private static void fadeIn(final Shell _shell, final boolean fade) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (_shell == null || _shell.isDisposed()) {
                        return;
                    }
                    int cur = _shell.getAlpha();
                    if ((cur += 30) > 229) {
                        _shell.setAlpha(229);
                        if (fade) {
                            NotificationTrayPopup.startTimer(_shell);
                        }
                        return;
                    }
                    _shell.setAlpha(cur);
                    SWTUtil.getDisplay().timerExec(100, (Runnable)this);
                }
                catch (Exception err) {
                    logger.warn("Excetion occurred during fadein", (Throwable)err);
                }
            }
        };
        SWTUtil.getDisplay().timerExec(100, run);
    }

    private static void startTimer(final Shell _shell) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (_shell == null || _shell.isDisposed()) {
                        return;
                    }
                    NotificationTrayPopup.fadeOut(_shell);
                }
                catch (Exception err) {
                    logger.warn("Excetion occurred during startTimer", (Throwable)err);
                }
            }
        };
        SWTUtil.getDisplay().timerExec(3000, run);
    }

    private static void fadeOut(final Shell _shell) {
        Runnable run = new Runnable(){
            private int fadeValue = -1;

            @Override
            public void run() {
                try {
                    if (_shell == null || _shell.isDisposed()) {
                        return;
                    }
                    if (this.fadeValue < 0) {
                        this.fadeValue = _shell.getAlpha();
                    }
                    this.fadeValue -= 8;
                    if (this.fadeValue <= 0) {
                        _shell.setAlpha(0);
                        if (_oldImage != null) {
                            _oldImage.dispose();
                        }
                        _shell.dispose();
                        _activeShells.remove(_shell);
                        return;
                    }
                    _shell.setAlpha(this.fadeValue);
                    SWTUtil.getDisplay().timerExec(100, (Runnable)this);
                }
                catch (Exception err) {
                    logger.warn("Excetion occurred during fadeOut", (Throwable)err);
                }
            }
        };
        SWTUtil.getDisplay().timerExec(100, run);
    }
}

