/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.util.SWTUtil;

public abstract class DialogUtil {
    private static final Object lockQuestion = new Object();

    public static void openMessageDialog(String message) {
        DialogUtil.openMessageDialog(DialogUtil.getShell(), message);
    }

    public static void openMessageDialog(Shell shell, String message) {
        DialogUtil.openMessageDialog(shell, "Info", message);
    }

    public static void openMessageDialog(final Shell shell, final String title, final String message) {
        SWTUtil.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
            }
        });
    }

    @Deprecated
    public static void openProxyDialog(final String text, String message) {
        final String msg = message;
        SWTUtil.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)DialogUtil.getShell(), (String)text, (String)msg);
            }
        });
    }

    public static void openErrorDialog(String message) {
        DialogUtil.openErrorDialog("Error", message);
    }

    public static void openErrorDialog(String title, String message) {
        DialogUtil.openErrorDialog(DialogUtil.getShell(), title, message);
    }

    public static void openErrorDialog(final Shell shell, final String title, final String message) {
        SWTUtil.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)shell, (String)title, (String)message);
            }
        });
    }

    public static int openQuestionDialog(String message) {
        return DialogUtil.openQuestionDialog("Question", message);
    }

    public static int openQuestionDialog(String title, String message) {
        return DialogUtil.openQuestionDialog(DialogUtil.getShell(), title, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int openQuestionDialog(final Shell shell, final String title, final String message) {
        Object object = lockQuestion;
        synchronized (object) {
            final AtomicInteger retValue = new AtomicInteger();
            SWTUtil.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (MessageDialog.openQuestion((Shell)shell, (String)title, (String)message)) {
                        retValue.set(64);
                    } else {
                        retValue.set(128);
                    }
                }
            });
            return retValue.get();
        }
    }

    public static Shell getActiveShell() {
        return Display.getCurrent().getActiveShell();
    }

    private static Shell getShell() {
        Shell shell = DialogUtil.getActiveShell();
        if (shell == null) {
            shell = new Shell();
        }
        return shell;
    }
}

