/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IStartup;
import org.tizen.common.CommonPlugin;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.DialogUtil;
import org.tizen.sdblib.SmartDevelopmentBridge;

public class CommonStartup
implements IStartup {
    public void earlyStartup() {
        new Thread("Start SmartDevelopmentBridge"){

            @Override
            public void run() {
                CommonStartup.this.startSmartDevelopmentBridge();
            }
        }.start();
    }

    private void startSmartDevelopmentBridge() {
        SmartDevelopmentBridge bridge = SmartDevelopmentBridge.getBridge();
        if (bridge != null) {
            bridge.startBridge();
            try {
                bridge.waitforStart(5000L);
                if (!bridge.getStarted()) {
                    DialogUtil.openErrorDialog("Failed to start sdb");
                    bridge.stopBridge();
                }
                String sdbLogPath = String.valueOf(InstallPathConfig.getUserDataPath()) + File.separator + "log";
                bridge.setSdbLogLocation(sdbLogPath);
            }
            catch (Throwable t) {
                CommonPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.tizen.common", "Problem occured while initializing sdb", t));
                DialogUtil.openErrorDialog("Failed to start sdb");
            }
        }
    }
}

