/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sdb.command;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sdb.command.AbstractAppCommand;
import org.tizen.common.sdb.command.SdbCommandHelper;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.sdblib.IDevice;

public class FsCommand
extends AbstractAppCommand {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String REMOVE_FILE_COMMAND = "rm -rf %s";
    protected String MAKE_DIRECTORY_COMMAND = "mkdir -p -m 755 \"%s\"";
    protected String CHANGE_OWNER_COMMAND = "chown -R app:app \"%s\"";
    protected String EXTRACT_COMMAND = "unzip -o \"%s\" -d \"%s\"";
    protected String LS_COMMAND = "ls \"%s\"";
    protected String SYMBOLIC_LINK_COMMAND = "ln -sf \"%s\" \"%s\"";
    protected String ONDEMAND_INSTALL_COMMAND = "cd %s && %s %s && rm -f %s";
    protected String ONDEMAND_INSTALL_TAR = "tar -xf";
    protected String ONDEMAND_INSTALL_RPM = "rpm -U";
    public final String CMD_RESULT_SUCCESS = "0";
    protected String command = "";
    protected String resultMsg = "";

    public FsCommand(IDevice device, ITizenConsoleManager console) {
        this.device = device;
        this.launchConsole = console;
    }

    public void removeFile(String filePath) throws Exception {
        this.command = String.format(this.REMOVE_FILE_COMMAND, filePath);
        this.resultMsg = "Remove file %s: " + filePath;
        this.executeCommand();
        this.isSuccess();
    }

    public boolean mkdir(String dirPath) throws Exception {
        this.command = String.format(this.MAKE_DIRECTORY_COMMAND, dirPath);
        this.resultMsg = "mkdir command %s: " + dirPath;
        this.executeCommand();
        return this.isSuccess();
    }

    public void chown(String path) throws Exception {
        this.command = String.format(this.CHANGE_OWNER_COMMAND, path);
        this.resultMsg = "chown command %s: " + path;
        this.executeCommand();
        this.isSuccess();
    }

    public void unzip(String remoteZipPath, String appInstallPath) throws Exception {
        this.command = String.format(this.EXTRACT_COMMAND, remoteZipPath, appInstallPath);
        this.resultMsg = "unzip command %s: " + remoteZipPath;
        this.executeCommand();
        this.isSuccess();
    }

    public boolean isExists(String path) throws Exception {
        this.command = String.format(this.LS_COMMAND, path);
        this.resultMsg = "ls command %s: " + path;
        this.executeCommand();
        return this.isSuccess();
    }

    public boolean createSymbolicLink(String source, String target) throws Exception {
        this.command = String.format(this.SYMBOLIC_LINK_COMMAND, source, target);
        this.resultMsg = "ln command %s: " + source + " to " + target;
        this.executeCommand();
        return this.isSuccess();
    }

    public boolean ondemandInstall(String dirPath, String type, String fileName) throws Exception {
        String installType = this.ONDEMAND_INSTALL_TAR;
        if (type.equals("rpm")) {
            installType = this.ONDEMAND_INSTALL_RPM;
        }
        this.command = String.format(this.ONDEMAND_INSTALL_COMMAND, dirPath, installType, fileName, fileName);
        this.resultMsg = "Ondemand install %s: " + fileName;
        this.executeCommand();
        return this.isSuccess();
    }

    protected String getCommand() {
        this.command = String.valueOf(this.command) + "; echo $?;";
        return this.command;
    }

    @Override
    protected void executeCommand() throws Exception {
        this.helper = new SdbCommandHelper(this.getDevice(), this.getConsole(), null);
        this.helper.runCommand(this.getCommand());
    }

    protected boolean isSuccess() {
        String result = this.helper.getEndLine();
        if (!"0".equals(result)) {
            String msg = String.valueOf(String.format(this.resultMsg, "failed")) + "\n";
            this.logger.error(msg, (Object)this.helper.getCommandOutput());
            this.print(msg);
            return false;
        }
        String msg = String.valueOf(String.format(this.resultMsg, "complete")) + "\n";
        this.print(msg);
        return true;
    }

    protected void print(String msg) {
        if (this.getConsole() != null) {
            this.getConsole().print(msg);
        }
    }
}

