/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class ExtensionStateModel
extends EventManager
implements IExtensionStateModel {
    private final String id;
    private final String viewerId;
    private final Map values = new HashMap();

    public ExtensionStateModel(String anId, String aViewerId) {
        this.id = anId;
        this.viewerId = aViewerId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getViewerId() {
        return this.viewerId;
    }

    @Override
    public String getStringProperty(String aPropertyName) {
        return (String)this.values.get(aPropertyName);
    }

    @Override
    public boolean getBooleanProperty(String aPropertyName) {
        Boolean b = (Boolean)this.values.get(aPropertyName);
        return b != null ? b : false;
    }

    @Override
    public int getIntProperty(String aPropertyName) {
        Integer i = (Integer)this.values.get(aPropertyName);
        return i != null ? i : -1;
    }

    @Override
    public void setStringProperty(String aPropertyName, String aPropertyValue) {
        String newValue;
        String oldValue = (String)this.values.get(aPropertyName);
        if (this.hasPropertyChanged(oldValue, newValue = aPropertyValue)) {
            this.values.put(aPropertyName, newValue);
            this.firePropertyChangeEvent(new PropertyChangeEvent((Object)this, aPropertyName, (Object)oldValue, (Object)newValue));
        }
    }

    @Override
    public void setBooleanProperty(String aPropertyName, boolean aPropertyValue) {
        Boolean newValue;
        Boolean oldValue = (Boolean)this.values.get(aPropertyName);
        Boolean bl = newValue = aPropertyValue ? Boolean.TRUE : Boolean.FALSE;
        if (this.hasPropertyChanged(oldValue, newValue)) {
            this.values.put(aPropertyName, aPropertyValue ? Boolean.TRUE : Boolean.FALSE);
            this.firePropertyChangeEvent(new PropertyChangeEvent((Object)this, aPropertyName, (Object)oldValue, (Object)newValue));
        }
    }

    @Override
    public void setIntProperty(String aPropertyName, int aPropertyValue) {
        Integer newValue;
        Integer oldValue = (Integer)this.values.get(aPropertyName);
        if (this.hasPropertyChanged(oldValue, newValue = new Integer(aPropertyValue))) {
            this.values.put(aPropertyName, newValue);
            this.firePropertyChangeEvent(new PropertyChangeEvent((Object)this, aPropertyName, (Object)oldValue, (Object)newValue));
        }
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener aListener) {
        this.addListenerObject(aListener);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener aListener) {
        this.removeListenerObject(aListener);
    }

    @Override
    public Object getProperty(String aPropertyName) {
        return this.values.get(aPropertyName);
    }

    @Override
    public void setProperty(String aPropertyName, Object aPropertyValue) {
        Object newValue;
        Object oldValue = this.values.get(aPropertyName);
        if (this.hasPropertyChanged(oldValue, newValue = aPropertyValue)) {
            this.values.put(aPropertyName, newValue);
            this.firePropertyChangeEvent(new PropertyChangeEvent((Object)this, aPropertyName, oldValue, newValue));
        }
    }

    private boolean hasPropertyChanged(Object oldValue, Object newValue) {
        return oldValue == null || !oldValue.equals(newValue);
    }

    protected void firePropertyChangeEvent(PropertyChangeEvent anEvent) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(anEvent);
            ++i;
        }
    }
}

