/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.ViewUtil;

public abstract class LVLocalizationTab
extends CTabItem {
    public static boolean KEY_MODE = false;
    protected static IProject selectedProject = null;
    protected IProject myProject = null;
    protected CTabFolder folder = null;
    protected boolean isDirty = true;

    public LVLocalizationTab(IProject project, CTabFolder parent, String tabName) {
        super(parent, 0);
        Object firstElement;
        this.folder = parent;
        this.myProject = project;
        IStructuredSelection selection = (IStructuredSelection)ViewUtil.getWorkbenchWindow().getSelectionService().getSelection("org.eclipse.ui.navigator.ProjectExplorer");
        if (selection != null && (firstElement = selection.getFirstElement()) instanceof IResource) {
            selectedProject = ((IResource)firstElement).getProject();
        }
        this.initTab(tabName);
    }

    public void initTab(String tabName) {
        this.setText(tabName);
        this.initTable((Composite)this.folder);
    }

    protected abstract void initTable(Composite var1);

    protected abstract void outerTabSelected();

    protected void projectChanged(IProject project) {
        selectedProject = project != null && ProjectUtil.isTizenWebProject((IProject)project) ? project : null;
    }

    protected abstract void selectionChanged(ISelection var1);

    protected abstract void updateOuterTab();

    protected void notifyLocaleChanged() {
        CTabItem[] cTabItemArray = this.folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            LVLocalizationTab tab = (LVLocalizationTab)item;
            tab.setDirty();
            tab.localeChanged();
            ++n2;
        }
    }

    protected void notifyProjectDeleted() {
        CTabItem[] cTabItemArray = this.folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            LVLocalizationTab tab = (LVLocalizationTab)item;
            tab.setDirty();
            ++n2;
        }
    }

    protected abstract void localeChanged();

    public abstract void viewmodeChanged();

    public abstract void resourceChanged();

    public LVLocalizationTab setDirty() {
        this.isDirty = true;
        return this;
    }
}

