/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.tizen.common.rest.model.RepositoryManager;
import org.tizen.common.rest.model.run.AdvancedTreePath;
import org.tizen.common.rest.model.run.RunHistory;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.IRestUiModel;
import org.tizen.common.rest.model.schema.IWadlModel;
import org.tizen.common.rest.run.RestTestEngine;
import org.tizen.common.rest.run.RunHistoryManager;
import org.tizen.common.rest.ui.handlers.RESTCommonHandler;
import org.tizen.common.rest.ui.views.RESTDynamicRunAs;

public class RESTRunAsHandler
extends RESTCommonHandler {
    @Override
    public Object execute() {
        String key = this.event.getParameter(RESTDynamicRunAs.RUNAS_PARAM_KEY);
        if (key == null) {
            this.clearHistory();
        } else {
            RunHistoryManager rManager = RunHistoryManager.getInstance();
            Map<String, List<AdvancedTreePath>> map = rManager.getRunHistories();
            List<AdvancedTreePath> history = map.get(key);
            ITreeSelection selection = RESTRunAsHandler.generateTreeSelection(history);
            if (selection == null || selection.isEmpty()) {
                RunHistoryManager.getInstance().removeRunHistory(key);
            } else {
                RestTestEngine.run(this.shell, (IStructuredSelection)selection);
            }
        }
        return null;
    }

    private void clearHistory() {
        RunHistoryManager.getInstance().clearRunHistories();
    }

    public static ITreeSelection generateTreeSelection(List<AdvancedTreePath> history) {
        ArrayList<TreePath> buf = new ArrayList<TreePath>();
        for (AdvancedTreePath path : history) {
            int count = path.getSegmentCount();
            ArrayList<IRestUiModel> modelBuf = new ArrayList<IRestUiModel>();
            int i = 0;
            while (i < count) {
                RunHistory h = path.getSegment(i);
                String displayName = h.getDisplayName();
                IRestUiModel model = RESTRunAsHandler.findCurrentPath(displayName, h.getId());
                if (model == null) break;
                modelBuf.add(model);
                ++i;
            }
            if (modelBuf.size() <= 0) continue;
            TreePath newPath = new TreePath(modelBuf.toArray());
            buf.add(newPath);
        }
        TreeSelection treeSelection = new TreeSelection(buf.toArray(new TreePath[buf.size()]));
        return treeSelection;
    }

    private static IRestUiModel findCurrentPath(String displayName, String id) {
        RepositoryManager rManager = RepositoryManager.getInstance();
        List<Application> appList = rManager.getApplications();
        IRestUiModel model = RESTRunAsHandler.findCurrentPath(appList, displayName, id);
        return model;
    }

    private static <T extends IWadlModel> IRestUiModel findCurrentPath(List<T> modelList, String displayName, String id) {
        IRestUiModel result = null;
        for (IWadlModel t : modelList) {
            IRestUiModel treeModel;
            if (!(t instanceof IRestUiModel) || (treeModel = (IRestUiModel)t).getDisplayName() == null) continue;
            if (treeModel.getDisplayName().equals(displayName) && treeModel.getElementId().equals(id)) {
                result = treeModel;
                break;
            }
            List<IWadlModel> children = treeModel.getChildren();
            result = RESTRunAsHandler.findCurrentPath(children, displayName, id);
            if (result != null) break;
        }
        return result;
    }
}

