/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.dialogs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.ui.dialogs.AbstractStringsAddDialog;
import org.tizen.common.rest.ui.dialogs.PrefVariableAddDialog;
import org.tizen.common.rest.ui.dialogs.UserVariable;
import org.tizen.common.rest.ui.dialogs.UserVariableEditing;
import org.tizen.common.rest.ui.preferences.AbstractTablePreferencePage;
import org.tizen.common.rest.util.StringUtil;

public class UserVariableCellEditorDialog
extends AbstractStringsAddDialog {
    private static final String TITLE = "Select User Variable";
    private Table table;
    private TableViewer tableViewer;
    private Text searchText;
    private VariableFilter filter = new VariableFilter();
    private IPreferenceStore pStore = RestPlugin.getDefault().getPreferenceStore();
    private String current_profile = RestPlugin.getDefault().getPreferenceStore().getString("PREF_KEY_USER_VARIABLES_SELECTED_PROFILE");
    private Button addBtn;
    private List<UserVariable> list = new ArrayList<UserVariable>();

    public UserVariableCellEditorDialog(Shell parent) {
        super(parent, TITLE);
    }

    @Override
    protected Shell createShell() {
        Shell shell = new Shell(this.getParent(), this.getStyle() | 0x10);
        shell.setSize(480, 400);
        shell.setText(this.getText());
        shell.setLayout((Layout)new GridLayout());
        return shell;
    }

    @Override
    protected void createControl(Shell shell) {
        this.createContents(shell);
        this.createButtonGroup(shell);
        this.getFirstFocusControl().setFocus();
    }

    @Override
    protected void createContents(Shell shell) {
        this.searchText = new Text((Composite)shell, 2048);
        GridData gd = new GridData(768);
        this.searchText.setLayoutData((Object)gd);
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UserVariableCellEditorDialog.this.tableViewer.removeFilter((ViewerFilter)UserVariableCellEditorDialog.this.filter);
                UserVariableCellEditorDialog.this.tableViewer.addFilter((ViewerFilter)UserVariableCellEditorDialog.this.filter);
                UserVariableCellEditorDialog.this.tableViewer.refresh();
            }
        });
        this.table = new Table((Composite)shell, 68356);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        gd = new GridData(1808);
        this.table.setLayoutData((Object)gd);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new VariableTableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new VariableTableLabelProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                UserVariableCellEditorDialog.this.updateOkButtonState();
                UserVariableCellEditorDialog.this.updateResult();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (UserVariableCellEditorDialog.this.updateOkButtonState()) {
                    UserVariableCellEditorDialog.this.updateResult();
                    UserVariableCellEditorDialog.this.close();
                }
            }
        });
        this.tableViewer.addFilter((ViewerFilter)this.filter);
        this.tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return super.compare(viewer, (Object)((UserVariable)e1).getName(), (Object)((UserVariable)e2).getName());
            }
        });
        this.createTableColumns(this.tableViewer);
        this.loadTableData();
    }

    @Override
    protected void createButtonGroup(Shell parent) {
        Composite composite = new Composite((Composite)parent, 0);
        GridData data = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        this.addBtn = new Button(composite, 0);
        this.addBtn.setText("Add");
        GridData gd = new GridData();
        gd.widthHint = 80;
        this.addBtn.setLayoutData((Object)gd);
        this.addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UserVariableCellEditorDialog.this.openAddPopup()) {
                    UserVariableCellEditorDialog.this.tableViewer.setInput((Object)UserVariableCellEditorDialog.this.list);
                    UserVariableCellEditorDialog.this.tableViewer.refresh();
                }
            }
        });
        this.btnOk = new Button(composite, 0);
        this.btnOk.setText("OK");
        this.btnOk.setEnabled(false);
        gd = new GridData();
        gd.widthHint = 80;
        this.btnOk.setLayoutData((Object)gd);
        this.btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserVariableCellEditorDialog.this.okButtonPressed();
            }
        });
        this.btnCancel = new Button(composite, 0);
        this.btnCancel.setText("Cancel");
        gd = new GridData();
        gd.widthHint = 80;
        this.btnCancel.setLayoutData((Object)gd);
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserVariableCellEditorDialog.this.cancelButtonPressed();
            }
        });
    }

    public boolean openAddPopup() {
        PrefVariableAddDialog dialog = new PrefVariableAddDialog(this.table.getShell());
        String[] result = (String[])dialog.open();
        if (result != null && result.length == 2) {
            this.list.add(new UserVariable(result[0], result[1]));
            return true;
        }
        return false;
    }

    private void createTableColumns(TableViewer viewer) {
        TableLayout layout = new TableLayout();
        TableViewerColumn col1 = new TableViewerColumn(viewer, 0x1000000, 0);
        TableColumn column1 = col1.getColumn();
        column1.setText(RestUIMessages.UserVariablesPreferencePage_table_name_label);
        ColumnWeightData data = new ColumnWeightData(50, true);
        layout.addColumnData((ColumnLayoutData)data);
        col1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((UserVariable)element).getName();
            }
        });
        TableViewerColumn col2 = new TableViewerColumn(viewer, 16384, 1);
        TableColumn column2 = col2.getColumn();
        column2.setText(RestUIMessages.UserVariablesPreferencePage_table_value_label);
        data = new ColumnWeightData(50, true);
        layout.addColumnData((ColumnLayoutData)data);
        col2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((UserVariable)element).getValue();
            }
        });
        TableEditor editor = new TableEditor(this.table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        col2.setEditingSupport((EditingSupport)new UserVariableEditing(this.tableViewer, 1));
        viewer.getTable().setLayout((Layout)layout);
    }

    private void loadTableData() {
        String prop = StringUtil.getActiveProfileVariables();
        if (prop != null && prop.length() > 0) {
            String[] args;
            String[] stringArray = args = prop.split("\\|");
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                String[] line = arg.split("=");
                this.list.add(new UserVariable(line[0], line[1]));
                ++n2;
            }
        }
        if (this.list.size() > 0) {
            this.tableViewer.setInput(this.list);
        }
        this.tableViewer.refresh();
    }

    @Override
    protected boolean updateOkButtonState() {
        IStructuredSelection sel = (IStructuredSelection)this.tableViewer.getSelection();
        boolean enabled = sel != null && !sel.isEmpty();
        this.getBtnOk().setEnabled(enabled);
        return enabled;
    }

    @Override
    protected String[] makeResult() {
        TableItem[] items = this.table.getSelection();
        if (items != null && items.length > 0) {
            String key = items[0].getText(0);
            String val = items[0].getText(1);
            return new String[]{key, val};
        }
        return new String[0];
    }

    @Override
    protected Control getFirstFocusControl() {
        return this.searchText;
    }

    @Override
    protected void close() {
        this.pStore.setValue("PREF_KEY_USER_VARIABLES." + this.current_profile, AbstractTablePreferencePage.makePreferenceValue(this.table));
        try {
            try {
                ((IPersistentPreferenceStore)this.pStore).save();
            }
            catch (IOException e) {
                e.printStackTrace();
                super.close();
            }
        }
        finally {
            super.close();
        }
    }

    protected class VariableFilter
    extends ViewerFilter {
        protected VariableFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            String keyword = UserVariableCellEditorDialog.this.searchText.getText();
            return ((UserVariable)element).getName().toLowerCase().contains(keyword.toLowerCase());
        }
    }

    protected class VariableTableContentProvider
    implements IStructuredContentProvider {
        protected VariableTableContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List list = (List)inputElement;
                return list.toArray();
            }
            return new Object[0];
        }
    }

    protected class VariableTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected VariableTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof NameValuePair) {
                NameValuePair nameValuePair = (NameValuePair)element;
                return columnIndex == 0 ? nameValuePair.getName() : nameValuePair.getValue();
            }
            return "";
        }
    }
}

