/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.preferenceWindow;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.mihalis.opal.preferenceWindow.PWContainer;
import org.mihalis.opal.preferenceWindow.PWGroup;
import org.mihalis.opal.preferenceWindow.PWRow;
import org.mihalis.opal.preferenceWindow.PWRowGroup;
import org.mihalis.opal.preferenceWindow.PreferenceWindow;
import org.mihalis.opal.preferenceWindow.widgets.PWWidget;

public class PWTab
extends PWContainer {
    private final Image image;
    private final String text;
    private final List<PWRowGroup> children;

    PWTab(Image image, String text) {
        this.image = image;
        this.text = text;
        this.children = new ArrayList<PWRowGroup>();
    }

    @Override
    public PWContainer add(PWContainer element) {
        if (!(element instanceof PWGroup) && !(element instanceof PWRow)) {
            throw new UnsupportedOperationException("Can only add a PWGroup or a PWRow.");
        }
        ((PWRowGroup)element).setParent(this);
        this.children.add((PWRowGroup)element);
        return this;
    }

    @Override
    public PWContainer add(PWWidget widget) {
        PWRow row = new PWRow();
        row.setParent(this);
        row.add(widget);
        this.children.add(row);
        return this;
    }

    @Override
    public void build(Composite parent) {
        int numberOfColumns = this.computeNumberOfColums();
        GridLayout gridLayout = new GridLayout(numberOfColumns, false);
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 1;
        parent.setLayout((Layout)gridLayout);
        for (PWRowGroup rowGroup : this.children) {
            rowGroup.setParentNumberOfColumns(numberOfColumns);
            rowGroup.build(parent);
        }
        PreferenceWindow.getInstance().fireEnablers();
    }

    private int computeNumberOfColums() {
        int numberOfColumns = 1;
        for (PWRowGroup rowGroup : this.children) {
            if (!(rowGroup instanceof PWRow)) continue;
            numberOfColumns = Math.max(numberOfColumns, rowGroup.getNumberOfColums());
        }
        return numberOfColumns;
    }

    public Image getImage() {
        return this.image;
    }

    public String getText() {
        return this.text;
    }
}

