/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.model;

import java.io.File;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import zipeditor.Utils;
import zipeditor.model.Node;
import zipeditor.operations.ExtractOperation;

public class FileAdapter
implements IAdaptable {
    private Node fNode;
    private IFileStore fFileStore;

    public FileAdapter(Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        this.fNode = node;
    }

    public Object getAdapter(Class adapter) {
        if (IFileStore.class.equals((Object)adapter)) {
            if (this.fFileStore == null) {
                this.fFileStore = this.extractNode();
            }
            return this.fFileStore;
        }
        if (Node.class.equals((Object)adapter)) {
            return this.fNode;
        }
        return null;
    }

    public boolean isAdapted() {
        return this.fFileStore != null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileAdapter)) {
            return false;
        }
        return ((Object)((Object)this.fNode)).equals((Object)((FileAdapter)obj).fNode);
    }

    private IFileStore extractNode() {
        ExtractOperation operation = new ExtractOperation();
        File path = operation.extract(this.fNode, this.fNode.getModel().getTempDir(), true, (IProgressMonitor)new NullProgressMonitor());
        return Utils.getFileStore(path);
    }
}

