/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.logview.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.input.MouseEvent;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.tizen.common.connection.logview.controller.FilterButton;
import org.tizen.common.connection.logview.controller.FilterPopup;
import org.tizen.common.connection.logview.model.LogMatcher;
import org.tizen.common.connection.logview.model.LogModel;
import org.tizen.common.connection.logview.model.LogModelChangedListener;
import org.tizen.common.connection.logview.view.LogTab;

public class LogFilterTableColumn<S, T>
extends TableColumn<S, T> {
    private LogModel logModel;
    private String columnName;
    private FilterButton filterButton;
    private FilterPopup popup;
    private LinkedHashMap<String, Boolean> filterItems = new LinkedHashMap();

    public LogFilterTableColumn(LogModel model, String name) {
        super(name);
        this.logModel = model;
        this.columnName = name;
        this.filterButton = new FilterButton();
        this.filterButton.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                if (LogFilterTableColumn.this.popup.isShowing()) {
                    LogFilterTableColumn.this.popup.hide();
                } else {
                    LogFilterTableColumn.this.organizeFilterItems();
                    LogFilterTableColumn.this.popup.createMenuItem(LogFilterTableColumn.this.filterItems);
                    Label c = LogFilterTableColumn.this.filterButton.getIconLabel();
                    Bounds b = c.localToScene(c.getLayoutBounds());
                    FilterPopup menu = LogFilterTableColumn.this.popup;
                    Scene scene = c.getScene();
                    Window window = scene.getWindow();
                    menu.show((Node)c, window.getX() + scene.getX() + b.getMinX(), window.getY() + scene.getY() + b.getMaxY());
                }
            }
        });
        this.setGraphic((Node)this.filterButton.getPane());
        this.popup = new FilterPopup();
        this.popup.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent arg0) {
                LogFilterTableColumn.this.filterButton.setSelected(false);
            }
        });
        this.popup.setSaveEvent(new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                ArrayList filters = (ArrayList)LogFilterTableColumn.this.popup.getFilterList();
                ArrayList uniqValues = LogFilterTableColumn.this.getUniqValues();
                if (!uniqValues.isEmpty() && filters.containsAll(uniqValues)) {
                    filters.clear();
                }
                if (LogFilterTableColumn.this.columnName.equals(LogTab.LABEL_LEVEL)) {
                    LogFilterTableColumn.this.logModel.setLogLevelCriterion(filters);
                } else if (LogFilterTableColumn.this.columnName.equals(LogTab.LABEL_PID)) {
                    LogFilterTableColumn.this.logModel.setPidCriterion(filters);
                } else if (LogFilterTableColumn.this.columnName.equals(LogTab.LABEL_TID)) {
                    LogFilterTableColumn.this.logModel.setTidCriterion(filters);
                } else if (LogFilterTableColumn.this.columnName.equals(LogTab.LABEL_TAG)) {
                    LogFilterTableColumn.this.logModel.setTagCriterion(filters);
                }
                LogFilterTableColumn.this.popup.hide();
            }
        });
        this.logModel.addModelChangedListener(new LogModelChangedListener(){

            @Override
            public void matcherChanged(LogMatcher logMatcher) {
                ArrayList criterionValues = LogFilterTableColumn.this.getCriterionValues();
                if (criterionValues.isEmpty()) {
                    LogFilterTableColumn.this.filterButton.changeIcon(false);
                } else {
                    LogFilterTableColumn.this.filterButton.changeIcon(true);
                }
            }
        });
    }

    private void organizeFilterItems() {
        ArrayList<String> uniqValues = this.getUniqValues();
        ArrayList<String> criterionValues = this.getCriterionValues();
        this.filterItems.clear();
        if (criterionValues.isEmpty()) {
            for (String item : uniqValues) {
                this.filterItems.put(item, true);
            }
        } else {
            for (String item : uniqValues) {
                this.filterItems.put(item, false);
            }
        }
        for (String item : criterionValues) {
            this.filterItems.put(item, true);
        }
        this.filterItems = this.sortHashMapByValues(this.filterItems);
    }

    private ArrayList<String> getCriterionValues() {
        ArrayList<String> criterionValues = new ArrayList();
        if (this.columnName.equals(LogTab.LABEL_LEVEL)) {
            criterionValues = this.logModel.getLogLevelCriterion();
        } else if (this.columnName.equals(LogTab.LABEL_PID)) {
            criterionValues = this.logModel.getPidCriterion();
        } else if (this.columnName.equals(LogTab.LABEL_TID)) {
            criterionValues = this.logModel.getTidCriterion();
        } else if (this.columnName.equals(LogTab.LABEL_TAG)) {
            criterionValues = this.logModel.getTagCriterion();
        }
        return criterionValues;
    }

    private ArrayList<String> getUniqValues() {
        ArrayList<String> uniqvalues = new ArrayList();
        if (this.columnName.equals(LogTab.LABEL_LEVEL)) {
            uniqvalues = this.logModel.getUniqLogLevels();
        } else if (this.columnName.equals(LogTab.LABEL_PID)) {
            uniqvalues = this.logModel.getUniqPids();
        } else if (this.columnName.equals(LogTab.LABEL_TID)) {
            uniqvalues = this.logModel.getUniqTids();
        } else if (this.columnName.equals(LogTab.LABEL_TAG)) {
            uniqvalues = this.logModel.getUniqTags();
        }
        return uniqvalues;
    }

    public LinkedHashMap<String, Boolean> sortHashMapByValues(LinkedHashMap<String, Boolean> passedMap) {
        ArrayList<String> mapKeys = new ArrayList<String>(passedMap.keySet());
        ArrayList<Boolean> mapValues = new ArrayList<Boolean>(passedMap.values());
        Collections.sort(mapValues);
        Collections.reverse(mapValues);
        Collections.sort(mapKeys);
        LinkedHashMap<String, Boolean> sortedMap = new LinkedHashMap<String, Boolean>();
        block0: for (Boolean val : mapValues) {
            Iterator keyIt = mapKeys.iterator();
            while (keyIt.hasNext()) {
                Boolean comp2;
                String key = (String)keyIt.next();
                Boolean comp1 = passedMap.get(key);
                if (!comp1.equals(comp2 = val)) continue;
                keyIt.remove();
                sortedMap.put(key, val);
                continue block0;
            }
        }
        return sortedMap;
    }
}

