/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.toolbar;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.toolbar.DeviceDescriptor;
import org.tizen.common.connection.toolbar.Messages;
import org.tizen.sdblib.IDevice;

public class EmulatorLaunchWorker
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(EmulatorLaunchWorker.class);
    private DeviceDescriptor deviceDescriptor;
    private IProgressMonitor monitor;
    private static final int WAIT_INTERVAL_SEC = 5;
    private static final int WAIT_TOTAL_SEC = 300;
    private boolean finished = false;
    private static final int EXIT_OK = 0;
    private static final int EXIT_TIMEOUT = 1;
    private static final int EXIT_CANCLED = 2;
    private int exitCode = 0;

    public EmulatorLaunchWorker(DeviceDescriptor deviceDescriptor) {
        this.deviceDescriptor = deviceDescriptor;
    }

    public EmulatorLaunchWorker(DeviceDescriptor deviceDescriptor, IProgressMonitor monitor) {
        this(deviceDescriptor);
        this.monitor = monitor;
    }

    @Override
    public void run() {
        SubProgressMonitor subMonitor = new SubProgressMonitor(this.monitor, 10);
        subMonitor.subTask(String.format("Starting a emulator (%s)....", this.deviceDescriptor.getSerialId()));
        IDevice device = null;
        int totalWorked = 0;
        boolean bootingError = false;
        while (!this.finished) {
            if (totalWorked % 30 != 0) {
                this.monitor.worked(1);
            }
            if (totalWorked >= 300) {
                this.logger.error("Timeout to wait for emulator booting done");
                this.exitCode = 1;
                break;
            }
            if (this.monitor.isCanceled()) {
                this.finished = true;
                this.exitCode = 2;
            }
            if ((device = this.deviceDescriptor.getIDevice(true, 5000)) == null) {
                totalWorked += 5;
                continue;
            }
            if (bootingError) {
                this.finished = true;
                break;
            }
            try {
                if (!device.isBootingDone()) continue;
                this.finished = true;
                this.logger.error("Emulator has been booted up: " + this.deviceDescriptor.getSerialId());
                this.exitCode = 0;
                break;
            }
            catch (Exception e) {
                this.logger.error(String.format("Timeout occurred to get (%s) booting done msg: %s", device.getSerialNumber(), e.getMessage()));
                totalWorked += 10;
                bootingError = true;
            }
        }
    }

    public DeviceDescriptor getDeviceDescriptor() {
        return this.deviceDescriptor;
    }

    public boolean isFinished() throws CoreException {
        switch (this.exitCode) {
            case 1: {
                throw new CoreException((IStatus)new Status(4, "org.tizen.common.connection", Messages.ExceptionTimeoutOperation));
            }
            case 2: {
                throw new CoreException((IStatus)new Status(4, "org.tizen.common.connection", Messages.ExceptionCancleOperation));
            }
        }
        return this.finished;
    }

    public void finish() {
        this.finished = true;
    }
}

