/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(usage="usage_MergeBase")
class MergeBase
extends TextBuiltin {
    @Option(name="--all", usage="usage_displayAllPossibleMergeBases")
    private boolean all;
    @Argument(index=1, metaVar="metaVar_commitish", required=true)
    private final List<RevCommit> commits = new ArrayList<RevCommit>();

    MergeBase() {
    }

    @Argument(index=0, metaVar="metaVar_commitish", required=true)
    void commit_0(RevCommit c) {
        this.commits.add(c);
    }

    protected void run() throws Exception {
        RevCommit b;
        int max;
        for (RevCommit c : this.commits) {
            this.argWalk.markStart(c);
        }
        this.argWalk.setRevFilter(RevFilter.MERGE_BASE);
        int n = max = this.all ? Integer.MAX_VALUE : 1;
        while (max-- > 0 && (b = this.argWalk.next()) != null) {
            this.outw.println(b.getId().name());
        }
    }
}

