/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util.url.classpath;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.Assert;
import org.tizen.common.util.StringUtil;

public class Connection
extends URLConnection {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String fqcn;
    protected URL internalUrl = null;

    protected Connection(URL url, String fqcn) {
        super(url);
        this.fqcn = fqcn;
        this.logger.debug("Fully qualified class name :{}", (Object)fqcn);
    }

    @Override
    public void connect() throws IOException {
        Assert.isNull(this.internalUrl);
        String path = StringUtil.trimLeadingCharacter(this.getURL().getPath(), '/');
        Collection<ClassLoader> classLoaders = this.getClassLoaders();
        this.logger.debug("Classloaders :{}", classLoaders);
        for (ClassLoader cl : classLoaders) {
            URL url = cl.getResource(path);
            this.logger.trace("Check url for {} :{}", (Object)path, (Object)url);
            if (url == null) continue;
            this.internalUrl = url;
            this.connected = true;
            return;
        }
        if (this.fqcn == null) {
            this.connected = true;
            return;
        }
        String packageName = StringUtil.removeLastSegment(this.fqcn, ".");
        String fullPath = String.valueOf(StringUtil.trimLeadingCharacter(packageName.replace('.', '/'), '/')) + "/" + path;
        this.logger.trace("Package name :{}, Full path :{}", (Object)packageName, (Object)fullPath);
        for (ClassLoader cl : classLoaders) {
            URL url = cl.getResource(fullPath);
            this.logger.trace("Check url for {} :{}", (Object)fullPath, (Object)url);
            if (url == null) continue;
            this.internalUrl = url;
            this.connected = true;
            return;
        }
    }

    protected Collection<ClassLoader> getClassLoaders() {
        LinkedHashSet<ClassLoader> classLoaders = new LinkedHashSet<ClassLoader>();
        if (Thread.currentThread().getContextClassLoader() != null) {
            classLoaders.add(Thread.currentThread().getContextClassLoader());
        }
        classLoaders.add(Connection.class.getClassLoader());
        classLoaders.add(ClassLoader.getSystemClassLoader());
        return classLoaders;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.internalUrl == null) {
            throw new IOException("resource not found");
        }
        this.logger.trace("Open stream :{}", (Object)this.internalUrl);
        return this.internalUrl.openStream();
    }
}

