/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.ClassNode;

public class
Transformer
implements ClassFileTransformer
{
	@Override
	public
	byte[] transform(
		final ClassLoader loader,
		final String className,
		final Class<?> classBeingRedefined,
		final ProtectionDomain protectionDomain,
		final byte[] bytes
	)
	throws IllegalClassFormatException
	{
		ClassReader	 reader = new ClassReader( bytes );
		ClassNode classNode = new ClassNode();
		reader.accept( classNode, 0 );
		classNode.access &= (~Opcodes.ACC_FINAL);

		final ClassWriter cw =
			new ClassWriter( ClassWriter.COMPUTE_MAXS|ClassWriter.COMPUTE_FRAMES );
		classNode.accept( cw );
		return cw.toByteArray();
	}

}
