/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.core.command;

import static org.junit.Assert.assertEquals;

import java.util.concurrent.atomic.AtomicInteger;

import org.junit.Test;


/**
 * CompositeCommandTest
 *
 * Test case for {@link CompositeCommand}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see CompositeCommandTest
 */
public class
CompositeCommandTest
extends CommandTest
{
	/**
	 * Test {@link CompositeCommand#execute(Executor, ExecutionContext)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see CompositeCommand#execute(Executor, ExecutionContext)
	 */
	@Test
	public
	void
	test_execute()
	throws Exception
	{
		final AtomicInteger value = new AtomicInteger( 1 );
		final AbstractCommand<Object> command1 = new AbstractCommand<Object>()
		{
			
			/* (non-Javadoc)
			 * @see org.tizen.common.core.command.AbstractCommand#run(org.tizen.common.core.command.Executor, org.tizen.common.core.command.ExecutionContext)
			 */
			@Override
			public
			void
			run(
				final Executor executor,
				final ExecutionContext context
			)
			throws Exception
			{
				value.set( value.get() + 1 );
			}
		};
		final AbstractCommand<Object> command2 = new AbstractCommand<Object>()
		{
			
			/* (non-Javadoc)
			 * @see org.tizen.common.core.command.AbstractCommand#run(org.tizen.common.core.command.Executor, org.tizen.common.core.command.ExecutionContext)
			 */
			@Override
			public
			void
			run(
				final Executor executor,
				final ExecutionContext context
			)
			throws Exception
			{
				value.set( value.get() * 3 );
			}
		};
		
		final CompositeCommand commands = new CompositeCommand( command1, command2 );
		commands.run( getExecutor(), getExecutionContext() );
		
		assertEquals( 6, value.get() );
	}

}
