/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.core.command.file;

import static org.junit.Assert.fail;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;

import org.junit.Test;
import org.mockito.Matchers;
import org.tizen.common.file.Filter;
import org.tizen.common.file.SimpleFileFilter;


/**
 * FileHandlingCommandTest.
 *
 * Test case for {@link FileHandlingCommand}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see FileHandlingCommand
 */
public class
FileHandlingCommandTest
{
	
	/**
	 * Test {@link FileHandlingCommand#setFilter(SimpleFileFilter)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see FileHandlingCommand#setFilter(SimpleFileFilter)
	 */
	@Test
	public
	void
	test_setFilter() throws Exception
	{
		// Given
		final FileHandlingCommand<Object> command = new FileHandlingCommand<Object>();
		
		// When & Then
		command.setFilter( new SimpleFileFilter() );
		
		try
		{
			// When
			command.setFilter( null );
			fail();
		}
		catch ( final IllegalArgumentException e )
		{
			// Then
		}
	}
	
	/**
	 * Test {@link FileHandlingCommand#setIncludes(String[])}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see FileHandlingCommand#setIncludes(String[])
	 */
	@Test
	public void test_setIncludes() throws Exception {
		// Given
		final FileHandlingCommand<Object> command = new FileHandlingCommand<Object>();
		SimpleFileFilter mockFilter = mock( SimpleFileFilter.class );
		command.setFilter( mockFilter );
		
		// When
		command.setIncludes( new String[] { "*" } );
		
		// Then
		verify( mockFilter ).clearIncludes();
		verify( mockFilter ).addIncludes( Matchers.<Filter>any() );
		
	}
	
}
