/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.core.command.policy;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.Test;


/**
 * PolicyRegistryTest
 *
 * Test case for {@link PolicyRegistry}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see PolicyRegistry
 */
public class PolicyRegistryTest
{

	/**
	 * Test {@link PolicyRegistry#getPolicy(String)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see PolicyRegistry#getPolicy(String)
	 */
	@Test
	public void test_getPolicy() throws Exception {
		final PolicyRegistry register = new PolicyRegistry();
		
		final AbstractPolicy expected = new AbstractPolicy( "exist.output.file" ) {
			public <T> T adapt(Class<T> clazz) {
				return null;
			}
		};
		
		register.register( expected );
		
		assertNotNull( register.getPolicy( null ) );
		assertNotNull( register.getPolicy( "" ) );
		assertEquals( null, register.getPolicy( "exist" ) );
		assertEquals( null, register.getPolicy( "exist.output" ) );
		assertEquals( expected, register.getPolicy( "exist.output.file.xml" ) );
		assertEquals( expected, register.getPolicy( "exist.output.file" ) );
	}
	
}
