/*
*  Common
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact: 
* GyeongSeok Seo <gyeongseok.seo@samsung.com>
* BonYong Lee <bonyong.lee@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.common.core.command.sdb;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import org.junit.Test;
import org.tizen.common.core.command.CommandTest;
import org.tizen.sdblib.IDevice;

/**
 * DevicesSdbCommandTest
 * 
 * Test case for {@link DevicesSdbCommand}
 * 
 * @author GyeongSeok Seo{@literal <gyeongseok.seo@samsung.com>} (S-Core)
 *
 * @see DevicesSdbCommand
 */
public class
DevicesSdbCommandTest
extends CommandTest
{
    @Test
    public void test_execute() throws Exception {
        DevicesSdbCommand testCommand = new DevicesSdbCommand() {
            @Override
            protected SmartDevelopmentBridgeManager createBridge() {
                SmartDevelopmentBridgeManager mockBridge = mock( SmartDevelopmentBridgeManager.class );
                IDevice mockDevice1 = mock( IDevice.class );
                IDevice mockDevice2 = mock( IDevice.class );
                when( mockDevice1.toString() ).thenReturn( "TizenDevice1" );
                when( mockDevice2.toString() ).thenReturn( "TizenDevice2" );
                when( mockBridge.getDevices() ).thenReturn( new IDevice[] { mockDevice1, mockDevice2 } );
                return mockBridge;
            }
            
        };
        testCommand.run( null, context );
        String result = "TizenDevice1" + System.getProperty("line.separator") + "TizenDevice2" + System.getProperty("line.separator");
        assertEquals( result, testCommand.getResult() );
    }
}
