/*
*  Common
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact: 
* GyeongSeok Seo <gyeongseok.seo@samsung.com>
* BonYong Lee <bonyong.lee@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.common.core.command.sdb;

import static java.lang.Boolean.TRUE;
import static org.mockito.Matchers.any;
import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.mock;
import static org.powermock.api.mockito.PowerMockito.when;

import java.io.IOException;

import org.junit.Test;
import org.tizen.common.core.command.CommandTest;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.service.NullSyncProgressMonitor;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;

/**
 * PushSdbCommandTest
 *
 * Test case for {@link PushSdbCommand}
 * 
 * @author GyeongSeok Seo{@literal <gyeongseok.seo@samsung.com>} (S-Core)
 * 
 * @see PushSdbCommand
 */
public class
PushSdbCommandTest
extends CommandTest
{
    @Test
    public
    void
    test_execute()
    throws Exception
    {
        final IDevice mockDevice = mock( IDevice.class );
        final SyncService mockService = mock( SyncService.class );
        final SyncResult result = mock( SyncResult.class );
        when( mockService.push( any( String[].class ), any( FileEntry.class ), eq( NullSyncProgressMonitor.getInstance() ) ) ).thenReturn( result );
        when( result.isOk() ).thenReturn( TRUE );

        final PushSdbCommand testCommand = new PushSdbCommand( "sourcePath", "targetPath" ) {
            @Override
            protected SyncService getSyncService() throws TimeoutException,
                    SdbCommandRejectedException, IOException {
                return mockService;
            }
        };
        testCommand.setDevice( mockDevice );
        testCommand.run( null, context );
    }
}
