/*
 *  Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.core.command.zip;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.tizen.common.util.IOUtil.tryClose;

import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

import org.junit.Test;
import org.tizen.common.core.command.CommandTest;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.file.FileHandler.Attribute;
import org.tizen.common.file.VirtualFileHandler;

/**
 * JarCommandTest
 *
 * Test case for {@link JarCommand}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see JarCommand
 */
public class JarCommandTest
extends CommandTest
{

    /**
     * Test {@link JarCommand#execute(Executor, ExecutionContext)}
     * 
     * @throws Exception in case of failure in test
     * 
     * @see JarCommand#execute(Executor, ExecutionContext)
     */
    @Test
    public
    void
    test_execute()
    throws Exception
    {
        // Given
        final VirtualFileHandler vfs = (VirtualFileHandler) context.getFileHandler();
        vfs.makeDirectory( "/test" );
        vfs.write( "/test/a.txt", "Hello, World" );
        
        // When
        final JarCommand command = new JarCommand( "/test", "/test.jar" );
        command.run( getExecutor(), getExecutionContext() );
        
        // Then
        assertTrue( (Boolean) vfs.get( "/test.jar", Attribute.EXISTS ) );
        final InputStream in = vfs.read( "/test.jar" );

        final JarInputStream zipIn = new JarInputStream( in );
        try
        {
            final JarEntry en = zipIn.getNextJarEntry();
            assertEquals( "a.txt", en.getName() );
        }
        finally
        {
            tryClose( in );
        }
        
    }
}
