/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.file;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.junit.Assert;
import org.junit.Test;
import org.tizen.common.file.filter.WildCardFilter;
import org.tizen.common.file.filter.WildCardFilterFactory;


/**
 * <p>
 * SimpleFileFilterTest.
 *
 * Test case for {@link SimpleFileFilter}
 * </p>
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see SimpleFileFilter
 */
public class
SimpleFileFilterTest
{
	/**
	 * Test {@link SimpleFileFilter#accept(String, String)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see SimpleFileFilter#accept(String, String)
	 */
	@Test
	public
	void
	test_accept()
	throws Exception
	{
		SimpleFileFilter filter = new SimpleFileFilter();
		filter.addIncludes( new WildCardFilter( "/Test*" ) );
		assertTrue( filter.accept( null, "/Test/Test.txt" ) );
		assertFalse( filter.accept( null, "/test/Test.txt" ) );
		
		filter.addExcludes( new WildCardFilter( "/te*" ) );
		assertFalse( filter.accept( null, "/test/Test.txt" ) );
		
		assertFalse( filter.accept( null, "xxx.txt" ) );
		
		filter.clearIncludes();
		filter.setExcludes( new WildCardFilter( ".*" ), new WildCardFilter( "*~" ) );
		assertTrue( filter.accept( null, "a.a.a." ) );
		assertFalse( filter.accept( null, ".aaa." ) );
		assertTrue( filter.accept( null, "~a~a~a~." ) );
		assertFalse( filter.accept( null, "~a~a~a~" ) );
		assertFalse( filter.accept( null, ".project" ) );
		assertFalse( filter.accept( null, ".classpath" ) );
		assertFalse( filter.accept( null, "viclone.txt~" ) );
		
	}

    @Test
    public void removeFiltersTest() {
        String[] excludes = {"abc", "abc/def", "abc/def/gef"};
        SimpleFileFilter filter = new SimpleFileFilter();
        WildCardFilterFactory wcff = new WildCardFilterFactory();

        Filter test = wcff.create("test");
        filter.addExcludes(test);

        for (String exclude : excludes) {
            filter.addExcludes(wcff.create(exclude));
        }

        filter.removeExcludes(test);
        Assert.assertEquals(excludes.length, filter.getExcludes().length);
    }
}
