/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.file.filter;

import static org.junit.Assert.assertEquals;

import org.junit.Test;


/**
 * <p>
 * WildCardFilterTest.
 * 
 * Test case for {@link WildCardFilter}
 *
 * </p>
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see WildCardFilter
 */
public class
WildCardFilterTest
{
	/**
	 * Test {@link WildCardFilter#accept(String, String)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see WildCardFilter#accept(String, String)
	 */
	@Test
	public void
	test_accept()
	throws Exception
	{
		final Object[][] TEST_CASES = new Object[][] {
		    new Object[] { "*/abc.text", "aaaa/abc.text", true },
		    new Object[] { "*.template", "abc.template", true },
			new Object[] { "aaa*", "aaaa/abc.text", true },
			new Object[] { "aaa*", "aaaa/aaa.text", true },
			new Object[] { "aaa*", "bbb/aaa.text", false },
			new Object[] { "aaa*", "aaaa/aaa33.text", true },
			new Object[] { "aaa*", "aaaa/aa", true },
			new Object[] { ".*", ".text", true },
			new Object[] { "*Test*", "A_Test", true },
			new Object[] { "META-INF/*.*", "META-INF/MANIFEST.MF", true },
			new Object[] { "tizen-web-ui-fw/*", "tizen-web-ui-fw/aaaa.js", true },
			new Object[] { "tizen-web-ui-fw/*", "tizen-web-ui-fw/tizen-web-ui-fw.js", true },
			new Object[] { "tizen-web-ui-fw/*.*", "tizen-web-ui-fw/latest/js/tizen-web-ui-fw.js", true },
			
		};

		int iCase = 0;
		for ( final Object[] TEST_CASE : TEST_CASES )
		{
			++iCase;

			final String pattern = (String) TEST_CASE[0];
			final String path = (String) TEST_CASE[1];
			final boolean expected = (Boolean) TEST_CASE[2];

			// Given
			
			// When
			final WildCardFilter filter = new WildCardFilter();
			filter.setPattern( pattern );
			
			// Then
			assertEquals(
			    iCase + " th test case :" + path + "<" + pattern + ">",
			    expected, filter.accept( "/", path )
			);

		}
	}
	
}
