/*
 * Web IDE - launch
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * GyeongSeok Seo <gyeongseok.seo@samsung.com>
 * BonYong Lee <bonyong.lee@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.launch.context;

import static org.junit.Assert.*;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.spy;

import org.junit.Test;
import org.tizen.common.launch.context.LaunchContext;

/**
 * LaunchContextTest
 * <br>
 * Test case for {@link LaunchContext}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * @author Gyeongseok Seo {@literal <gyeongseok.seo@samsung.com>} (S-Core)
 *
 * @see LaunchContext
 */
public class
LaunchContextTest
{

	/**
	 * Test {@link LaunchContext#getKeys()}
	 * <br>
	 * @throws Exception in case of failure in test
	 * <br>
	 * @see {@link LaunchContext#getKeys()}
	 */
	@Test
	public void
	testGetKeys()
	throws Exception
	{
		LaunchContext ctx = new LaunchContext();
		LaunchContext spy = spy ( ctx );
		assertNotNull( spy.getKeys() );
		
		String mockKeys[] = { "1", "2", "3", "4", "5" };
		String mockValue[] = { "t1", "t2", "t3", "t4", "t5" };

		for ( int i = 0; i < mockKeys.length; i++ ) {
			spy.setValue( mockKeys[i], mockValue[i] );
			verify( spy ).setValue( mockKeys[i], mockValue[i] );
		}

		for ( Object key : spy.getKeys() ) {
			assertTrue( spy.ctxmap.containsKey( key ) );
		}
		verify( spy, times(2) ).getKeys();
	}

	/**
	 * Test {@link LaunchContext#getValue(Object)}
	 * <br>
	 * @throws Exception in case of failure in test
	 * <br>
	 * @see {@link LaunchContext#getValue(Object)}
	 */
	@Test
	public void
	testGetValue()
	throws Exception
	{
		// null test
		LaunchContext ctx = new LaunchContext();
		LaunchContext spy = spy ( ctx );

		spy.setValue(null, null);
		assertNull( spy.getValue(null) );
		verify( spy ).getValue(null);

		spy.setValue(null, "test");
		assertNotNull( spy.getValue(null) );
		assertEquals( "test", spy.getValue(null) );
		verify( spy, times(3) ).getValue(null);

		// object test
		spy.setValue("test1", "tizen1");
		spy.setValue("test2", "tizen2");
		assertEquals( "tizen1", spy.getValue("test1") );
		assertEquals( "tizen2", spy.getValue("test2") );
		verify( spy, times(1) ).getValue("test1");
		verify( spy, times(1) ).getValue("test2");

		spy.setValue( "ctx", ctx);
		assertEquals( ctx,  spy.getValue("ctx") );
		verify( spy, times(1) ).getValue("ctx");
	}

	/**
	 * Test {@link LaunchContext#setValue(Object, Object)}
	 * <br>
	 * @throws Exception in case of failure in test
	 * <br>
	 * @see {@link LaunchContext#setValue(Object, Object)}
	 */
	@Test
	public void
	testSetValue()
	throws Exception
	{
		// null test
		LaunchContext ctx = new LaunchContext();
		LaunchContext spy = spy ( ctx );

		spy.setValue(null, null);
		assertNull( spy.getValue(null) );
		verify( spy ).setValue(null, null);

		spy.setValue(null, "test");
		assertNotNull( spy.getValue(null) );
		assertEquals( "test", spy.getValue(null) );
		verify( spy, times(1) ).setValue(null, "test");

		// object test
		spy.setValue("test1", "tizen1");
		spy.setValue("test2", "tizen2");
		assertEquals( "tizen1", spy.getValue("test1") );
		assertEquals( "tizen2", spy.getValue("test2") );
		verify( spy, times(1) ).setValue("test1", "tizen1");
		verify( spy, times(1) ).setValue("test2", "tizen2");

		spy.setValue( "ctx", ctx);
		assertEquals( ctx,  spy.getValue("ctx") );
		verify( spy, times(1) ).setValue("ctx", ctx);
	}

}
