/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * Ho Namkoong <ho.namkoong@samsung.com> 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */

package org.tizen.common.sdb;

import static org.junit.Assert.*;
import static org.tizen.common.sdb.SdbTestUtil.SDB_PATH;

import org.junit.Test;

/**
 * <p>
 * GetSerialNoTest
 * 
 * Test case for sdb get-serialno
 *
 * </p>
 * 
 * @author Ho Namkoong{@literal <ho.namkoong@samsung.com>} (S-Core)
 */
public class GetSerialNoTest {

    /**
     * Test {sdb get-serialno}
     * 
     * @author Ho Namkoong{@literal <ho.namkoong@samsung.com>} (S-Core)
     */
    @Test
    public void test_getserialno() throws Exception {
        String[] serialNos = SdbTestUtil.getSerialNumber();
        String serialNo = serialNos[0];
        String[] wholeStrings = SdbTestUtil.runAndGetWholeString(String.format("%s -s %s get-serialno", SDB_PATH, serialNo), true);
        assertTrue("cannot parse result of get-serialno", wholeStrings.length > 0);
        assertEquals(serialNo, wholeStrings[0]);
    }

}
