/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * Ho Namkoong <ho.namkoong@samsung.com> 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */

package org.tizen.common.sdb;

import static org.junit.Assert.*;
import static org.tizen.common.sdb.SdbTestUtil.SDB_PATH;

import java.text.MessageFormat;

import org.junit.Test;

/**
 * <p>
 * GetState
 * 
 * Test case for sdb get-state
 *
 * </p>
 * 
 * @author Ho Namkoong{@literal <ho.namkoong@samsung.com>} (S-Core)
 */
public class GetStateTest {

    /**
     * Test {sdb get-serialno}
     * 
     * @author Ho Namkoong{@literal <ho.namkoong@samsung.com>} (S-Core)
     */
    @Test
    public void test_getstate() throws Exception {
        
        String[] serialNos = SdbTestUtil.getSerialNumber();
        String serialNo = serialNos[0];
        String[] states = SdbTestUtil.runAndGetWholeString(String.format("%s -s %s get-state", SDB_PATH, serialNo), true);
        assertTrue("cannot parse result of get-state", states.length > 0);
        assertTrue(MessageFormat.format("unexpected state {0}", states[0]), 
                states[0].equals("offline") || states[0].equals("device"));
    }

}
